package com.ejianc.business.zdssupplier.common.utils;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ejianc.business.zdssupplier.common.consumer.TransferVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.*;
import java.util.concurrent.TimeUnit;

//import com.ejianc.foundation.share.api.IShareCooperateApi;
//import com.ejianc.foundation.share.vo.CooperateVO;
//import com.ejianc.framework.core.exception.BusinessException;

@Component
public class PushSupUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    private final static String UPLOAD_FILE_QUEUE = "upload_file_queue";
    public final static String SSO = "portal";// 登录地址：域名/portal/sso/login

    @Value("${eachLink.host}")
    private String host;

    @Value("${eachLink.appId}")
    private String appId;

    @Value("${eachLink.secret}")
    private String secret;

    @Value("${spring.cloud.config.profile}")
    private String profile;


    @Autowired
    private RabbitTemplate rabbitTemplate;

    /** 无权访问 */
    private static final String noPower = "无权限访问该服务，请先联系管理员进行授权！";

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private ISmsMessageApi smsMessageApi;

    @Autowired
    private EnvironmentTools environmentTools;

//    @Autowired
//    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private SessionManager sessionManager;

    /**
     *
     * 通用接口
     *
     * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
     * @param postData  post方式请求的数据  post方式必填
     * @return
     */
    public CommonResponse<String> exchangeDataWithUniversal(String url, String postData){
        CommonResponse<String> resp = this.exchangeDataWithUniversal(url, RequestMethod.POST, postData);
        return resp;
    }

    /**
     *
     * 通用接口
     *
     * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
     * @param params    参数
     * @return
     */
    public CommonResponse<String> exchangeDataWithUniversal(String url, Map<String, String> params){
        CommonResponse<String> resp = this.exchangeDataWithUniversal(url, JSONObject.toJSONString(params));
        return resp;
    }

    /**
     *
     * 通用接口
     *
     * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
     * @param method    RequestMethod.POST  或者 RequestMethod.GET  必填
     * @param postData  post方式请求的数据  post方式必填
     * @return
     */
    public CommonResponse<String> exchangeDataWithUniversal(String url, RequestMethod method, String postData){
        CommonResponse<String> resp = systemDataPushService.exchangeDataWithUniversal(url, method, postData, appId, secret, host);
        return resp;
    }

    /**
     * 通用接口 携带文件
     *
     * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,注意，工程路径后面需要加上openapi，否则无法调通，必填
     * @param params    参数
     * @return
     */
    public CommonResponse<String> exchangeDataAndFilesWithUniversal(String url, Map<String, String> params){
        CommonResponse<String> resp = this.exchangeDataAndFilesWithUniversal(url, params, null);
        return resp;
    }

    /**
     * 通用接口 携带文件
     *
     * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,注意，工程路径后面需要加上openapi，否则无法调通，必填
     * @param params    参数
     * @param files     文件列表
     * @return
     */
    public CommonResponse<String> exchangeDataAndFilesWithUniversal(String url, Map<String, String> params,
            Map<String, Map<String, InputStream>> files){
        CommonResponse<String> resp = systemDataPushService.exchangeDataAndFilesWithUniversal(url, params, files, appId, secret, host);
        return resp;
    }

    /**
     *
     * 数据流向  私有化平台====调用=>>>>公有云平台 包含文件传输 POST方式
     *
     * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
     * @param supplierId      数据中的供应商ID ，必填
     * @param params          参数
     * @return
     */
    public CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(String url, Map<String, String> params, String supplierId) {
        CommonResponse<String> resp = null;
        if(StringUtils.isEmpty(supplierId)){
            resp = this.exchangeDataAndFilesWithUniversal(url, params);
        } else {
            resp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId, null);
        }
        return resp;
    }

    /**
     *
     * 数据流向  私有化平台====调用=>>>>公有云平台 包含文件传输 POST方式
     *
     * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
     * @param supplierId      数据中的供应商ID ，必填
     * @param params          参数
     * @param files           文件列表
     * @return
     */
    public CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(String url, Map<String, String> params,
            String supplierId, Map<String, Map<String, InputStream>> files) {
        CommonResponse<String> resp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId, files);
        return resp;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity    待推送单据
     * @param systemIdName   当前系统ID名称
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @param url       推送URL
     * @return
     */
    public Long pushBillToSupCenter(JSONObject entity, String systemIdName, String billType, String name, String url) {
        Long sourceId = null;
        String id = entity.getString("id");
        String supplierId = entity.getString("supplierId");
//        //查询该单据是否支持协同分享，则向供方协同服务推送该单据
//        CommonResponse<CooperateVO> resp = shareCooperateApi.queryCooperateBybillTypeCode(code);
//        if (!resp.isSuccess()) {
//            logger.error("根据单据类型-{}查询其协同配置信息失败，{}", code, resp.getMsg());
//            return false;
//        }
//        CooperateVO cooperate = resp.getData();
//        if(new Integer(0).equals(cooperate.getShareFlag())){
//            logger.info("根据单据类型-{}查询，单据-{}协同配置不支持协同分享", code, name);
//            return true;
//        }

        //设置单据当前系统信息
        CommonResponse<String> systemCodeResp = proSupplierApi.getEjcCloudSystemCode();
        if (!systemCodeResp.isSuccess()) {
            logger.error("推送单据-{}-id{}失败，获取当前系统编码失败,{}", name, id, systemCodeResp.getMsg());
            return sourceId;
        }
        entity.put(systemIdName, systemCodeResp.getData());//设置当前系统ID
        //去除租户主键
        if(entity.containsKey("tenantId")){
            entity.remove("tenantId");
        }
        if(entity.containsKey("version")){
            entity.remove("version");
        }
        try {
            // 对单据进行加锁
            BillLockUtil.getLock(billType, Long.valueOf(id));
            Map<String, String> params = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(entity));

            // 查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(Long.valueOf(id), null, null, null);
            if (!fileResp.isSuccess()) {
                logger.error("获取单据-{}id-{}对应附件信息失败, {}", name, id, fileResp.getMsg());
            }
            List<AttachmentVO> fileList = fileResp.getData();
            params.put("fileList", JSONObject.toJSONString(fileList));
            logger.info("向供应商-{}推送单据-{}参数-{}", supplierId, name, JSONObject.toJSONString(params));
            // 推送单据到指定的供方
            CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
            logger.error("单据-{}回写请求结果，{}", name, JSONObject.toJSONString(syncResp));
            if (!syncResp.isSuccess()) {
                logger.error("发送请求推送单据-{}id-{}给供方id-{}失败, {}", name, id, supplierId, syncResp.getMsg());
            }
            if(noPower.equals(syncResp.getData())){
                logger.error("发送请求URL-{}给供方id-{}失败, {}", url, supplierId, syncResp.getData());
            }
            CommonResponse<String> resp = JSONObject.parseObject(syncResp.getData(), CommonResponse.class);
            if (resp.isSuccess()) {
                sourceId = Long.valueOf(resp.getData());
            } else {
                logger.error("供方id-{}处理推送单据-{}id-{}失败, {}", supplierId, name, id, resp.getMsg());
                throw new BusinessException(resp.getMsg());
            }
        } catch (Exception e) {
            logger.error("推送单据-{}id-{}给供方id-{} 异常，", name, id, supplierId, e);
            throw new BusinessException(e.getMessage());
        } finally {
            // 释放单据锁
            BillLockUtil.releaseLock(billType, Long.valueOf(id));
        }
        return sourceId;
    }

    /**
     * 同步单据供应商状态信息
     * @param request    请求头
     * @param entity    待推送单据
     * @param mainClass 待推送单据类型
     * @param statusName   待修改状态字段名称
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @return
     */
    public String syncBillStatus(HttpServletRequest request, JSONObject entity, Class<?> mainClass, String statusName, String billType, String name) {
        if(entity == null) {
            logger.error("单据id-{}查询失败，未查询到单据！", entity.getString("id"));
            return "未查询到单据";
        }
        logger.info("单据-{}接收到数据parameters：{}", name, JSONObject.toJSONString(request.getParameterMap()));
        String authority = request.getHeader("authority");
        String billId = request.getParameter("billId");
        String status = request.getParameter(statusName);
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Long time = Long.valueOf(request.getParameter("supOperateTime"));
        Date supOperateTime = time != null ? new Date(time) : null;
        String fileListStr = request.getParameter("fileList");
        List<AttachmentVO> fileList = JSONObject.parseObject(fileListStr, new TypeReference<List<AttachmentVO>>(){});

        //设置供方签字信息
        entity.put("supOperateTime", supOperateTime);
        entity.put("supOperatorName", supOperatorName);
        entity.put("supOperatorPhone", supOperatorPhone);
        entity.put("supOperatorUserCode", supOperatorUserCode);
        entity.put(statusName, status);// 将单据设置为对应状态

        try {
            //对单据进行加锁
            BillLockUtil.getLock(billType, Long.valueOf(billId));
            //保存单据中附件并获取到上传后附件的Id
            List<Long> attachIds = this.uploadFileFormNet(fileList, billType);
            entity.put("attachIds", attachIds);// 将附件关联在单据中
            //更新单据
            EntityUtil.saveOrUpdate(BeanMapper.map(entity, mainClass));

//            //向单据制单人和经办人推送该消息
//            String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};
//            String createUserCode = entity.getString("createUserCode");
//            String createUserId = this.getCreateUserId(createUserCode);
//            String employeeId = entity.getString("employeeId");
//            String[] receivers = new String[]{createUserId, employeeId};
//            String result = this.sendMsg(channel, receivers, "notice","供方已签字提醒", name + "[" + code + "]供方已签字完成");
//            if (null != result) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(receivers), billId, result);
//            }
        } catch (Exception e) {
            logger.error("单据-{}id-{}状态回写异常，", name, billId, e);
//            return "单据状态回写失败！";
            throw new BusinessException(e.getMessage());
        } finally {
            // 释放单据锁
            BillLockUtil.releaseLock(billType, Long.valueOf(billId));
        }
        return null;
    }

    /**
     * 将推送至供方的单据作废
     * @param entity    待推送单据
     * @param systemIdName   当前系统ID名称
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @return
     */
    public boolean delPushBill(JSONObject entity, String systemIdName, String billType, String name, String url) {
        String id = entity.getString("id");
        String supplierId = entity.getString("supplierId");
//        //查询该单据是否支持协同分享，则向供方协同服务推送该单据
//        CommonResponse<CooperateVO> resp = shareCooperateApi.queryCooperateBybillTypeCode(code);
//        if (!resp.isSuccess()) {
//            logger.error("根据单据类型-{}查询其协同配置信息失败，{}", code, resp.getMsg());
//            throw new BusinessException("审批回调失败，获取单据协同配置失败！");
//        }
//        CooperateVO cooperate = resp.getData();
//        if(cooperate == null || new Integer(0).equals(cooperate.getShareFlag())){
//            logger.info("根据单据类型-{}查询，单据-{}协同配置不支持协同分享", code, name);
//            return true;
//        }

        boolean delSuc = false;

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}id-{}失败，获取当前系统编码失败,{}", name, id, ejcCloudSystemCode.getMsg());
        }
        String systemId = ejcCloudSystemCode.getData();
        //设置当前系统ID
        entity.put(systemIdName, systemId);
        try {
            //对单据进行加锁
            BillLockUtil.getLock(billType, Long.valueOf(id));

            Map<String, String> params = new HashMap<>();
            params.put("sourceId", id);
            params.put("systemId", systemId);

            //推送单据到指定的供方
            logger.info("单据-{}id-{}弃审，通知供方-{}单据作废!", name, id, supplierId);
            CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
            if (!syncResp.isSuccess()) {
                logger.error("发送请求通知供方-{}单据id-{}作废失败, {}", supplierId, id, syncResp.getMsg());
                return delSuc;
            }
            CommonResponse<String> supHandleResp = JSONObject.parseObject(syncResp.getData(), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                delSuc = true;
            } else {
                logger.error("供方-{}处理作废单据-{}id-{}作废失败, {}", supplierId, name, id, supHandleResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", id, e);
        } finally {
            // 释放单据锁
            BillLockUtil.releaseLock(billType, Long.valueOf(id));
        }
        return delSuc;
    }

    /**
     * 保存供方同步单据
     * @param request    请求头
     * @param mainClass 待推送单据类型
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @return
     */
    public Long saveSyncBill(HttpServletRequest request, Class<?> mainClass, String billType, String name) {
        return this.saveSyncBill(request, mainClass, billType, name, true);
    }

    /**
     * 保存供方同步单据
     * @param request    请求头
     * @param mainClass 待推送单据类型
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @param sourceFlag 是否更新sourceId
     * @return
     */
    public Long saveSyncBill(HttpServletRequest request, Class<?> mainClass, String billType, String name, boolean sourceFlag) {
        logger.info("单据-{}进入保存接口>>>>>>>>>>>>>>>>>>>>>>>>", name);
        String transData = request.getParameter("transData");
        String fileListStr = request.getParameter("fileList");
        List<AttachmentVO> fileList = JSONObject.parseObject(fileListStr, new TypeReference<List<AttachmentVO>>(){});
        logger.info("接收到数据transData：{}，fileList：{}", transData, fileList);
        if(StringUtils.isBlank(transData)) {
            throw new BusinessException("单据信息为空！");
        }
        JSONObject saveEntity = JSONObject.parseObject(transData);
        saveEntity.put("sourceId", saveEntity.getLong("id"));
        EntityUtil.clearInvalidData(saveEntity);// 初始化数据
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        for (Field field : fields) {
            if (field.isAnnotationPresent(SubEntity.class) && saveEntity.containsKey(field.getName())) {
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                for(Object obj : saveEntity.getJSONArray(field.getName())){
                    JSONObject detail = (JSONObject) obj;
                    if(sourceFlag){
                        detail.put("sourceId", detail.getLong(subEntity.pidName()));
                        detail.put("sourceDetailId", detail.getLong("id"));
                    }
                    EntityUtil.clearInvalidData(detail);// 初始化数据
                }
            }
        }

        //保存单据中附件并获取到上传后附件的Id
        List<Long> attachIds = this.uploadFileFormNet(fileList, billType);
        saveEntity.put("attachIds", attachIds);

        Long id = EntityUtil.saveOrUpdate(BeanMapper.map(saveEntity, mainClass));
        logger.info("保存接口结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return id;
    }

    /**
     * 单据推送到供方协同服务-更新状态
     * @param entity    待推送单据
     * @param systemIdName   当前系统ID名称
     * @param billType      单据类型主键
     * @param name      单据类型名称
     * @param url       推送URL
     * @return
     */
    public String updateBillStatus(JSONObject entity, String statusName, String systemIdName, String billType, String name, String url, String sourceType) {
        String id = entity.getString("id");
        logger.info("单据-{}id-{}进行更新状态操作！", name, id);
        String sourceId = entity.getString("sourceId");
        String status = entity.getString(statusName);
        String systemId = entity.getString(systemIdName);
        String supplierId = entity.getString("supplierId");
        try {
            //对单据进行加锁
            BillLockUtil.getLock(billType, Long.valueOf(id));

            AttachmentVO file = null;
            if(StringUtils.isNotEmpty(sourceType)){
                // 查询当前单据的签字文件
                CommonResponse<List<AttachmentVO>> attachsResp = attachmentApi.queryListBySourceId(Long.valueOf(id), null, sourceType, null);
                if(attachsResp.isSuccess() && CollectionUtils.isNotEmpty(attachsResp.getData())){
                    file = attachsResp.getData().stream().findFirst().orElse(new AttachmentVO());
                } else {
                    logger.error("查询id-{}当前签字文件-{},信息失败， {}", id, sourceType, attachsResp.getMsg());
                }
            }

            // 回写参数
            Map<String, String> params = new HashMap<>();
            params.put("fileList", JSONObject.toJSONString(Collections.singletonList(file)));
            params.put("billId", createString(sourceId));

            UserContext user = sessionManager.getUserContext();
            params.put("supOperatorName", user.getUserName());
            params.put("supOperatorPhone", user.getUserMobile());
            params.put("supOperatorUserCode", user.getUserCode());
            params.put("supOperateTime", String.valueOf(new Date().getTime()));
            params.put(statusName, status);
            params.put("transData", JSONObject.toJSONString(entity));

            //回写单据状态
            logger.info("单据-{}id-{}更新状态，通知单据推送方systemId-{},参数-{}", name, id, systemId, JSONObject.toJSONString(params));
            CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
            logger.error("单据-{}更新状态回写发送请求结果，{}", name, JSONObject.toJSONString(syncResp));
            if(!syncResp.isSuccess()) {
                logger.error("单据-{}id-{}更新状态回写发送请求失败，{}", name, id, syncResp.getMsg());
//                return name + "更新状态回写发送请求失败";
            }
            if(noPower.equals(syncResp.getData())){
                logger.error("发送请求URL-{}给系统-{}失败, {}", url, systemId, syncResp.getData());
//                return syncResp.getData();
            }
            CommonResponse<String> operateResp = JSONObject.parseObject(syncResp.getData(), CommonResponse.class);
            if(!operateResp.isSuccess()) {
                logger.error("单据-{}id-{}更新状态回调处理失败，{}", name, id, operateResp.getMsg());
//                return "更新状态回调处理失败";
                throw new BusinessException(operateResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("单据-{}id-{}更新状态异常，", name, id, e);
            throw new BusinessException(e.getMessage());
        } finally {
            BillLockUtil.releaseLock(billType, Long.valueOf(id));
        }
        return null;
    }

    /**
     * 通知用户消息
     * @param channel   消息发送渠道
     * @param receivers 接收人
     * @param msgType   消息类型
     * @param subject   消息主题
     * @param content   消息内容
     * @return
     */
    public String sendMsg(String[] channel, String[] receivers, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        // 系统管理员特殊处理
        List<String> user = new ArrayList<>(Arrays.asList(receivers));
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        receivers = user.toArray(new String[user.size()]);

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);// 消息接收人
        parameter.setContent(content);// 消息内容
        parameter.setSubject(subject);// 消息主题
        parameter.setMsgType(msgType);// 消息类型
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);// 消息保存
        parameter.setSendUserId(InvocationInfoProxy.getUserid());// 消息发送人
        parameter.setChannel(channel);// 消息发送渠道

        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 给邮箱发送邮件
     * @param receivers 接收人
     * @param msgType   消息类型
     * @param subject   消息主题
     * @param content   消息内容
     * @param params    扩展参数
     * @return
     */
    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params) {
        return sendEmail(receivers, msgType, subject, content, params, null, null);
    }

    /**
     * 给邮箱发送邮件
     * @param receivers 接收人
     * @param msgType   消息类型
     * @param subject   消息主题
     * @param content   消息内容
     * @param params    扩展参数
     * @return
     */
    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params, String pcUrl, String mobileUrl) {
        logger.info("发送消息开始！===========");
        // 系统管理员特殊处理
        if(receivers != null){
            List<String> user = new ArrayList<>(Arrays.asList(receivers));
            Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
            receivers = user.toArray(new String[user.size()]);
        }
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);// 消息接收人
        parameter.setZdsExtEmailParams(params);// 中电四邮件消息扩展参数
        parameter.setContent(content);// 消息内容
        parameter.setSubject(subject);// 消息主题
        parameter.setMsgType(msgType);// 消息类型
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);// 消息保存
        parameter.setSendUserId(InvocationInfoProxy.getUserid());// 消息发送人
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});// 消息发送渠道
        if(StringUtils.isNotBlank(pcUrl)) {
            parameter.setPcUrl(pcUrl);
        }
        if(StringUtils.isNotBlank(mobileUrl)) {
            parameter.setMobileUrl(mobileUrl);
        }

        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 通知用户短信
     * @param phone 手机号
     * @param templateCode 模板编号
     * @param signName 签名
     * @param params 参数
     * @return
     */
    public String sendSms(String phone, String templateCode, String signName, Map<String, String> params) {
        logger.info("发送消息开始！===========");
        SmsMsgSendParam parameter = new SmsMsgSendParam();
        parameter.setPhone(phone);// 手机号
        parameter.setTemplateCode(templateCode);// 模板编号
        parameter.setSignName(signName);
        parameter.setParams(params);// 参数
        logger.info("发送信息{}", JSONObject.toJSONString(parameter));
        CommonResponse<String> result = smsMessageApi.sendMessage(parameter);
        if (!result.isSuccess()) {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return result.getMsg();
        }
        logger.error("消息发送成功---------------->" + result.getMsg());
        return "发送成功！";
    }

    /**
     * 通知用户短信
     * @param phone 手机号
     * @param templateCode 模板编号
     * @param signName 签名
     * @param params 参数
     * @return
     */
    public String sendSmsNoAuth(String phone, String templateCode, String signName, Map<String, String> params) {
        logger.info("发送消息开始！===========");
        SmsMsgSendParam messageParam = new SmsMsgSendParam();
        messageParam.setPhone(phone);// 手机号
        messageParam.setTemplateCode(templateCode);// 模板编号
        messageParam.setSignName(signName);
        messageParam.setParams(params);// 参数
        logger.info("发送信息{}", JSONObject.toJSONString(messageParam));
        String messageUrl = environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
            CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
            if(response.isSuccess()) {
                logger.info("邀请码短信通知发送成功！{}", phone);
            }else {
                logger.info("邀请码短信通知发送成功 发送失败！{}----{}", phone, responseStr);
            }
            logger.error("消息发送成功---------------->{}" + responseStr);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("短信发送成功 发送失败！{}----{}", phone, e.getMessage());
        }
        return "发送成功！";
    }

    /**
     * 根据人员编码查询人员主键
     * @param userCode
     * @return
     */
    public static String getCreateUserId(String userCode) {
        try {
            MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
            if (StringUtils.isNotBlank(userCode) && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
                String cacheKey = REFER_CACHE_KEY + "idm-employee:" + userCode;
                RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject(cacheValue.toString());
                } else {
                    String referData = getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject(referData);
                    String referUrl = json.get("projectName").toString();
                    Map<String, Object> reflist = new HashMap<>();
                    reflist = (Map<String, Object>) json.get("refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
                    } catch (Exception e) {
                    }
                    if (StringUtils.isNotBlank(jsonbackstr)) {
                        jsonObject = JSON.parseObject(jsonbackstr);
                        redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 5, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
        } catch (Exception e) {
        }
        return userCode;
    }

    /**
     * 通过元数据服务获取实体信息
     * @param referCode
     * @return
     */
    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
        } catch (Exception e) {
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
        }
        return data;
    }

    /**
     * 消息发送MQ队列成功
     * @param body
     * @return
     */
    public String sendMq(TransferVO body) {
        MqMessage mqMessage = new MqMessage();
        HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        body.setAuthority(request.getHeader("authority"));
        if(StringUtils.isEmpty(body.getUrl()) && null != body.getFileId()){
            body.setUrl(host + "/ejc-file-web/attachment/no_auth/download?fileId=" + body.getFileId());
        }
        mqMessage.setBody(body);
        rabbitTemplate.convertAndSend(UPLOAD_FILE_QUEUE + "_" + profile, mqMessage);
        logger.info("MQ队列标识：{}", UPLOAD_FILE_QUEUE + "_" + profile);
        return "消息发送MQ队列成功！";
    }

    /**
     * 根据第三方系统文件下载地址，上传到本地系统
     * @param url   下载地址
     * @param sourceId  业务单据Id
     * @param billType  单据类型编码
     * @param sourceType    业务类型
     * @param authority 上下文信息
     * @return
     */
    public String uploadFileByUrl(String url, String sourceId, String billType, String sourceType, String authority){
        String downloadFileStr = null;
        try {
            logger.info("根据附件地址:{}", url);
            if(StringUtils.isEmpty(url)){
                logger.error("sourceId-{}的url为空！", sourceId);
                return null;
            }
            final HttpResponse response = HttpUtil.createGet(url).executeAsync();
//            logger.info("根据附件地址：{} 下载附件返回信息:{}", url, JSONObject.toJSONString(response.body()));
            Map<String, InputStream> resp = new HashMap();
            String fileName = response.header("Content-Disposition").split(";")[1].split("=")[1];
            fileName = URLDecoder.decode(fileName, "UTF-8");
            resp.put(fileName, new ByteArrayInputStream(response.bodyBytes()));
            logger.info("根据附件地址：{} 下载附件成功:{}", url, fileName);
            Map<String, Map<String, InputStream>> files = new HashMap<>();

            resp.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, resp.get(fileKey));
                files.put(fileKey, file);
            });
            //文件上传
            List<AttachmentVO> attachmentVOS = FileUtil.getInstance().upFile(sourceType, sourceId, billType, files, authority);
            if (CollectionUtils.isNotEmpty(attachmentVOS)){
                AttachmentVO vo = attachmentVOS.get(0);
                return vo.getFilePath();
            }
        } catch (Exception e) {
            logger.error("根据附件地址下载附件失败:{}", e);
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 基于附件下载地址上传
     * @param fileList
     * @param billType
     * @return
     */
    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType) {
        return uploadFileFormNet(fileList, billType, IdWorker.getId(), null);
    }

    /**
     * 基于附件下载地址上传
     * @param fileList
     * @param billType
     * @param sourceId
     * @param sourceType
     * @return
     */
    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType, Long sourceId, String sourceType) {
        fileList.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(fileList)){
            return new ArrayList<>();
        }
        List<Long> attachIds = new ArrayList<>();
        for(AttachmentVO file : fileList){
            UploadFileForNetParam param = new UploadFileForNetParam();
            param.setTenantId(InvocationInfoProxy.getTenantid());
            param.setBillType(billType);
            param.setSourceId(sourceId);
            param.setSourceType(StringUtils.isNotBlank(sourceType) ? sourceType : file.getSourceType());
            String url = host + "/filepreview/" + file.getFilePath();
            param.setFilePathList(Collections.singletonList(url));
            Long id = IdWorker.getId();
            CommonResponse<AttachmentVO> fileResp = attachmentApi.queryDetail(file.getId().toString());
            if (fileResp.isSuccess() && null == fileResp.getData()) {
                id = file.getId();
            }
            param.setNewFileIds(Collections.singletonList(id));
            CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
            if(!resp.isSuccess()){
                logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
            }
            attachIds.add(id);
        }
        return attachIds;
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param fileId
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId) {
        if(null == sourceId){
            sourceId = IdWorker.getId();
        }
        String filePath = this.getFilePath(fileId);
        return this.uploadFileFormNet(billType, sourceId, sourceType, filePath);
    }
    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param fileId
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId, String fileHost) {
        if(null == sourceId){
            sourceId = IdWorker.getId();
        }
        String filePath = this.getFilePath(fileId, fileHost);
        return this.uploadFileFormNet(billType, sourceId, sourceType, filePath, fileHost);
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param filePath
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath, String fileHost) {
        if(StringUtils.isEmpty(filePath)){
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = fileHost + (fileHost.endsWith("/") ? "" : "/") + "filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
        if(!resp.isSuccess()){
            logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
        }
        logger.info("参数-{},附件上传结果-{}", JSONObject.toJSONString(param), resp.getData());
        return id;
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param filePath
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath) {
        if(StringUtils.isEmpty(filePath)){
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = host + "/filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
        if(!resp.isSuccess()){
            logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
        }
        logger.info("参数-{},附件上传结果-{}", JSONObject.toJSONString(param), resp.getData());
        return id;
    }

    /**
     * 查询附件地址
     * @param attachid
     * @return
     */
    public String getFilePath(Long attachid){
        AttachmentVO result = this.getattachById(attachid);
        return result.getFilePath();
    }
    /**
     * 查询附件地址
     * @param attachid
     * @return
     */
    public String getFilePath(Long attachid, String fileHost){
        AttachmentVO result = this.getattachById(attachid, fileHost);
        return result.getFilePath();
    }

    /**
     * 根据attachid查询附件
     * @param attachid
     * @return
     */
    public AttachmentVO getattachById(Long attachid) {
        String url = host + "/ejc-file-web/attachment/no_auth/getattachById";
        Map<String, Object> params = new HashMap<>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader(url, params);
            logger.info("attachid-{},附件查询结果-{}", attachid, responseStr);
            CommonResponse<AttachmentVO> resp = JSON.parseObject(responseStr, new TypeReference<CommonResponse<AttachmentVO>>(){});
            if(!resp.isSuccess()){
                throw new BusinessException(resp.getMsg());
            }
            if(null == resp.getData()){
                return new AttachmentVO();
            }
            return resp.getData();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("attachid-{},附件查询异常-{}", attachid, e.getMessage());
        }
        return new AttachmentVO();
    }
    public AttachmentVO getattachById(Long attachid, String fileHost) {
        String url = fileHost + (fileHost.endsWith("/") ? "" : "/") + "ejc-file-web/attachment/no_auth/getattachById";
        Map<String, Object> params = new HashMap<>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader(url, params);
            logger.info("attachid-{},附件查询结果-{}", attachid, responseStr);
            CommonResponse<AttachmentVO> resp = JSON.parseObject(responseStr, new TypeReference<CommonResponse<AttachmentVO>>(){});
            if(!resp.isSuccess()){
                throw new BusinessException(resp.getMsg());
            }
            if(null == resp.getData()){
                return new AttachmentVO();
            }
            return resp.getData();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("attachid-{},附件查询异常-{}", attachid, e.getMessage());
        }
        return new AttachmentVO();
    }

    /**
     * 根据sourceId和sourceType查询附件
     * @param sourceId
     * @param sourceType
     * @return
     */
    public List<AttachmentVO> queryListBySourceId(Long sourceId, String sourceType) {
        String url = host + "/ejc-file-web/no_auth/api/attachref/queryListBySourceId";
        Map<String, Object> params = new HashMap<>();
        params.put("sourceId", sourceId);
        params.put("sourceType", sourceType);
        try {
            String responseStr = HttpTookit.getAndHeader(url, params);
            logger.info("sourceId-{},sourceType-{},附件查询结果-{}", sourceId, sourceType, responseStr);
            CommonResponse<List<AttachmentVO>> resp = JSON.parseObject(responseStr, new TypeReference<CommonResponse<List<AttachmentVO>>>(){});
            if(!resp.isSuccess()){
                throw new BusinessException(resp.getMsg());
            }
            return resp.getData();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("sourceId-{},sourceType-{},附件查询异常-{}", sourceId, sourceType, e.getMessage());
        }
        return new ArrayList<>();
    }

    /**
     * 获取附件id
     * @param sourceId
     * @param billType
     * @param sourceType
     * @param fileId
     * @return
     */
    public Long getFileId(Long sourceId, String billType, String sourceType, Long fileId) {
        // 查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
        if (!fileResp.isSuccess() || CollectionUtils.isEmpty(fileResp.getData())) {
            logger.error("获取billType-{},sourceId-{},sourceType-{}对应附件信息失败, {}", billType, sourceId, sourceType, fileResp.getMsg());
            Long newId = this.uploadFileFormNet(billType, sourceId, sourceType, fileId);
            return newId;
        }
        List<AttachmentVO> fileList = fileResp.getData();
        return fileList.get(0).getId();
    }

    /**
     * 获取当前登录人
     * @return
     */
    public UserContext getUser(){
        UserContext user = sessionManager.getUserContext();
        return user;
    }

    /**
     * 获取供方登录地址
     * @return
     */
    public String getLoginUrl(){
        return host + "/" + SSO;
    }

    /**
     * 校验业务状态
     * @param voStatus
     * @param entityStatus
     */
    public void validateStatus(String voStatus, String entityStatus) {
        if(PlanConstant.INVITE_STATUS_BACK.equals(voStatus)){
            if(!PlanConstant.INVITE_STATUS_AFFIRM.equals(entityStatus)) {
                logger.error("邀请状态-{}-{}，不允许驳回！", entityStatus, PlanConstant.INVITE_STATUS.get(entityStatus));
                throw new BusinessException("数据已更新，请刷新后操作！");
            }
        }
        if(PlanConstant.INVITE_STATUS_INVALID.equals(voStatus)){
            if(!PlanConstant.INVITE_STATUS_FILL.equals(entityStatus) && !PlanConstant.INVITE_STATUS_BACK.equals(entityStatus)) {
                logger.error("邀请状态-{}-{}，不允许作废！", entityStatus, PlanConstant.INVITE_STATUS.get(entityStatus));
                throw new BusinessException("数据已更新，请刷新后操作！");
            }
        }
    }

    /**
     * 创建String，默认值是空串
     * @param object 需要转换的String
     * @return 转换结果
     */
    public static String createString(Object object){
        if (object == null) return "";
        return String.valueOf(object);
    }

    public static String clearBracket(String content) {
        if(StringUtils.isEmpty(content)){
            return content;
        }
        String pattern = "\\([^)]*\\)";//括号内
        content = content.replaceAll(pattern, "");
        return content;
    }

    public static void main(String[] args) {
//        String url = "https://testscm.cefoc.cn/ejc-file-web/attachment/no_auth/download?fileId=825031772541554707";
//        final HttpResponse response = HttpUtil.createGet(url).executeAsync();
//        String fileName = response.header("Content-Disposition").split(";")[1].split("=")[1];
//        try {
//            fileName = URLDecoder.decode(fileName, "UTF-8");
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        System.out.println(fileName);

        String content = "有限责任公司(自然人投资或控股的法人独资)";
        String pattern = "\\([^)]*\\)";//括号内
        System.out.println(clearBracket(content));
    }
}
