package com.ejianc.business.zdssupplier.material.service;

import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * 物资联系人档案
 * 
 * @author generator
 * 
 */
public interface IMatLinkerService extends IBaseService<MatLinkerEntity> {

    MatLinkerVO saveOrUpdate(MatLinkerVO saveOrUpdateVO);

    MatLinkerVO saveOrUpdate(MatLinkerVO saveOrUpdateVO, String checkFlag, boolean cooFlag);

    List<MatLinkerVO> getBySourceIds(List<String> sourceIds);
    CommonResponse<MatLinkerVO> queryDetailBill(HttpServletRequest request);

    /**
     * 联系人生成协同账号
     * @param linker
     * @param supTenantId
     * @return
     */
    MatLinkerVO createSupAccount(MatLinkerEntity linker, Long supTenantId);

    MatLinkerVO getBySupUserId(Long linkerSupUserId, Long supplierId);

    /**
     * 查询当前联系人变更状态 并修改
     * @param linkerId 联系人id
     * @param changeId 变更单id
     */
    boolean linkerChangeStatus(Long linkerId, Long changeId);

    /**
     * 修改对应联系人状态
     * @param linkerId
     * @param changeStatus
     */
    void upLinkerChangeStatus(Long linkerId, Integer changeStatus, MatLinkerChangeEntity entity);
    void deleteChange(List<Long> linkerId);

    /**
     * 校验手机号唯一性
     * @param linker
     * @return
     */
    Boolean validateUnique(MatLinkerEntity linker, Long id);

    /**
     * 校验手机号唯一性
     * @return
     */
    Boolean validateUnique(List<MatLinkerEntity> linkerList);

    List<MatLinkerEntity> getAllBySupplierIds(List<Long> supplierIds, Integer enableStatus);

    List<Map<String, Object>> getLinkerCreatorInf(List<Long> linkerIds);

    void validateUnique(String name, String mobileLinkPhone);

    void createSupAccount(Long linkerId);
}
