package com.ejianc.business.zdssupplier.material.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeEntity;

import javax.servlet.http.HttpServletRequest;

/**
 * 物资供应商变更
 * 
 * @author generator
 * 
 */
public interface IMatSupplierChangeService extends IBaseService<MatSupplierChangeEntity> {

    MatSupplierChangeVO saveOrUpdate(MatSupplierChangeVO saveOrUpdateVO);

    MatSupplierChangeVO saveChangeBySupplierId(Long id);

    /**
     * 供应商名称调用天眼查
     * @param supplierName
     * @param id
     * @return
     */
    MatSupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id);

    /**
     * 校验是否有在途单据
     * @param id
     * @return
     */
    Boolean validateRunning(Long supplierId, Long id);

    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 同步单据供应商状态信息
     *
     * @param vo
     */
    String updateBillStatus(MatSupplierChangeVO vo);

    /**
     * 同步单据供应商状态信息
     *
     * @param vo
     * @param saveFlag 是否供方推送保存单据
     */
    String updateBillStatus(MatSupplierChangeVO vo, Boolean saveFlag);

    /**
     * 查询对比数据
     * @param changeId
     * @return
     */
    JSONObject contrast(Long changeId);

    /**
     * 生成历史记录
     * @param supplierId
     * @param changeId
     * @return
     */
    Boolean pushToHistory(Long supplierId, Long changeId);

    JSONArray getApprUserList(Long changeId);
}
