package com.ejianc.business.zdssupplier.sub.controller;

import java.io.Serializable;

import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdssupplier.sub.bean.LinkerInviteEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteVO;

/**
 * 分包联系人邀请链接
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("linkerInvite")
public class LinkerInviteController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_LINKER_INVITE";//此处需要根据实际修改

    @Autowired
    private ILinkerInviteService service;

    @Autowired
    private ILinkerAccessService accessService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LinkerInviteVO> saveOrUpdate(@RequestBody LinkerInviteVO saveOrUpdateVO) {
        // 事务控制，代码位置迁移
        SupplierEntity supplier = supplierService.selectById(saveOrUpdateVO.getSupplierId());
        if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
            // 分包商未生成协同租户，则先创建协同租户
            supplierService.createSupTenant(supplier);
        }
    	LinkerInviteVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerInviteVO> queryDetail(Long id) {
    	LinkerInviteEntity entity = service.selectById(id);
    	LinkerInviteVO vo = BeanMapper.map(entity, LinkerInviteVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LinkerInviteVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LinkerInviteVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LinkerInviteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LinkerInviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("linkerName");
        fuzzyFields.add("inviterName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        if(!param.getParams().containsKey("status")){
            param.getParams().put("status", new Parameter(QueryParam.NE, PlanConstant.INVITE_STATUS_APPROVE));
        }
//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LinkerInviteEntity> page = service.queryPage(param,false);
        IPage<LinkerInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LinkerInviteVO> records = BeanMapper.mapList(page.getRecords(), LinkerInviteVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(LinkerInviteVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.IN, ids));
            List<LinkerAccessEntity> list = accessService.queryList(queryParam);
            Map<Long, LinkerAccessEntity> map = list.stream().collect(Collectors.toMap(x->x.getInviteId(), x->x, (v1, v2)->v2));
            for(LinkerInviteVO vo : records){
                if(map.containsKey(vo.getId())){
                    LinkerAccessEntity access = map.get(vo.getId());
                    vo.setAccessId(access.getId());
                    vo.setUserType(access.getUserType());
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LinkerInviteVO>> queryApproveList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("linkerName");
        fuzzyFields.add("inviterName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, PlanConstant.INVITE_STATUS_APPROVE));
        IPage<LinkerInviteEntity> page = service.queryPage(param,false);
        IPage<LinkerInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LinkerInviteVO> records = BeanMapper.mapList(page.getRecords(), LinkerInviteVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(LinkerInviteVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.IN, ids));
            List<LinkerAccessEntity> list = accessService.queryList(queryParam);
            Map<Long, LinkerAccessEntity> map = list.stream().collect(Collectors.toMap(x->x.getInviteId(), x->x, (v1, v2)->v2));
            for(LinkerInviteVO vo : records){
                if(map.containsKey(vo.getId())){
                    LinkerAccessEntity access = map.get(vo.getId());
                    vo.setAccessId(access.getId());
                    vo.setUserType(access.getUserType());
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LinkerInviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LinkerInvite-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLinkerInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LinkerInviteVO>> refLinkerInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LinkerInviteEntity> page = service.queryPage(param,false);
        IPage<LinkerInviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LinkerInviteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 更新单据状态
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/updateBillStatus")
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody LinkerInviteVO vo) {
        String msg = service.updateBillStatus(vo);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

    /**
     * 推送供方
     * @param id
     * @return
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String > test(@RequestParam Long id) {
        LinkerInviteEntity entity = service.selectById(id);
        service.pushBillToSupCenter(entity);
        return CommonResponse.success("操作成功！");
    }
}
