package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierChangeMapper;
import com.ejianc.business.zdssupplier.sub.service.*;
import com.ejianc.business.zdssupplier.sub.vo.*;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包供应商变更
 * 
 * @author generator
 * 
 */
@Service("supplierChangeService")
public class SupplierChangeServiceImpl extends BaseServiceImpl<SupplierChangeMapper, SupplierChangeEntity> implements ISupplierChangeService {

    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_CHANGE";//此处需要根据实际修改
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.分包供应商变更.getCode();
    private static final String BILL_NAME = BillTypeEnum.分包供应商变更.getName();
    private static final String sourceBillType = BillTypeEnum.分包供应商档案.getCode();
    private static final String targetBillType = BillTypeEnum.分包供应商变更.getCode();
    private static final String historyBillType = BillTypeEnum.分包供应商历史.getCode();

    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierChange/syncBillStatus";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private ISupplierHistoryService historyService;

    @Autowired
    private ISupplierChangeCertificateService certService;

    @Autowired
    private ISupplierChangeFlowService flowService;

    @Autowired
    private ISubTypeManagerService subTypeManagerService;

    @Override
    public SupplierChangeVO saveOrUpdate(SupplierChangeVO saveOrUpdateVO) {
        SupplierChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierChangeEntity.class);
        if(null == entity.getId()) {
            SupplierEntity supplier = supplierService.selectById(saveOrUpdateVO.getSupplierId());
            if(!supplier.getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), supplier.getInvokeDate()) == 0){
                throw new BusinessException("供应商名称已修改，请先点击天眼查同步企业信息！");
            }
        } else {
            SupplierChangeEntity data = super.selectById(entity.getId());
            if(!data.getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), data.getInvokeDate()) == 0){
                throw new BusinessException("供应商名称已修改，请先点击天眼查同步企业信息！");
            }
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        }
        super.saveOrUpdate(entity, false);
        SupplierChangeVO vo = BeanMapper.map(entity, SupplierChangeVO.class);
        return vo;
    }

    @Override
    public SupplierChangeVO saveChangeBySupplierId(Long id) {
        SupplierEntity supplier = supplierService.selectById(id);
        SupplierChangeEntity entity = EntityUtil.clearInvalidEntity(supplier, SupplierChangeEntity.class);// 初始化数据，包含子表
        entity.setSupplierId(id);
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        UserContext user = pushSupUtil.getUser();
        entity.setEmployeeId(user.getEmployeeId());
        entity.setEmployeeName(user.getEmployeeName());
        entity.setBillDate(new Date());
        // 保存
        super.saveOrUpdate(entity, false);
        // TODO 同步附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(supplier.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
                String.valueOf(entity.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

        Map<Long, SupplierChangeAttachesEntity> attachMap = entity.getAttachesList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
        Map<Long, SupplierChangeCertificateEntity> certMap = entity.getCertificateList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
        for(SupplierAttachesEntity source : supplier.getAttachesList()){
            if(attachMap.containsKey(source.getId())){

                SupplierChangeAttachesEntity target = attachMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
                        String.valueOf(target.getId()), targetBillType, PlanConstant.FILE_SOURCE_TYPE);
            }
        }
        for(SupplierCertificateEntity source : supplier.getCertificateList()){
            if(certMap.containsKey(source.getId())){
                SupplierChangeCertificateEntity target = certMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.CERT_SOURCE_TYPE,
                        String.valueOf(target.getId()), targetBillType, PlanConstant.CERT_SOURCE_TYPE);
            }
        }

        // 生成历史记录
        this.pushToHistory(entity.getSupplierId(), entity.getId());

        SupplierChangeVO resp = BeanMapper.map(entity, SupplierChangeVO.class);
        resp.setCorpSid(supplier.getCorpSid());
        resp.setCorpErpName(supplier.getCorpErpName());
        resp.setErpType(supplier.getErpType());
        return resp;
    }

    @Override
    public SupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id) {
        if(StringUtils.isEmpty(supplierName)){
            throw new BusinessException("企业名称不能为空！");
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, supplierName));
//        queryParam.getOrderMap().put("invokeDate", QueryParam.DESC);
//        List<SupplierChangeEntity> dataList = super.queryList(queryParam);
//        if(CollectionUtils.isNotEmpty(dataList)){
//            Date invokeDate = dataList.get(0).getInvokeDate();
//            if(invokeDate != null && DateUtil.compareDate(DateUtil.addDays(DateUtil.beginOfDate(invokeDate), 1), new Date()) > 0){
//                throw new BusinessException("一个企业名称当天只能调用一次天眼查，请明天再试！");
//            }
//        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company){
            return new SupplierChangeVO();
        }
        SupplierChangeEntity entity = null;
        if(id != null){
            entity = super.selectById(id);
        }
        if(entity == null){
            SupplierChangeVO vo = this.saveChangeBySupplierId(supplierId);
            entity = BeanMapper.map(vo, SupplierChangeEntity.class);
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(company.getPaidCapitalStr());
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List<BaseCertificateVO> certList = company.getCertiList();
        // 资质列表处理
        List<SupplierChangeCertificateEntity> addList = this.transferCertList(certList, entity.getId());
        if (CollectionUtils.isNotEmpty(addList)){
            entity.setCertificateList(addList);
        }
        super.saveOrUpdate(entity, false);
        SupplierChangeVO vo = BeanMapper.map(entity, SupplierChangeVO.class);
        return vo;
    }

    @Override
    public Boolean validateRunning(Long supplierId, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        param.getParams().put("id", new Parameter(QueryParam.NE, id));
        param.getParams().put("status", new Parameter(QueryParam.IN, "2,3"));// 在途状态
        List<SupplierChangeEntity> list = super.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> billCodes = list.stream().map(SupplierChangeEntity::getCode).collect(Collectors.toSet());
            throw new BusinessException("该供应商存在进行中变更单【" + StringUtils.join(billCodes, ",") + "】，不允许再次发起变更!");
        }
        return true;
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        SupplierChangeEntity saveEntity = JSONObject.parseObject(transData, SupplierChangeEntity.class);
        // 校验是否有在途单据
        this.validateRunning(saveEntity.getSupplierId(), saveEntity.getId());

        // 推送生成
        Long id = pushSupUtil.saveSyncBill(request, SupplierChangeEntity.class, BILL_TYPE, BILL_NAME, false);
        if(null == id) {
            throw new BusinessException("同步数据异常！");
        }
        SupplierChangeEntity entity = super.selectById(id);
        // 生成单据编码
//        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER.toString());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        // MQ同步文件
        List<SupplierChangeAttachesEntity> attachList = entity.getAttachesList();
        List<SupplierChangeCertificateEntity> certList = entity.getCertificateList();
        for(SupplierChangeAttachesEntity attach : attachList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), PlanConstant.FILE_SOURCE_TYPE, attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        for(SupplierChangeCertificateEntity cert : certList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, cert.getId(), PlanConstant.CERT_SOURCE_TYPE, cert.getCertificateFileId());
            cert.setCertificateFileId(fileId);
            cert.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate(entity, false);

        // 生成历史记录
        this.pushToHistory(entity.getSupplierId(), entity.getId());

        // 修改变更状态并生成流水
        SupplierChangeVO vo = new SupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus(PlanConstant.CHANGE_STATUS_AFFIRM);
        vo.setEmployeeId(entity.getEmployeeId());
        vo.setEmployeeName(entity.getEmployeeName());
        vo.setBillDate(entity.getBillDate());
        this.updateBillStatus(vo, true);
        return id;
    }

    @Override
    public String updateBillStatus(SupplierChangeVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(SupplierChangeVO vo, Boolean saveFlag) {
        SupplierChangeEntity entity = super.selectById(vo.getId());
        // 自制变更无需更新状态及生成流水
        if(PlanConstant.SOURCE_TYPE_EL.equals(Integer.valueOf(entity.getSourceType()))){
            return null;
        }
        // 校验业务状态
        pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        // 供方推送无需推送供方
        if(!saveFlag){
            pushSupUtil.updateBillStatus((JSONObject) JSONObject.toJSON(entity), "status", SYSTEM_ID,
                    BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        super.saveOrUpdate(entity);
        if(saveFlag){
            // 供方推送过来的数据操作人为供方登录人，生成流水
            SupplierChangeFlowEntity flow = new SupplierChangeFlowEntity();
            flow.setChangeId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getEmployeeId());
            flow.setOperatorName(vo.getEmployeeName());
            flow.setOperateTime(vo.getBillDate());
            flowService.saveOrUpdate(flow, false);
        } else {
            // 生成流水
            SupplierChangeFlowVO flow = new SupplierChangeFlowVO();
            flow.setChangeId(entity.getId());
            // 更新状态flowType必传，否则流转状态有可能不对应
            flow.setFlowType(StringUtils.isNotEmpty(vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            flowService.saveOrUpdate(flow);
        }
        return null;
    }

    @Override
    public JSONObject contrast(Long changeId) {
        SupplierChangeEntity entity = super.selectById(changeId);
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter(QueryParam.EQ, changeId));
        List<SupplierHistoryEntity> list = historyService.queryList(param);
        SupplierHistoryEntity history = historyService.selectById(list.get(0).getId());
        JSONObject json = new JSONObject();
        json.put("change", BeanMapper.map(entity, SupplierChangeVO.class));
        json.put("source", BeanMapper.map(history, SupplierHistoryVO.class));
        return json;
    }

    @Override
    public Boolean pushToHistory(Long supplierId, Long changeId) {
        SupplierEntity supplier = supplierService.selectById(supplierId);
        // 初始化数据，包含子表
        SupplierHistoryVO save = EntityUtil.clearInvalidEntity(supplier, SupplierHistoryVO.class);
        save.setSupplierId(supplier.getId());
        save.setChangeId(changeId);
        SupplierHistoryVO history = historyService.saveOrUpdate(save);

        // 附件处理
        attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(supplier.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
                String.valueOf(history.getId()), historyBillType, PlanConstant.BILL_SOURCE_TYPE);

        Map<Long, SupplierHistoryAttachesVO> attachMap = history.getAttachesList().stream().collect(Collectors.toMap(x-> null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x->x));
        Map<Long, SupplierHistoryCertificateVO> certMap = history.getCertificateList().stream().collect(Collectors.toMap(x-> null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x->x));

        for(SupplierAttachesEntity source : supplier.getAttachesList()){
            if(attachMap.containsKey(source.getId())){
                SupplierHistoryAttachesVO target = attachMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
                        String.valueOf(target.getId()), historyBillType, PlanConstant.FILE_SOURCE_TYPE);
            }
        }
        for(SupplierCertificateEntity source : supplier.getCertificateList()){
            if(certMap.containsKey(source.getId())){
                SupplierHistoryCertificateVO target = certMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.CERT_SOURCE_TYPE,
                        String.valueOf(target.getId()), historyBillType, PlanConstant.CERT_SOURCE_TYPE);
            }
        }
        return true;
    }

    @Override
    public JSONArray getSupplierApprList(SupplierChangeEntity supplier) {
        JSONArray resp = new JSONArray();
        if(StringUtils.isBlank(supplier.getProfessionId()) && StringUtils.isBlank(supplier.getDepProfessionId())) {
            throw new BusinessException("操作失败，该分包商的发展专业和主导专业都为空，无法获取到对应审核人信息！");
        }

        //根据专业类型 查询主导专业对应的审核人
        if(StringUtils.isNotBlank(supplier.getDepProfessionId())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        } else if(StringUtils.isNotBlank(supplier.getDepProfessionSid())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeSids(Arrays.stream(supplier.getDepProfessionSid().split(",")).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        }

        //若主导专业审核人为空，则获取发展专业对应审核人
        if(resp.size() == 0 && StringUtils.isNotBlank(supplier.getProfessionId())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        }
        return resp;
    }

    @Override
    public JSONArray getSupplierApprList(Long id) {
        SupplierChangeEntity supplier = super.selectById(id);

        return getSupplierApprList(supplier);
    }

    /**
     * 资质列表处理
     * @param certList
     * @param changeId
     * @return
     */
    private List<SupplierChangeCertificateEntity> transferCertList(List<BaseCertificateVO> certList, Long changeId) {
        if (CollectionUtils.isEmpty(certList)) {
            return new ArrayList<>();
        }
        // 资质信息 先查询 根据证书校验
        Map<String, SupplierChangeCertificateEntity> certMap = new HashMap<>();
        if(changeId != null){
            QueryParam param = new QueryParam();
            param.getParams().put("changeId", new Parameter(QueryParam.EQ, changeId));
            List<SupplierChangeCertificateEntity> list = certService.queryList(param);
            certMap = list.stream().collect(Collectors.toMap(e -> e.getCertificateTypeName() + "|" + e.getCertificateNumber(), x -> x, (v1, v2)->v2));
        }
        // 资质等级参照翻译
        Map<String, DefdocDetailVO> defMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(824965747632509009L);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            defMap = resp.getData().stream().collect(Collectors.toMap(x->x.getName(), x->x, (v1, v2)->v2));
        }
        List<SupplierChangeCertificateEntity> addList = new ArrayList<>();
        for (BaseCertificateVO cert : certList) {
            List<String> names = Arrays.asList(cert.getName().split(","));
            for(String name : names){
                SupplierChangeCertificateEntity vo = new SupplierChangeCertificateEntity();
                if (certMap.containsKey(name + "|" + cert.getCode())){
                    vo = certMap.get(name + "|" + cert.getCode());
                }
                vo.setCertificateTypeName(name);
                if(defMap.containsKey(name)){
                    vo.setCertificateTypeId(defMap.get(name).getId());
                    vo.setCertificateTypeCode(defMap.get(name).getCode());
                } else {
                    continue;
                }
                vo.setCertificateNumber(cert.getCode());
                vo.setPeriodOfValidity(cert.getEndDate());
                vo.setSourceType(2);
                addList.add(vo);
            }
        }
        return addList;
    }
}
