/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.mapper.SubTypeManagerMapper;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="subTypeManagerService")
public class SubTypeManagerServiceImpl
extends BaseServiceImpl<SubTypeManagerMapper, SubTypeManagerEntity>
implements ISubTypeManagerService {
    @Override
    public List<SubTypeManagerEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<Long> getSubTypeIdsByUserId(String employeeId) {
        List<Long> resp = new ArrayList<Long>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"manager_id", (Object)employeeId);
        query.eq((Object)"enabled", (Object)1);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = list.stream().filter(item -> null != item.getSubTypeId()).map(SubTypeManagerEntity::getSubTypeId).collect(Collectors.toList());
        }
        return resp;
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeId(Long subTypeId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"sub_type_id", (Object)subTypeId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeIds(List<Long> subTypeIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"sub_type_id", subTypeIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeSids(List<String> subTypeSids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"sub_type_sid", subTypeSids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }
}

