/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.utils;

import com.ejianc.framework.core.kit.time.DateFormatUtil;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ZdsReqUtil {
    private static String ERP_APPID;
    private static String ERP_SECRET;
    private static String ERP_REQ_HOST;
    private static String ERP_DATA_BATCH_SIZE;
    public static final Integer DEFAULT_TIME_OUT;
    public static final int CONN_TIME_OUT = 60000;
    public static final int READ_TIME_OUT = 60000;
    public static final String EMPTY = "00000000-0000-0000-0000-000000000000";

    public static String getErpAppid() {
        return ERP_APPID;
    }

    @Value(value="${erp.appId}")
    public void setErpAppid(String appId) {
        ERP_APPID = appId;
    }

    public static String getErpSecret() {
        return ERP_SECRET;
    }

    @Value(value="${erp.secret}")
    public void setErpSecret(String secret) {
        ERP_SECRET = secret;
    }

    public static String getErpReqHost() {
        return ERP_REQ_HOST;
    }

    @Value(value="${erp.reqHost}")
    public void setErpReqHost(String reqHost) {
        ERP_REQ_HOST = reqHost;
    }

    public static String getErpDataBatchSize() {
        return ERP_DATA_BATCH_SIZE;
    }

    @Value(value="${erp.batchSize:100}")
    public void setErpDataBatchSize(String batchSize) {
        ERP_DATA_BATCH_SIZE = batchSize;
    }

    public static Map<String, String> getErpHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        headers.put("appid", ZdsReqUtil.toMD5(ERP_APPID));
        headers.put("ticket", nowStr);
        headers.put("sign", ZdsReqUtil.toMD5(ERP_SECRET + ZdsReqUtil.toMD5(ERP_APPID) + ZdsReqUtil.toMD5(nowStr)));
        return headers;
    }

    public static Map<String, String> getErpHeaders(String appId, String secret) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        headers.put("appid", ZdsReqUtil.toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", ZdsReqUtil.toMD5(secret + ZdsReqUtil.toMD5(appId) + ZdsReqUtil.toMD5(nowStr)));
        return headers;
    }

    public static void main(String[] args) throws Exception {
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        System.out.println(ZdsReqUtil.toMD5("b6a70a2af8ea494fbda7c9ae118500ea"));
        System.out.println(nowStr);
        System.out.println(ZdsReqUtil.toMD5("11658934fd26400985e1e9d83f6ac7cf" + ZdsReqUtil.toMD5("b6a70a2af8ea494fbda7c9ae118500ea") + ZdsReqUtil.toMD5(nowStr)));
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    static {
        DEFAULT_TIME_OUT = 120000;
    }
}

