/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matLinkerChange")
public class MatLinkerChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatLinkerChangeService service;
    @Autowired
    private IMatLinkerService linkerService;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatLinkerChangeEntity entity = (MatLinkerChangeEntity)((Object)this.service.selectById(billId));
        JSONArray resp = this.supplierService.getApprUserList(entity.getSupplierId());
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8054\u7cfb\u4eba\u6240\u5c5e\u4f9b\u5e94\u5546\u7684\u4f9b\u8d27\u5185\u5bb9\u7269\u8d44\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatLinkerChangeEntity entity = (MatLinkerChangeEntity)((Object)this.service.selectById(billId));
        entity.setReceiveStatus(SupLinkerEnum.\u5ba1\u6279\u4e2d.getCode());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String s;
        MatLinkerChangeEntity entity = (MatLinkerChangeEntity)((Object)this.service.selectById(billId));
        entity.setReceiveStatus(SupLinkerEnum.\u5ba1\u6279\u901a\u8fc7.getCode());
        if (!"1".equals(entity.getSourceType()) && StringUtils.isNotBlank((CharSequence)(s = this.service.pushBill(entity)))) {
            throw new BusinessException(s);
        }
        this.linkerService.upLinkerChangeStatus(entity.getLinkerId(), SupLinkerEnum.\u5df2\u53d8\u66f4.getCode(), entity);
        this.service.saveOrUpdate((Object)entity, false);
        UserContext user = this.sessionManager.getUserContext();
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), entity.getLinkerId(), "linkerChange", billId, true, user.getUserId(), user.getUserName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u65e0\u6cd5\u64a4\u56de!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u65e0\u6cd5\u64a4\u56de!");
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray resp = new JSONArray();
        MatLinkerChangeEntity entity = (MatLinkerChangeEntity)((Object)this.service.selectById(billId));
        resp = this.supplierService.getApprUserList(entity.getSupplierId());
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8054\u7cfb\u4eba\u6240\u5c5e\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        return CommonResponse.success((Object)resp);
    }
}

