/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subSupplierApi/"})
public class SubSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IMatSupplierService matSupplierService;

    @GetMapping(value={"getOneBySourceId"})
    CommonResponse<SupplierVO> getOneBySourceId(@RequestParam(value="sourceId") String sourceId, @RequestParam(required=false) String supplierType) {
        SupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"third_source_id", (Object)sourceId);
        SupplierEntity e = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (SupplierVO)BeanMapper.map((Object)((Object)e), SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneById"})
    CommonResponse<SupplierVO> getOneById(@RequestParam(value="id") Long id) {
        SupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"id", (Object)id);
        SupplierEntity e = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (SupplierVO)BeanMapper.map((Object)((Object)e), SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllByIds"})
    CommonResponse<List<SupplierVO>> getAllByIds(@RequestBody List<Long> ids) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllBySourceIds"})
    CommonResponse<List<SupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"third_source_id", (Collection)params.getJSONArray("sourceIds"));
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneByCode"})
    CommonResponse<SupplierVO> getOneByCode(@RequestParam(value="code") String code) {
        SupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"code", (Object)code);
        SupplierEntity e = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (SupplierVO)BeanMapper.map((Object)((Object)e), SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllByCodes"})
    CommonResponse<List<SupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"code", code);
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getByTenantId"})
    CommonResponse<SupplierVO> getByTenantId(@RequestParam Long tenantId) {
        SupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"tenant", (Object)tenantId);
        SupplierEntity e = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (SupplierVO)BeanMapper.map((Object)((Object)e), SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getByTenantIds"})
    CommonResponse<List<SupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"tenant", tenantIds);
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, SupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"accCoordination"})
    public CommonResponse<SupplierVO> accCoordination(@RequestBody SupplierVO supplierVO) {
        TenantVO tenant;
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierVO.getId()));
        if (!"1".equals(supplier.getCoordination()) && null == (tenant = this.supplierService.createSupTenant(supplier))) {
            return CommonResponse.error((String)"\u751f\u6210\u4f9b\u5e94\u5546\u534f\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierVO.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.map((Object)((Object)supplier), SupplierVO.class));
    }

    @GetMapping(value={"getSystemById"})
    CommonResponse<String> getSystemById(@RequestParam(value="id") Long id) {
        MatSupplierEntity mat;
        String systemId = null;
        SupplierEntity sub = (SupplierEntity)((Object)this.supplierService.selectById(id));
        if (sub != null) {
            systemId = sub.getSystemId();
        }
        if ((mat = (MatSupplierEntity)((Object)this.matSupplierService.selectById(id))) != null) {
            systemId = mat.getSystemId();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)systemId);
    }
}

