/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.bean.PushErpRecordsEntity;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.service.IPushErpRecordsService;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.common.service.ISupplierSyncErpService;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeAttachesService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeBankService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeCertificateService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerChangeService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupSubDelParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeAttachesVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeBankVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeCertificateVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IDeptApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IPostApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierService")
public class SupplierServiceImpl
extends BaseServiceImpl<SupplierMapper, SupplierEntity>
implements ISupplierService,
ISupplierSyncErpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private CoordinationUtil coordinationUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private IZDSSubTypeApi subTypeApi;
    @Autowired
    private IBankService bankService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPostApi postApi;
    @Autowired
    private IDeptApi deptApi;
    @Autowired
    private ISupplierChangeBankService supplierChangeBankService;
    @Autowired
    private ISupplierChangeCertificateService changeCertificateService;
    @Autowired
    private ISupplierChangeAttachesService changeAttachesService;
    @Autowired
    private ISupplierManagerChangeService managerChangeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISupplierAccessService supplierAccessService;
    @Autowired
    private IBankCategoryService bankCategoryService;
    @Autowired
    private ISubTypeManagerService subTypeManagerService;
    @Autowired
    private IPushErpRecordsService pushErpRecordsService;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    private static final String ERP_SUB_SUPPLIER_UPDATE_URL = "/cefoc/yql/SubContractorList?OID=";

    @Override
    public SupplierVO saveOrUpdate(SupplierVO saveOrUpdateVO) {
        return this.saveOrUpdateSupInfo(saveOrUpdateVO, true);
    }

    @Override
    public SupplierVO saveOrUpdateSupInfo(SupplierVO saveOrUpdateVO, boolean cooFlag) {
        SupplierEntity entity = (SupplierEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierEntity.class));
        this.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId(), "\u751f\u6210");
        for (SupplierManagerEntity manager : entity.getManagerList()) {
            if (!"del".equals(manager.getRowState()) || !"1".equals(manager.getCoordination())) continue;
            throw new BusinessException("\u5df2\u751f\u6210\u534f\u540c\u8d26\u53f7\u7684\u9879\u76ee\u7ecf\u7406\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.linkerService.validateUnique(entity.getLinkerList());
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getCode()) && (entity.getId() == null || entity.getId() == 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        if (cooFlag) {
            if (!"1".equals(entity.getCoordination())) {
                this.createSupTenant(entity);
            }
            for (LinkerEntity linker : entity.getLinkerList()) {
                if (!"1".equals(linker.getCoordination())) continue;
                this.linkerService.createSupAccount(linker, entity.getTenant());
            }
        }
        return (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initCooInfo(Long supplierId) {
        SupplierEntity entity = (SupplierEntity)((Object)super.selectById((Serializable)supplierId));
        if (!"1".equals(entity.getCoordination())) {
            this.createSupTenant(entity);
        }
        for (LinkerEntity linker : entity.getLinkerList()) {
            if (!"1".equals(linker.getCoordination())) continue;
            this.linkerService.createSupAccount(linker, entity.getTenant());
        }
    }

    @Override
    public List<SupplierEntity> getAllByIds(List<Long> supplierIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"id", supplierIds);
        return super.list((Wrapper)query);
    }

    @Override
    public CommonResponse<IPage<SupplierVO>> queryListBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        QueryParam param = (QueryParam)JSONObject.parseObject((String)jsonObject.getString("queryParam"), QueryParam.class);
        String tenantId = (String)jsonObject.get((Object)"tenantId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public CommonResponse<SupplierEntity> queryDetailBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava((String)request.getParameter("transData"));
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}", (Object)transData);
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        String tenant = jsonObject.getString("tenant");
        Long id = jsonObject.getLong("id");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != id) {
            queryWrapper.eq((Object)"id", (Object)id);
        } else {
            queryWrapper.eq((Object)"tenant", (Object)tenant);
        }
        List list = super.list((Wrapper)queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01");
        }
        SupplierEntity supplierEntity = (SupplierEntity)((Object)list.get(0));
        SupplierEntity entity = (SupplierEntity)((Object)super.selectById((Serializable)supplierEntity.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @Override
    public TenantVO createSupTenant(SupplierEntity supplier) {
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", "sub");
        reqParam.put("supplierName", supplier.getName() + "-\u5206\u5305");
        reqParam.put("supplierId", supplier.getId().toString());
        TenantVO vo = this.coordinationUtil.createSupTenant(reqParam);
        supplier.setCoordination("1");
        supplier.setTenant(vo.getId());
        supplier.setTenantName(vo.getName());
        supplier.setSystemId(vo.getEnterpriseId().toString());
        super.saveOrUpdate((Object)supplier, false);
        return vo;
    }

    @Override
    public SupplierVO getByTenantId(Long supplierTenant) {
        SupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant", (Object)supplierTenant);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        SupplierEntity e = (SupplierEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (SupplierVO)BeanMapper.map((Object)((Object)e), SupplierVO.class);
        }
        return resp;
    }

    @Override
    public List<SupplierEntity> getAllByThirdSourceIds(ArrayList thirdSourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"third_source_id", (Collection)thirdSourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List resp = super.list((Wrapper)query);
        return resp;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id, String operate) {
        List supplierList;
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(supplierList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u751f\u6210\u6863\u6848\u3010" + ((SupplierEntity)((Object)supplierList.get(0))).getCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d" + operate + "\uff01");
        }
        return true;
    }

    @Override
    public String syncSupplierChangeToErp(SupplierSyncErpParamVO syncParam) {
        this.logger.info("\u63a8\u9001\u5206\u5305\u4f9b\u5e94\u5546-{}\u81f3ERP   start*********", (Object)JSONObject.toJSONString((Object)syncParam));
        String pushResult = null;
        Map<String, String> headers = null;
        PushErpRecordsEntity pushEntity = new PushErpRecordsEntity();
        pushEntity.setBillType("supAdd".equals(syncParam.getSyncType()) ? BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u51c6\u5165.getCode() : ("supChange".equals(syncParam.getSyncType()) ? BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u53d8\u66f4.getCode() : ("linkerAdd".equals(syncParam.getSyncType()) ? BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u51c6\u5165.getCode() : BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u53d8\u66f4.getCode())));
        pushEntity.setPushTypeName(syncParam.getSyncType());
        pushEntity.setOperatorId(syncParam.getOperatorId());
        pushEntity.setOperatorName(syncParam.getOperatorName());
        pushEntity.setPushDate(new Date());
        SupplierSyncParam syncSupParam = new SupplierSyncParam();
        try {
            ArrayList<SupSubDelParamVO> delList = new ArrayList<SupSubDelParamVO>();
            String syncUrl = "supAdd".equals(syncParam.getSyncType()) ? "/cefoc/yql/AddSubContractorList" : "/cefoc/yql/EditSubContractorList";
            SupplierEntity entity = (SupplierEntity)((Object)super.selectById((Serializable)syncParam.getSupplierId()));
            syncSupParam.setSupplierId(entity.getId());
            JSONObject supJson = null;
            if (!"supAdd".equals(syncParam.getSyncType())) {
                supJson = this.getSupErpInfo(syncParam.getSupplierId());
                if (null == supJson && !"ok".equals(supJson.get((Object)"status"))) {
                    this.logger.error("\u4e2d\u7535\u56db \u5206\u5305\u5546id-{}\u63a8\u9001ERP\u5931\u8d25, \u4eceERP\u63a5\u53e3\u83b7\u53d6\u8be5\u5206\u5305\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25!", (Object)syncParam.getSupplierId());
                    pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4eceERP\u63a5\u53e3\u83b7\u53d6\u5f53\u524d\u5206\u5305\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25\uff01";
                    pushEntity.setSucFlag("0");
                    pushEntity.setPushResult("\u5206\u5305\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001,\u4eceERP\u63a5\u53e3\u83b7\u53d6\u5206\u5305\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25\uff01");
                    this.sendMq("push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)pushEntity)));
                    return pushResult;
                }
                pushEntity.setBeforePushSupInfo(supJson.toJSONString());
            }
            JSONArray syncData = this.transferToErpParam(entity, syncParam, delList, supJson);
            pushEntity.setUrl(ZdsReqUtil.getErpReqHost() + syncUrl);
            pushEntity.setData(JSONObject.toJSONString((Object)syncData));
            headers = ZdsReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)(ZdsReqUtil.getErpReqHost() + syncUrl), (String)JSONObject.toJSONString((Object)syncData), headers, (Integer)60000, (Integer)60000);
            this.logger.info("\u5206\u5305\u5546\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{ZdsReqUtil.getErpReqHost() + syncUrl, JSONObject.toJSONString((Object)syncData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            pushEntity.setErpResult(reqJson.toJSONString());
            if ("true".equals(reqJson.getString("status"))) {
                this.logger.info("\u4e2d\u7535\u56db \u5206\u5305\u5546id-{}\u63a8\u9001ERP\u6210\u529f!", (Object)syncParam.getSupplierId());
                pushEntity.setSucFlag("1");
                pushEntity.setPushResult("\u5206\u5305\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001ERP\u6210\u529f\uff01");
            } else {
                this.logger.error("\u4e2d\u7535\u56db \u5206\u5305\u5546id-{}\u63a8\u9001ERP\u5931\u8d25!", (Object)syncParam.getSupplierId());
                pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5305\u5546\u6570\u636e\u63a8\u9001ERP\u5904\u7406\u5931\u8d25\uff01";
                pushEntity.setSucFlag("0");
                pushEntity.setPushResult("\u5206\u5305\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001,ERP\u5904\u7406\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u5546id-{}\u5f02\u5e38\uff0c", (Object)syncParam.getSupplierId(), (Object)e);
            pushEntity.setErpResult("\u63a8\u9001\u5f02\u5e38");
            pushEntity.setSucFlag("0");
            pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5305\u5546\u63a8\u9001ERP\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01";
            pushEntity.setPushResult("\u5206\u5305\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001\uff0c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01");
        }
        syncSupParam.setHandleServiceName("supplierService");
        this.sendMq("push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)pushEntity)));
        if ("1".equals(pushEntity.getSucFlag())) {
            this.sendMq("erp_sup_upd_" + this.profile, JSONObject.toJSONString((Object)syncSupParam));
        }
        this.logger.info("\u63a8\u9001\u5206\u5305\u5546id-{}\u81f3ERP   end*********", (Object)syncParam.getSupplierId());
        return pushResult;
    }

    @Override
    public JSONArray getSupplierApprList(Long supplierId) {
        List<SubTypeManagerEntity> mangers;
        JSONArray resp = new JSONArray();
        SupplierEntity supplier = (SupplierEntity)((Object)super.selectById((Serializable)supplierId));
        if (StringUtils.isBlank((CharSequence)supplier.getProfessionId()) && StringUtils.isBlank((CharSequence)supplier.getDepProfessionId()) && StringUtils.isBlank((CharSequence)supplier.getDepProfessionSid())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u548c\u4e3b\u5bfc\u4e13\u4e1a\u90fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getDepProfessionId())) {
            mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", (Object)item.getManagerId());
                    obj.put("userName", (Object)item.getManagerName());
                    resp.add((Object)obj);
                });
            }
        } else if (StringUtils.isNotBlank((CharSequence)supplier.getDepProfessionSid()) && CollectionUtils.isNotEmpty(mangers = this.subTypeManagerService.getAllBySubTypeSids(Arrays.stream(supplier.getDepProfessionSid().split(",")).collect(Collectors.toList())))) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        if (resp.size() == 0 && StringUtils.isNotBlank((CharSequence)supplier.getProfessionId()) && CollectionUtils.isNotEmpty(mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList())))) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        return resp;
    }

    private JSONArray transferToErpParam(SupplierEntity entity, SupplierSyncErpParamVO syncParam, List<SupSubDelParamVO> delList, JSONObject supErpJson) {
        String corpSid;
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add((Object)data);
        JSONObject supplierJson = new JSONObject();
        if (null != supErpJson && supErpJson.getJSONArray("SubContractorInfo").size() > 0) {
            supplierJson = (JSONObject)supErpJson.getJSONArray("SubContractorInfo").get(0);
        }
        List depSubTypes = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)entity.getDepProfessionId())) {
            CommonResponse subTypeResp = this.subTypeApi.getAllByIds(Arrays.stream(entity.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if (!subTypeResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5546\u53d8\u66f4\u4fe1\u606f\u63a8\u9001ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4e3b\u952e\u4e3a\uff1a{}\u7684\u5206\u5305\u7c7b\u578b\u5931\u8d25: {}", (Object)entity.getDepProfessionId(), (Object)JSONObject.toJSONString((Object)subTypeResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u5206\u5305\u5546\u53d8\u66f4\u4fe1\u606f\u63a8\u9001ERP\u5931\u8d25, \u83b7\u53d6\u4e13\u4e1a\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            depSubTypes = (List)subTypeResp.getData();
            if (CollectionUtils.isEmpty(depSubTypes)) {
                this.logger.error("\u5206\u5305\u5546\u53d8\u66f4\u4fe1\u606f\u63a8\u9001ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\uff1a{}\u7684\u5206\u5305\u7c7b\u578b", (Object)entity.getDepProfessionId());
                throw new BusinessException("\u5206\u5305\u5546\u53d8\u66f4\u4fe1\u606f\u63a8\u9001ERP\u5931\u8d25, \u4e0d\u5b58\u5728\u5339\u914d\u7684\u4e13\u4e1a\u7c7b\u578b\uff01");
            }
        }
        EmployeeVO creator = null;
        if (StringUtils.isNotBlank((CharSequence)entity.getErpCreatorSid())) {
            CommonResponse creatorRes = this.employeeApi.getOneBySourceId(entity.getErpCreatorSid());
            if (!creatorRes.isSuccess()) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f55\u5165\u4ebasid-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)entity.getErpCreatorSid()), (Object)JSONObject.toJSONString((Object)creatorRes));
            }
            if (null == (creator = (EmployeeVO)creatorRes.getData())) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f55\u5165\u4ebasid-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getErpCreatorSid());
            }
        }
        if (StringUtils.isBlank((CharSequence)(corpSid = entity.getCorpSid())) && null != entity.getCorpId()) {
            CommonResponse orgResp = this.orgApi.getOneById(entity.getCorpId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f52\u5c5e\u90e8\u95e8id-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)entity.getCorpId(), (Object)JSONObject.toJSONString((Object)orgResp));
            }
            if (null == orgResp.getData()) {
                this.logger.error("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f52\u5c5e\u90e8\u95e8id-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getCorpId(), (Object)JSONObject.toJSONString((Object)orgResp));
            } else {
                corpSid = ((OrgVO)orgResp.getData()).getSourceId();
            }
        }
        data.put("YQL_SID", StringUtils.isBlank((CharSequence)entity.getThirdSourceId()) ? entity.getId() : entity.getThirdSourceId());
        data.put("CON_EMP_NUM", (Object)(null != creator ? creator.getCode() : null));
        if (null != creator || StringUtils.isNotBlank((CharSequence)entity.getErpRegisterName())) {
            data.put("Register_Name", (Object)(null != creator ? creator.getName() : entity.getErpRegisterName()));
        }
        data.put("Company_Name", (Object)entity.getName());
        data.put("Taxcreditrating", (Object)(StringUtils.isNotBlank((CharSequence)ErpTaxCreditLevelEnum.getByName((String)entity.getTaxCreditLevel())) ? ErpTaxCreditLevelEnum.getByName((String)entity.getTaxCreditLevel()) : ""));
        data.put("OwnerDept", (Object)(StringUtils.isNotBlank((CharSequence)entity.getCorpErpName()) ? entity.getCorpErpName() : (StringUtils.isNotBlank((CharSequence)entity.getCorpName()) ? entity.getCorpName() : "")));
        data.put("OwnerDeptSid", (Object)(StringUtils.isNotBlank((CharSequence)corpSid) ? corpSid : "00000000-0000-0000-0000-000000000000"));
        data.put("CompanyStyle", (Object)ErpCompanyTypeEnums.fuzzyMatchByName((String)(entity.getCompanyType().contains("(") ? entity.getCompanyType().substring(0, entity.getCompanyType().indexOf("(")) : entity.getCompanyType())));
        data.put("Company_LegalPerson", (Object)entity.getLegalPerson());
        data.put("RegistrationCode", (Object)entity.getSocialCreditCode());
        data.put("regStatus", (Object)entity.getBusinessStatus());
        data.put("Paidincapital", (Object)this.handleMnyStr(entity.getPaidCapitalStr()));
        data.put("RegistrationCapital", (Object)this.handleMnyStr(entity.getRegisteredCapitalStr()));
        data.put("Company_Address", (Object)entity.getRegisteredAddress());
        data.put("CompanyStatus", (Object)entity.getCompanyState());
        data.put("OperatingPeriodStart", (Object)(null != entity.getBusinessStatus() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getBusinessStartDate()) : ""));
        data.put("OperatingPeriodEnd", (Object)(null != entity.getBusinessEndDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getBusinessEndDate()) : ""));
        data.put("OperatingRange", (Object)entity.getBusinessScope());
        data.put("ServiceArea", (Object)entity.getIntentName());
        data.put("CompanyType", (Object)entity.getDepProfessionName());
        data.put("CompanyType_Sid", (Object)(CollectionUtils.isNotEmpty(depSubTypes) ? depSubTypes.stream().map(SubTypeVO::getSourceId).collect(Collectors.joining(",")) : entity.getDepProfessionSid()));
        data.put("TotalStaff", (Object)entity.getLaborServNums());
        data.put("MaxLimitConMoney", (Object)(null != entity.getMaxContractOnTimeMny() ? entity.getMaxContractOnTimeMny().toPlainString() : ""));
        data.put("AnnualMaxVertragsbetrag", (Object)(null != entity.getMaxContractOnYearMny() ? entity.getMaxContractOnYearMny().toPlainString() : ""));
        data.put("IsitaOneTimeUse", (Object)entity.getDisposableState());
        data.put("ReasonforOneTimeUse", (Object)entity.getDisposableReason());
        data.put("TypeLabel", (Object)entity.getTypeLabel());
        data.put("IsSupportES", (Object)entity.getSealState());
        data.put("Memo", (Object)entity.getMemo());
        data.put("EntryDept", StringUtils.isNotBlank((CharSequence)entity.getType()) ? PlanConstant.ERP_SUB_INFO_TYPE_MAPPING.get(entity.getType()) : (StringUtils.isNotBlank((CharSequence)entity.getErpType()) ? entity.getErpType() : null));
        data.put("RelatedCompany", (Object)(StringUtils.isNotBlank((CharSequence)entity.getAffiliatedCompanyName()) ? entity.getAffiliatedCompanyName() : ""));
        data.put("RelatedCompanySid", (Object)(StringUtils.isNotBlank((CharSequence)entity.getAffiliatedCompanySid()) ? entity.getAffiliatedCompanySid() : ""));
        if (StringUtils.isNotBlank((CharSequence)entity.getAffiliatedCompany()) && StringUtils.isBlank((CharSequence)entity.getAffiliatedCompanySid())) {
            this.logger.error("\u5206\u5305\u5546id-{}\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5173\u8054\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getId());
            throw new BusinessException("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5173\u8054\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        data.put("RelatedCompanySid", (Object)(StringUtils.isNotBlank((CharSequence)entity.getAffiliatedCompanySid()) ? entity.getAffiliatedCompanySid() : "00000000-0000-0000-0000-000000000000"));
        data.put("C_PS_MESupplierInfoOID", (Object)entity.getThirdSourceId());
        data.put("Ma_id", (Object)entity.getCode());
        this.supplierInfoBaseFill(data, supplierJson);
        JSONArray linkerArr = new JSONArray();
        data.put("ContactList", (Object)linkerArr);
        this.handleSubSupLinker(linkerArr, entity.getLinkerList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), creator, supplierJson.getJSONArray("ContactList"));
        JSONArray projectManagerArr = new JSONArray();
        data.put("ProjectManagerList", (Object)projectManagerArr);
        this.handleSubSupProjectManager(projectManagerArr, entity.getManagerList(), syncParam, creator, entity, delList, supplierJson.getJSONArray("ProjectManagerList"));
        JSONArray bankListArr = new JSONArray();
        data.put("BankList", (Object)bankListArr);
        this.handleSubSupBank(bankListArr, entity.getBankList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("BankList"));
        JSONArray archiveArr = new JSONArray();
        data.put("ArchiveList", (Object)archiveArr);
        this.handleSubSupArchive(archiveArr, entity.getAttachesList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList);
        JSONArray certArr = new JSONArray();
        data.put("QualificationInfoList", (Object)certArr);
        this.handleSubSupCert(certArr, entity.getCertificateList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("QualificationInfoList"));
        return resp;
    }

    private void supplierInfoBaseFill(JSONObject data, JSONObject supplierJson) {
        if (StringUtils.isBlank((CharSequence)data.getString("OwnerDept")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("OwnerDept"))) {
            data.put("OwnerDept", (Object)supplierJson.getString("OwnerDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("OwnerDeptSid")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("OwnerDeptSid"))) {
            data.put("OwnerDeptSid", (Object)supplierJson.getString("OwnerDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("CompanyType")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("CompanyType"))) {
            data.put("CompanyType", (Object)supplierJson.getString("CompanyType"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("CompanyType_Sid")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("CompanyType_Sid"))) {
            data.put("CompanyType_Sid", (Object)supplierJson.getString("CompanyType_Sid"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("CompanyStyle")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("CompanyStyle"))) {
            data.put("CompanyStyle", (Object)supplierJson.getString("CompanyStyle"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("Taxcreditrating")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("Taxcreditrating"))) {
            data.put("Taxcreditrating", (Object)supplierJson.getString("Taxcreditrating"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("EntryDept")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("EntryDept"))) {
            data.put("EntryDept", (Object)supplierJson.getString("EntryDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("ServiceArea")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("ServiceArea"))) {
            data.put("ServiceArea", (Object)supplierJson.getString("ServiceArea"));
        }
    }

    private String handleMnyStr(String mnyStr) {
        if (StringUtils.isBlank((CharSequence)mnyStr)) {
            return "-";
        }
        mnyStr = mnyStr.replaceAll("\u4ebf", "00000000");
        mnyStr = mnyStr.replaceAll("\u5343\u4e07", "0000000");
        mnyStr = mnyStr.replaceAll("\u4e07", "0000");
        mnyStr = mnyStr.replaceAll("\u5343", "000");
        mnyStr = mnyStr.replaceAll("\u767e", "00");
        mnyStr = mnyStr.replaceAll("\u5341", "0");
        mnyStr = mnyStr.replaceAll("\u4eba\u6c11\u5e01", "");
        return mnyStr;
    }

    private void handleSubSupCert(JSONArray certArr, List<SupplierCertificateEntity> certificateList, SupplierSyncErpParamVO syncParam, String supplierSid, SupplierEntity supplier, List<SupSubDelParamVO> delList, JSONArray erpCertArr) {
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("supChange".equals(syncParam.getSyncType())) {
            List<SupplierChangeCertificateVO> changeDelList = this.changeCertificateService.getDeledRecord(syncParam.getChangeId());
            this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        }
        JSONObject certJson = null;
        HashMap<String, JSONObject> erpCertMap = new HashMap<String, JSONObject>();
        if (null != erpCertArr && erpCertArr.size() > 0) {
            for (Object obj : erpCertArr) {
                certJson = (JSONObject)obj;
                erpCertMap.put(certJson.getString("C_PS_QualificationInfoOID"), certJson);
            }
        }
        if (CollectionUtils.isNotEmpty(certificateList)) {
            List docDetailIds = certificateList.stream().map(SupplierCertificateEntity::getCertificateTypeId).collect(Collectors.toList());
            CommonResponse docDetailResp = this.defdocApi.queryDetailListByDetailIds(docDetailIds);
            if (!docDetailResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u6839\u636e\u8d44\u8d28\u6863\u6848Id\u5217\u8868-{}\u83b7\u53d6\u6863\u6848\u8be6\u60c5\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(docDetailIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)docDetailResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u67e5\u8be2\u8d44\u8d28\u7b49\u7ea7\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<Long, DefdocDetailVO> docDetailMap = new HashMap<Long, DefdocDetailVO>();
            if (CollectionUtils.isEmpty((Collection)((Collection)docDetailResp.getData()))) {
                this.logger.error("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u6839\u636e\u8d44\u8d28\u6863\u6848Id\u5217\u8868-{}\u83b7\u53d6\u6863\u6848\u8be6\u60c5\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString(docDetailIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)docDetailResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u67e5\u8be2\u8d44\u8d28\u7b49\u7ea7\u6863\u6848\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            docDetailMap.putAll(((List)docDetailResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            DefdocDetailVO tmpDocDetail = null;
            for (SupplierCertificateEntity cert : certificateList) {
                this.logger.info("\u8d44\u8d28\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)cert), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                tmpDocDetail = (DefdocDetailVO)docDetailMap.get(cert.getCertificateTypeId());
                if (null == tmpDocDetail) {
                    this.logger.error("\u5206\u5305\u5546id-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u8d44\u8d28\u6863\u6848Id-{}\u5339\u914d\u7684\u6863\u6848\u8be6\u60c5", (Object)cert.getSupplierId(), (Object)cert.getCertificateTypeId());
                    throw new BusinessException("\u5206\u5305\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u8d44\u8d28\u767b\u8bb0\u4fe1\u606f\u4e0e\u8d44\u8d28\u6863\u6848\u4e0d\u5339\u914d\uff01");
                }
                certJson = new JSONObject();
                certJson.put("C_PS_QualificationInfoOID", (Object)cert.getThirdSourceId());
                certJson.put("LQualificationcateGoryandevel", (Object)cert.getCertificateTypeName());
                certJson.put("CertificateNumber", (Object)cert.getCertificateNumber());
                certJson.put("C_PS_SubContractorInfo_FK", (Object)supplierSid);
                certJson.put("LQualificationcateGoryandevelsid", (Object)tmpDocDetail.getCode());
                certJson.put("Validityperiod", (Object)(null != cert.getPeriodOfValidity() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)cert.getPeriodOfValidity()) : ""));
                certJson.put("YQL_SID", StringUtils.isBlank((CharSequence)cert.getThirdSourceId()) ? cert.getId() : cert.getThirdSourceId());
                certJson.put("Main_FK", (Object)supplierSid);
                certJson.put("Source", (Object)(Integer.valueOf(2).equals(cert.getSourceType()) ? "\u5929\u773c\u67e5\u6838\u589e" : ""));
                certJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(cert.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != cert.getSourceDetailId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                if (erpCertMap.containsKey(cert.getThirdSourceId())) {
                    this.fillCertInfo(certJson, (JSONObject)erpCertMap.get(cert.getThirdSourceId()));
                }
                certArr.add((Object)certJson);
            }
        }
    }

    private void fillCertInfo(JSONObject certJson, JSONObject erpCertJson) {
        if (StringUtils.isBlank((CharSequence)certJson.getString("LQualificationcateGoryandevel")) && StringUtils.isNotBlank((CharSequence)erpCertJson.getString("LQualificationcateGoryandevel"))) {
            certJson.put("LQualificationcateGoryandevel", (Object)erpCertJson.getString("LQualificationcateGoryandevel"));
        }
        if (StringUtils.isBlank((CharSequence)certJson.getString("LQualificationcateGoryandevelsid")) && StringUtils.isNotBlank((CharSequence)erpCertJson.getString("LQualificationcateGoryandevelsid"))) {
            certJson.put("LQualificationcateGoryandevelsid", (Object)erpCertJson.getString("LQualificationcateGoryandevelsid"));
        }
        if (StringUtils.isBlank((CharSequence)certJson.getString("CertificateNumber")) && StringUtils.isNotBlank((CharSequence)erpCertJson.getString("CertificateNumber"))) {
            certJson.put("CertificateNumber", (Object)erpCertJson.getString("CertificateNumber"));
        }
    }

    private void handleSubSupArchive(JSONArray archiveArr, List<SupplierAttachesEntity> attachesList, SupplierSyncErpParamVO syncParam, String supplierSid, SupplierEntity supplier, List<SupSubDelParamVO> delList) {
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("supChange".equals(syncParam.getSyncType())) {
            List<SupplierChangeAttachesVO> changeDelList = this.changeAttachesService.getDeledRecord(syncParam.getChangeId());
            this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        }
        JSONObject archiveJson = null;
        if (CollectionUtils.isNotEmpty(attachesList)) {
            JSONObject params = new JSONObject();
            List sourceIds = attachesList.stream().map(SupplierAttachesEntity::getFileId).collect(Collectors.toList());
            CommonResponse attachResp = this.attachmentApi.queryAllByIds(sourceIds);
            HashMap<Long, AttachmentVO> attachMap = new HashMap<Long, AttachmentVO>();
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636eId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
            AttachmentVO tmpAttach = null;
            for (SupplierAttachesEntity archive : attachesList) {
                this.logger.info("\u9644\u4ef6\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)archive), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                tmpAttach = (AttachmentVO)attachMap.get(archive.getFileId());
                archiveJson = new JSONObject();
                if (null != tmpAttach) {
                    archiveJson.put("Attach_Name", (Object)archive.getFileName());
                    archiveJson.put("Attach_Extension", (Object)(archive.getFileName().indexOf(".") > 0 ? archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) : tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf("."))));
                    archiveJson.put("Attach_Type", (Object)archive.getFileType());
                    archiveJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    archiveJson.put("YQL_SID", StringUtils.isNotBlank((CharSequence)archive.getThirdSourceId()) ? archive.getThirdSourceId() : archive.getId());
                    archiveJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(archive.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != archive.getThirdSourceId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                    archiveArr.add((Object)archiveJson);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)archive.getThirdSourceId())) continue;
            }
        }
    }

    private void handleSubSupBank(JSONArray bankListArr, List<SupplierBankEntity> bankList, SupplierSyncErpParamVO syncParam, String supplierSid, SupplierEntity supplier, List<SupSubDelParamVO> delList, JSONArray erpBankArr) {
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("supChange".equals(syncParam.getSyncType())) {
            List<SupplierChangeBankVO> changeDelList = this.supplierChangeBankService.getDeledRecord(syncParam.getChangeId());
            this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        }
        JSONObject bankJson = null;
        HashMap<String, JSONObject> erpBankMap = new HashMap<String, JSONObject>();
        if (null != erpBankArr && erpBankArr.size() > 0) {
            for (Object obj : erpBankArr) {
                bankJson = (JSONObject)obj;
                erpBankMap.put(bankJson.getString("C_PS_SubContractorInfo_SubBOID"), bankJson);
            }
        }
        if (CollectionUtils.isNotEmpty(bankList)) {
            List<BankVO> dbBankList = this.bankService.getAllByIds(bankList.stream().filter(item -> null != item.getBankId()).map(SupplierBankEntity::getBankId).collect(Collectors.toList()));
            Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(bankList.stream().map(SupplierBankEntity::getOpenBank).collect(Collectors.toList()));
            HashMap<Long, BankVO> bankMap = new HashMap<Long, BankVO>();
            HashMap<Long, BankCategoryVO> bankCategoryMap = new HashMap<Long, BankCategoryVO>();
            if (CollectionUtils.isNotEmpty(dbBankList)) {
                bankMap.putAll(dbBankList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                List<BankCategoryVO> bankCategory = this.bankCategoryService.getAllByIds(dbBankList.stream().map(BankVO::getCategoryId).collect(Collectors.toList()));
                bankCategoryMap.putAll(bankCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
            BankVO tmpBank = null;
            BankCategoryVO tmpBankCategory = null;
            for (SupplierBankEntity bank : bankList) {
                this.logger.info("\u94f6\u884c\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)bank), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                tmpBank = (BankVO)bankMap.get(bank.getBankId());
                if (null == tmpBank) {
                    BankVO bankVO = tmpBank = bankNameMap.containsKey(bank.getOpenBank()) ? (BankVO)BeanMapper.map((Object)((Object)bankNameMap.get(bank.getOpenBank())), BankVO.class) : null;
                }
                if (null == tmpBank) {
                    this.logger.error("\u5206\u5305\u5546id-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\uff1a{}\u7684\u94f6\u884c\u4fe1\u606f", (Object)bank.getSupplierId(), (Object)bank.getBankId());
                } else {
                    tmpBankCategory = (BankCategoryVO)bankCategoryMap.get(tmpBank.getCategoryId());
                }
                if (null == tmpBankCategory) {
                    this.logger.error("\u5206\u5305\u5546id-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\uff1a{}\u7684\u94f6\u884c\u5206\u7c7b\u4fe1\u606f", (Object)bank.getSupplierId(), (Object)JSONObject.toJSONString((Object)((Object)bank), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                bankJson = new JSONObject();
                bankJson.put("YQL_SID", StringUtils.isBlank((CharSequence)bank.getBankThirdSourceId()) ? bank.getId() : bank.getBankThirdSourceId());
                bankJson.put("AccountType", (Object)(null != bank.getNumberType() ? bank.getNumberType() - 1 + "" : ""));
                bankJson.put("Contact_BankAccount", (Object)bank.getBankNumber());
                if (null != tmpBank) {
                    bankJson.put("SubBankName", (Object)tmpBank.getCategoryName());
                    bankJson.put("SubBankCode", (Object)tmpBank.getSubBankCode());
                    bankJson.put("Province", (Object)tmpBank.getProvinceName());
                    bankJson.put("City", (Object)tmpBank.getCityName());
                    bankJson.put("Contact_Bank", (Object)tmpBank.getName());
                    bankJson.put("Contact_BankNumber", (Object)tmpBank.getCode());
                    bankJson.put("BranchSqe", (Object)tmpBank.getCode());
                    bankJson.put("Whlnam", (Object)tmpBank.getName());
                    bankJson.put("BankInfoOID", (Object)tmpBank.getSourceId());
                }
                if (null != tmpBankCategory) {
                    bankJson.put("BankType", (Object)tmpBankCategory.getCode());
                }
                bankJson.put("Memo", (Object)"");
                bankJson.put("C_PS_SubContractorInfo_FK", (Object)supplierSid);
                bankJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(bank.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != bank.getSourceDetailId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                if (null != tmpBank || !erpBankMap.containsKey(bank.getBankThirdSourceId())) {
                    this.logger.info("\u5206\u5305\u5546\u94f6\u884c\u4fe1\u606f[{}]\u4e0d\u5408\u6cd5\uff0c\u8df3\u8fc7\u63a8\u9001ERP", (Object)JSONObject.toJSONString((Object)((Object)bank)));
                    continue;
                }
                this.fillBankInfo(bankJson, (JSONObject)erpBankMap.get(bank.getBankThirdSourceId()));
                bankListArr.add((Object)bankJson);
            }
        }
    }

    private void fillBankInfo(JSONObject bankJson, JSONObject erpBank) {
        if (StringUtils.isBlank((CharSequence)bankJson.getString("SubBankName")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("SubBankName"))) {
            bankJson.put("SubBankName", (Object)erpBank.getString("SubBankName"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("SubBankCode")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("SubBankCode"))) {
            bankJson.put("SubBankCode", (Object)erpBank.getString("SubBankCode"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Province")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Province"))) {
            bankJson.put("Province", (Object)erpBank.getString("Province"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("City")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("City"))) {
            bankJson.put("City", (Object)erpBank.getString("City"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Contact_Bank")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Contact_Bank"))) {
            bankJson.put("Contact_Bank", (Object)erpBank.getString("Contact_Bank"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Contact_BankNumber")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Contact_BankNumber"))) {
            bankJson.put("Contact_BankNumber", (Object)erpBank.getString("Contact_BankNumber"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("BranchSqe")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("BranchSqe"))) {
            bankJson.put("BranchSqe", (Object)erpBank.getString("BranchSqe"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Whlnam")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Whlnam"))) {
            bankJson.put("Whlnam", (Object)erpBank.getString("Whlnam"));
        }
        if (StringUtils.isNotBlank((CharSequence)erpBank.getString("BankInfoOID"))) {
            bankJson.put("BankInfoOID", (Object)erpBank.getString("BankInfoOID"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("BankType")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("BankType"))) {
            bankJson.put("BankType", (Object)erpBank.getString("BankType"));
        }
    }

    private void handleSubSupProjectManager(JSONArray projectManagerArr, List<SupplierManagerEntity> managerList, SupplierSyncErpParamVO syncParam, EmployeeVO curUser, SupplierEntity supplier, List<SupSubDelParamVO> delList, JSONArray erpManagerArr) {
        if (!"supAdd".equals(syncParam.getSyncType()) && !"supChange".equals(syncParam.getSyncType())) {
            return;
        }
        List<SupplierManagerChangeVO> changeDelList = this.managerChangeService.getDeledRecord(syncParam.getChangeId());
        this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        JSONObject managerJson = null;
        HashMap<String, JSONObject> erpLinkerSourceMap = new HashMap<String, JSONObject>();
        if (null != erpManagerArr && erpManagerArr.size() > 0) {
            for (SupplierManagerEntity obj : erpManagerArr) {
                managerJson = (JSONObject)obj;
                erpLinkerSourceMap.put(managerJson.getString("C_PS_ProjektleiterInfoOID"), managerJson);
            }
        }
        if (CollectionUtils.isNotEmpty(managerList)) {
            for (SupplierManagerEntity manager : managerList) {
                this.logger.info("\u9879\u76ee\u7ecf\u7406\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)manager), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                managerJson = new JSONObject();
                managerJson.put("ContactStatus", null != manager.getProjectManagerStatus() ? manager.getProjectManagerStatus().toString() : null);
                managerJson.put("IDCard", (Object)manager.getIdCardId());
                managerJson.put("IDType", (Object)ErpLinkerCardTypeEnum.getCodeByElCode((Integer)manager.getIdCardType()));
                managerJson.put("ContactName", (Object)manager.getProjectManagerName());
                managerJson.put("Contact_Mobile", (Object)manager.getMobileLinkPhone());
                managerJson.put("Contact_Telephone", (Object)manager.getLinkPhone());
                managerJson.put("Contact_Email", (Object)manager.getElectronicMail());
                managerJson.put("Contact_Address", (Object)manager.getAddress());
                managerJson.put("YQL_SID", StringUtils.isBlank((CharSequence)manager.getThirdSourceId()) ? manager.getId() : manager.getThirdSourceId());
                managerJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(manager.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != manager.getThirdSourceId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                this.fillManagerInfo(managerJson, (JSONObject)erpLinkerSourceMap.get(manager.getThirdSourceId()));
                projectManagerArr.add((Object)managerJson);
            }
        }
    }

    private void fillManagerInfo(JSONObject managerJson, JSONObject managerErpJsono) {
        if (null != managerErpJsono && StringUtils.isBlank((CharSequence)managerJson.getString("ContactStatus")) && StringUtils.isNotBlank((CharSequence)managerErpJsono.getString("ContactStatus"))) {
            managerJson.put("ContactStatus", (Object)managerErpJsono.getString("ContactStatus"));
        }
    }

    private void handleSubSupLinker(JSONArray linkerArr, List<LinkerEntity> linkerList, SupplierSyncErpParamVO syncParam, String supplierSid, EmployeeVO curUser, JSONArray erpLinkerArr) {
        JSONObject linkerJson = null;
        List<LinkerEntity> handleData = linkerList;
        if ("supChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            handleData = handleData.stream().filter(item -> item.getId().equals(syncParam.getLinkerId())).collect(Collectors.toList());
        }
        HashMap<String, JSONObject> erpLinkerSourceMap = new HashMap<String, JSONObject>();
        if (null != erpLinkerArr && erpLinkerArr.size() > 0) {
            for (LinkerEntity obj : erpLinkerArr) {
                linkerJson = (JSONObject)obj;
                erpLinkerSourceMap.put(linkerJson.getString("subA_oid"), linkerJson);
            }
        }
        if (CollectionUtils.isNotEmpty(handleData)) {
            for (LinkerEntity linker : handleData) {
                this.logger.info("\u8054\u7cfb\u4eba\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)linker), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                linkerJson = new JSONObject();
                linkerJson.put("YQL_SID", StringUtils.isBlank((CharSequence)linker.getThirdSourceId()) ? linker.getId() : linker.getThirdSourceId());
                linkerJson.put("ContactState", null != linker.getLinkerStatus() ? linker.getLinkerStatus().toString() : null);
                linkerJson.put("IDType", (Object)ErpLinkerCardTypeEnum.getCodeByElCode((Integer)linker.getIdCardType()));
                linkerJson.put("IDCard", (Object)linker.getIdCardId());
                linkerJson.put("Company_Contact", (Object)linker.getName());
                linkerJson.put("AuthorFlag", null != linker.getUserType() ? Integer.valueOf(Integer.valueOf(1).equals(linker.getUserType()) ? 0 : 1) : null);
                linkerJson.put("lable", (Object)linker.getLinkerMark());
                linkerJson.put("Contact_Mobile", (Object)linker.getMobileLinkPhone());
                linkerJson.put("Contact_Email", (Object)linker.getElectronicMail());
                linkerJson.put("Contact_Address", (Object)linker.getAddress());
                linkerJson.put("Contact_Telephone", (Object)linker.getLinkPhone());
                linkerJson.put("C_PS_SubContractorInfo_FK", (Object)supplierSid);
                this.fillSupLinkerInfo(linkerJson, (JSONObject)erpLinkerSourceMap.get(linker.getThirdSourceId()));
                linkerArr.add((Object)linkerJson);
            }
        }
    }

    private void fillSupLinkerInfo(JSONObject linkerJson, JSONObject erpLinkerJson) {
        if (null != erpLinkerJson) {
            if (StringUtils.isBlank((CharSequence)linkerJson.getString("ContactState")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("ContactState"))) {
                linkerJson.put("ContactState", (Object)erpLinkerJson.getString("ContactState"));
            }
            if (StringUtils.isBlank((CharSequence)linkerJson.getString("AuthorFlag")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("AuthorFlag"))) {
                linkerJson.put("AuthorFlag", (Object)erpLinkerJson.getString("AuthorFlag"));
            }
            if (StringUtils.isBlank((CharSequence)linkerJson.getString("lable")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("lable"))) {
                linkerJson.put("lable", (Object)erpLinkerJson.getString("lable"));
            }
            if (StringUtils.isBlank((CharSequence)linkerJson.getString("ContactType")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("ContactType"))) {
                linkerJson.put("ContactType", (Object)erpLinkerJson.getString("ContactType"));
            }
        }
    }

    @Override
    public String sendMq(String queueName, String body) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)body);
        this.rabbitTemplate.convertAndSend(queueName, (Object)mqMessage);
        this.logger.info("MQ\u961f\u5217\u6807\u8bc6\uff1a{}", (Object)queueName);
        return "\u6d88\u606f\u53d1\u9001MQ\u961f\u5217\u6210\u529f\uff01";
    }

    @Override
    public JSONObject getSupErpInfo(Long supplierId) {
        this.logger.info("\u67e5\u8be2\u5206\u5305\u5546id-{}ERP\u4fe1\u606f", (Object)supplierId);
        SupplierEntity supplier = (SupplierEntity)((Object)super.selectById((Serializable)supplierId));
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL + (StringUtils.isBlank((CharSequence)supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
        String reqResp = null;
        try {
            HashMap param = new HashMap();
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
            this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            return JSONObject.parseObject((String)reqResp);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5206\u5305\u5546ERP\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            JSONObject resp = new JSONObject();
            resp.put("erpResult", reqResp);
            resp.put("status", (Object)"false");
            return resp;
        }
    }

    @Override
    public void syncSupplierErpSid(Long supplierId) {
        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setHandleServiceName("supplierService");
        syncParam.setSupplierId(supplierId);
        syncParam.setDelaySeconds(Integer.valueOf(0));
        syncParam.setRetry(Boolean.valueOf(false));
        this.supplierSync(syncParam);
    }

    @Override
    public boolean supplierSync(SupplierSyncParam supplierSyncParam) {
        block38: {
            try {
                if (null != supplierSyncParam.getDelaySeconds() && supplierSyncParam.getDelaySeconds() > 0) {
                    TimeUnit.SECONDS.sleep(supplierSyncParam.getDelaySeconds().intValue());
                    this.logger.info("********************\u66f4\u65b0\u5206\u5305\u5546\uff1aid-{}\u4fe1\u606f\uff0c{}s\u540e\u5f00\u59cb\u6267\u884c********************", (Object)supplierSyncParam.getSupplierId(), (Object)supplierSyncParam.getDelaySeconds());
                }
            }
            catch (InterruptedException e) {
                this.logger.error("\u66f4\u65b0\u5206\u5305\u5546\uff1aid-{}\u4fe1\u606f\u5ef6\u8fdf{}\u79d2\u5f02\u5e38", new Object[]{supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds(), e});
            }
            this.logger.info("********************\u66f4\u65b0\u5206\u5305\u5546\uff1aid-{}\u4fe1\u606f\u5f00\u59cb********************", (Object)supplierSyncParam.getSupplierId());
            SupplierEntity supplier = (SupplierEntity)((Object)super.selectById((Serializable)supplierSyncParam.getSupplierId()));
            HashMap param = new HashMap();
            String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL + (StringUtils.isBlank((CharSequence)supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
            JSONObject reqJson = null;
            JSONArray pageData = null;
            HashMap<String, String> linkerMap = new HashMap<String, String>();
            HashMap<String, String> bankMap = new HashMap<String, String>();
            HashMap<String, String> managerMap = new HashMap<String, String>();
            HashMap<String, String> attachMap = new HashMap<String, String>();
            HashMap<String, String> certMap = new HashMap<String, String>();
            SupplierSyncParam syncParam = new SupplierSyncParam();
            syncParam.setSupplierId(supplierSyncParam.getSupplierId());
            syncParam.setHandleServiceName("supplierService");
            String queueName = "erp_sup_upd_" + this.profile;
            try {
                Map<String, String> headers = ZDSReqUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), JSONObject.toJSONString((Object)reqJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
                    boolean updateSucFlag = true;
                    pageData = reqJson.getJSONArray("SubContractorInfo");
                    if (pageData.size() == 0) {
                        this.logger.info("\u540c\u6b65ERP\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u5206\u5305\u5546SID-{}\u67e5\u8be2ERP\u4fe1\u606f\u4e3a\u7a7a\uff01");
                        if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                            this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                        }
                        return false;
                    }
                    JSONObject supplierJson = (JSONObject)pageData.get(0);
                    String supplierSid = supplierJson.getString("C_PS_SubContractorInfoOID");
                    if (StringUtil.isBlank((CharSequence)supplierSid)) {
                        this.logger.info("\u540c\u6b65ERP\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25\uff0cERP\u5206\u5305\u5546SID\u4e3a\u7a7a:{}", (Object)JSONObject.toJSONString((Object)pageData));
                        if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                            this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                        }
                        return false;
                    }
                    if (StringUtil.isNotBlank((CharSequence)supplierSid) && StringUtil.isBlank((CharSequence)supplier.getThirdSourceId())) {
                        supplier.setThirdSourceId(supplierSid);
                    }
                    if (null != reqJson.get((Object)"ContactList") && reqJson.getJSONArray("ContactList").size() > 0) {
                        this.handleLinker(linkerMap, reqJson.getJSONArray("ContactList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getLinkerList())) {
                        for (LinkerEntity linker : supplier.getLinkerList()) {
                            if (StringUtil.isNotBlank((CharSequence)linker.getThirdSourceId())) continue;
                            if (linkerMap.containsKey(linker.getId().toString())) {
                                linker.setThirdSourceId((String)linkerMap.get(linker.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u8054\u7cfb\u4ebaid-{}\uff0c SID-{}", (Object)linker.getId(), (Object)linker.getThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("\u5206\u5305\u5546\uff1aid-{} \u4e0eERP\u5206\u5305\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u5339\u914d:{}", (Object)supplier.getId(), (Object)JSONObject.toJSONString(linkerMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"ArchivesList") && reqJson.getJSONArray("ArchivesList").size() > 0) {
                        this.handleArchive(attachMap, reqJson.getJSONArray("ArchivesList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
                        for (SupplierAttachesEntity attach : supplier.getAttachesList()) {
                            if (null == attach.getFileId() || StringUtil.isNotBlank((CharSequence)attach.getThirdSourceId())) continue;
                            if (attachMap.containsKey(attach.getId().toString())) {
                                attach.setThirdSourceId((String)attachMap.get(attach.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u9644\u4ef6id-{}\uff0c SID-{}", (Object)attach.getId(), (Object)attach.getThirdSourceId());
                                continue;
                            }
                            this.logger.error("*********\u5206\u5305\u5546\u9644\u4ef6\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)attach.getId());
                            updateSucFlag = false;
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("\u5206\u5305\u5546\uff1aid-{} \u4e0eERP\u5206\u5305\u5546\u9644\u4ef6\u4fe1\u606f\u4e0d\u5339\u914d:{}", (Object)supplier.getId(), (Object)JSONObject.toJSONString(attachMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"BankList") && reqJson.getJSONArray("BankList").size() > 0) {
                        this.handleBank(bankMap, reqJson.getJSONArray("BankList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getBankList())) {
                        for (SupplierBankEntity bank : supplier.getBankList()) {
                            if (StringUtil.isNotBlank((CharSequence)bank.getBankThirdSourceId())) continue;
                            if (bankMap.containsKey(bank.getId().toString())) {
                                bank.setBankThirdSourceId((String)bankMap.get(bank.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u94f6\u884cid-{}\uff0c SID-{}", (Object)bank.getId(), (Object)bank.getBankThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                            this.logger.error("*********\u5206\u5305\u5546\u9879\u94f6\u884c\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)bank.getId());
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("****************\u5206\u5305\u5546\uff1aid-{} ERP\u5206\u5305\u5546\u94f6\u884c\u4fe1\u606f\u4e0d\u5339\u914d:{}****************", (Object)supplier.getId(), (Object)JSONObject.toJSONString(bankMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"ProjectManagerList") && reqJson.getJSONArray("ProjectManagerList").size() > 0) {
                        this.handleProjectManager(managerMap, reqJson.getJSONArray("ProjectManagerList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getManagerList())) {
                        for (SupplierManagerEntity manager : supplier.getManagerList()) {
                            if (StringUtil.isNotBlank((CharSequence)manager.getThirdSourceId())) continue;
                            if (managerMap.containsKey(manager.getId().toString())) {
                                manager.setThirdSourceId((String)managerMap.get(manager.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u9879\u76ee\u7ecf\u7406id-{}\uff0c SID-{}", (Object)manager.getId(), (Object)manager.getThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                            this.logger.error("*********\u5206\u5305\u5546\u9879\u76ee\u7ecf\u7406\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)manager.getId());
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("****************\u5206\u5305\u5546\uff1aid-{} \u4e0eERP\u5206\u5305\u5546\u9879\u76ee\u7ecf\u7406\u4fe1\u606f\u4e0d\u5339\u914d:{}****************", (Object)supplier.getId(), (Object)JSONObject.toJSONString(managerMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"QualificationInfoList") && reqJson.getJSONArray("QualificationInfoList").size() > 0) {
                        this.handleQualification(certMap, reqJson.getJSONArray("QualificationInfoList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getCertificateList())) {
                        for (SupplierCertificateEntity cert : supplier.getCertificateList()) {
                            if (StringUtil.isNotBlank((CharSequence)cert.getThirdSourceId())) continue;
                            if (certMap.containsKey(cert.getId().toString())) {
                                cert.setThirdSourceId((String)certMap.get(cert.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u8d44\u8d28id-{}\uff0c SID-{}", (Object)cert.getId(), (Object)cert.getThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                            this.logger.error("*********\u5206\u5305\u5546\u8d44\u8d28\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)cert.getId());
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("****************\u5206\u5305\u5546\uff1aid-{} \u4e0eERP\u5206\u5305\u5546\u8d44\u8d28\u4fe1\u606f\u4e0d\u5339\u914d:{}****************", (Object)supplier.getId(), (Object)JSONObject.toJSONString(certMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    this.logger.info("\u66f4\u65b0\u5206\u5305\u5546id-{}\uff0cname-{}ERP SID\u4fe1\u606f\u6210\u529f", (Object)supplier.getId(), (Object)supplier.getName());
                    super.saveOrUpdate((Object)supplier, false);
                } else {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5546\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                    if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                        this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5206\u5305\u5546\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
                if (BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) break block38;
                this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
            }
        }
        this.logger.info("********************\u66f4\u65b0\u5206\u5305\u5546\u4fe1\u606f\u7ed3\u675f********************");
        return false;
    }

    private void handleQualification(Map<String, String> certMap, JSONArray qualificationInfoList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u8d44\u8d28\u8bc1\u4e66\u6570\u636e\uff1a{}\u6761", (Object)qualificationInfoList.size());
        JSONObject tmpQuaJson = null;
        Object tmpQua = null;
        for (Object obj : qualificationInfoList) {
            tmpQuaJson = (JSONObject)obj;
            certMap.put(StringUtil.isNotBlank((CharSequence)tmpQuaJson.getString("YQL_SID")) ? tmpQuaJson.getString("YQL_SID") : tmpQuaJson.getString("C_PS_QualificationInfoOID"), tmpQuaJson.getString("C_PS_QualificationInfoOID"));
        }
    }

    private void handleProjectManager(Map<String, String> managerMap, JSONArray projectManagerList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u9879\u76ee\u7ecf\u7406\u6570\u636e\uff1a{}\u6761", (Object)projectManagerList.size());
        JSONObject tmpManagerJson = null;
        Object tmpManager = null;
        for (Object obj : projectManagerList) {
            tmpManagerJson = (JSONObject)obj;
            managerMap.put(StringUtil.isNotBlank((CharSequence)tmpManagerJson.getString("YQL_SID")) ? tmpManagerJson.getString("YQL_SID") : tmpManagerJson.getString("C_PS_ProjektleiterInfoOID"), tmpManagerJson.getString("C_PS_ProjektleiterInfoOID"));
        }
    }

    private void handleMaterialInfo(Map<String, String> materialInfoMap, JSONArray supplyList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u4f9b\u8d27\u5185\u5bb9\u6570\u636e:{}\u6761", (Object)supplyList.size());
        JSONObject tmpJson = null;
        Object materialInfoEntity = null;
        for (Object obj : supplyList) {
            tmpJson = (JSONObject)obj;
            materialInfoMap.put(StringUtil.isNotBlank((CharSequence)tmpJson.getString("YQL_SID")) ? tmpJson.getString("YQL_SID") : tmpJson.getString("C_PS_MESupplierInfo_SubDOID"), tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
        }
    }

    private void handleBank(Map<String, String> bankMap, JSONArray bankList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u94f6\u884c\u6570\u636e\uff1a{}\u6761", (Object)bankList.size());
        JSONObject tmpBankJson = null;
        Object bankEntity = null;
        for (Object obj : bankList) {
            tmpBankJson = (JSONObject)obj;
            bankMap.put(StringUtil.isNotBlank((CharSequence)tmpBankJson.getString("YQL_SID")) ? tmpBankJson.getString("YQL_SID") : tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID"), tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID"));
        }
    }

    private void handleArchive(Map<String, String> attachMap, JSONArray archiveList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u9644\u4ef6\u6570\u636e\uff1a{}\u6761", (Object)archiveList.size());
        JSONObject tmpAttachJson = null;
        Object attach = null;
        for (Object obj : archiveList) {
            tmpAttachJson = (JSONObject)obj;
            attachMap.put(StringUtil.isNotBlank((CharSequence)tmpAttachJson.getString("YQL_SID")) ? tmpAttachJson.getString("YQL_SID") : tmpAttachJson.getString("C_PS_ArchivesOID"), tmpAttachJson.getString("C_PS_ArchivesOID"));
        }
    }

    private void handleLinker(Map<String, String> linkerMap, JSONArray contactList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)contactList.size());
        Object tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;
        for (Object obj : contactList) {
            tmpLinkerJson = (JSONObject)obj;
            linkerMap.put(StringUtil.isNotBlank((CharSequence)tmpLinkerJson.getString("YQL_SID")) ? tmpLinkerJson.getString("YQL_SID") : tmpLinkerJson.getString("subA_oid"), tmpLinkerJson.getString("subA_oid"));
        }
    }
}

