package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.constants.ERPInquiryStatus;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.InquiryVO;
import com.ejianc.business.zdssupplier.common.constants.SupplierCommonConstants;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.base.Stopwatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 询价接口
 *
 * @author CJ
 * @Description:
 * @date 2024/3/21 20:52
 */
@RestController
@RequestMapping(value = "/inquiry")
public class InquiryController {

    private Logger logger = LoggerFactory.getLogger(InquiryController.class);

    @Autowired
    private IMatSupplierService matSupplierService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IMatLinkerService matLinkerService;

    @Autowired
    private ILinkerService linkerService;

    @Value("${erp.sso.host}")
    private String ERP_SSO_HOST;

     private final String INQUIRY_URL = "/cefoc/yql/TenderingListNew";
     private final String ERP_INQUIRY_SSO_URL = "/SignLogin/SignLogin";

    @GetMapping(value = "/refInquiryData")
    public CommonResponse<JSONObject> refInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            @RequestParam Long supplierTenant, @RequestParam Long linkerSupUserId,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) throws Exception {
        JSONObject resp = new JSONObject();
        resp.put("current", pageNumber);
        resp.put("pageSize", pageSize);

        if(StringUtils.isEmpty(condition) || !JSONObject.parseObject(condition).containsKey("supplierType")){
            return CommonResponse.error("供应商类型为空，查询失败！");
        }
        JSONObject _con = JSONObject.parseObject(condition);
        String supplierType = _con.getString("supplierType");

        String supplierSID = null;
        String linkerSid = null;
        String supplierName = null;
        String linkerName = null;
        if(SupplierCommonConstants.SUPPLIER_MATERIAL.equals(supplierType)) {
            //物资供应商
            MatSupplierVO supplier = matSupplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }

            MatLinkerVO linker = matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName= supplier.getName();
            linkerName = linker.getName();
        } else {
            //分包供应商
            SupplierVO supplier = supplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }
            LinkerVO linker = linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName= supplier.getName();
            linkerName = linker.getName();
        }

        Map<String, String> headers = null;
        Integer queryPageNum = 1;
        Integer queryPageSize = 1000;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + INQUIRY_URL + "?CompanyOID=" + supplierSID ;
        if(StringUtils.isNotBlank(linkerSid)) {
            reqUrl = reqUrl + "&ContactsSid=" + linkerSid + "&ContactsOID=" + linkerSid;
        }
        if(StringUtils.isNotBlank(linkerName)) {
            reqUrl = reqUrl + "&Contacts=" + linkerName;
        }
        headers = ZdsReqUtil.getErpHeaders();
        param.put("PageSize", queryPageSize);
        param.put("PageNum", queryPageNum);

        try {
            Stopwatch start = Stopwatch.createStarted();
            logger.info("供应商name-{},CompanyOID-{},联系人name-{},ContactSid-{}，询价列表查询地址：{}，参数：{}", supplierName, supplierSID,linkerName, linkerSid,
                    reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, ZdsReqUtil.DEFAULT_TIME_OUT, ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();


            JSONObject reqJson = null;
            JSONArray pageData =null;
            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("Tendering");

                if(pageData.size() == 0) {
                    resp.put("total", 0);
                    resp.put("records", new ArrayList<>());
                    return CommonResponse.success(resp);
                }

                JSONObject tmp = null;
                JSONObject inquiry = null;
                InquiryVO tmpInquiry = null;
                List<InquiryVO> records= new ArrayList<>();
                for(Object obj : pageData) {
                    tmp = (JSONObject) obj;
                    //获取不为空个的标段信息
                    inquiry = tmp;
                    tmpInquiry = new InquiryVO();
                    if(StringUtils.isNotBlank(searchText)) {
                        if(!inquiry.getString("Package_Name").contains(searchText) &&
                                !inquiry.getString("TenderContent").contains(searchText) &&
                                !inquiry.getString("Project_Name").contains(searchText)) {
                            continue;
                        }
                    }
                    tmpInquiry.setTitle(inquiry.getString("Package_Name")); //标题
                    tmpInquiry.setId(inquiry.getString("C_SCM_TenderingOID")); //SID
                    tmpInquiry.setContent(inquiry.getString("TenderContent")); //询价内容
                    tmpInquiry.setInquiryRounds(inquiry.getInteger("ProcurePlanNum")); //询价轮次
                    tmpInquiry.setProjectName(inquiry.getString("Project_Name")); //项目名称
                    tmpInquiry.setExecUnitName(inquiry.getString("DeptName")); //执行总部

                    records.add(tmpInquiry);
                }

                int startRn = pageNumber < 1 ? 0 : (pageNumber - 1) * pageSize;
                int endRn = pageNumber < 1 ? pageSize : pageNumber * pageSize;

                resp.put("total", records.size());
                resp.put("records", records.size() > startRn ? records.subList(startRn, records.size() > endRn ? endRn : records.size()) : new ArrayList<>());
                return CommonResponse.success(resp);
            }
        } catch (Exception e) {
            logger.error("根据供应商SID-{}，联系人SID-{}查询供应商询价列表异常，", supplierTenant.toString(), linkerSupUserId.toString(), e);
            return CommonResponse.error("请求ERP获取询价信息失败！");
        }

        return CommonResponse.error("请求ERP获取询价信息失败！");
    }

//    public static void main(String[] args) throws Exception {
//        System.out.println(JSONObject.toJSONString(ZDSReqUtil.getErpHeader("b6a70a2af8ea494fbda7c9ae11850001", "11658934fd26400985e1e9d83f6ac7cf")));
//    }

    @GetMapping(value = "getInquiryList")
    public CommonResponse<JSONObject> getInquiryList(@RequestParam Long supplierTenant,
                                                     @RequestParam Long linkerSupUserId,
                                                     @RequestParam String supplierType) {
        JSONObject resp = new JSONObject();

        String supplierSID = null;
        String linkerSid = null;
        String supplierName = null;
        String linkerName = null;
        if(SupplierCommonConstants.SUPPLIER_MATERIAL.equals(supplierType)) {
            //物资供应商
            MatSupplierVO supplier = matSupplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }

            MatLinkerVO linker = matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName= supplier.getName();
            linkerName = linker.getName();
        } else {
            //分包供应商
            SupplierVO supplier = supplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }
            LinkerVO linker = linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName= supplier.getName();
            linkerName = linker.getName();
        }

        Map<String, String> headers = null;
        Integer pageNum = 1;
        Integer pageSize = 1000;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + INQUIRY_URL + "?CompanyOID=" + supplierSID;
        if(StringUtils.isNotBlank(linkerSid)) {
            reqUrl = reqUrl + "&ContactsSid=" + linkerSid + "&ContactsOID=" + linkerSid;
        }
        if(StringUtils.isNotBlank(linkerName)) {
            reqUrl = reqUrl + "&Contacts=" + linkerName;
        }

        Map<String, InquiryVO> waitMap = new HashMap<>();
        Map<String, InquiryVO> inquiryIngMap = new HashMap<>();
        Map<String, InquiryVO> failedMap = new HashMap<>();
        Map<String, InquiryVO> stopMap = new HashMap<>();
        Map<String, InquiryVO> winMap = new HashMap<>();

        //根据供应商SID+联系人SID查询询价列表
        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            param.put("PageNum", pageNum);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            Stopwatch start = Stopwatch.createStarted();
            logger.info("供应商name-{},CompanyOID-{},联系人name-{},ContactSid-{}，询价列表查询地址：{}，参数：{}", supplierName, supplierSID,linkerName, linkerSid,
                    reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, ZdsReqUtil.DEFAULT_TIME_OUT, ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            logger.info("请求ERP询价列表，结束。共计耗时：「{}」秒", end.elapsed(TimeUnit.SECONDS));
            reqJson = JSONObject.parseObject(reqResp);

                if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("Tendering");
                logger.info("请求ERP询价列表返回数据：{} 条", null != pageData ? pageData.size() : 0);
                handlePageData(pageData,
                        reqJson.getJSONArray("SupplierPriceAud_SubCList"), waitMap,
                        inquiryIngMap, failedMap, stopMap, winMap,
                        reqJson.getJSONArray("SupplierPriceAudList"), supplierSID,
                        reqJson.getJSONArray("SupplierSignupList"), linkerSid);

                resp.put("waitList", waitMap.values());
                resp.put("inquiryingList", inquiryIngMap.values());
                resp.put("failedList", failedMap.values());
                resp.put("stopList", stopMap.values());
                resp.put("winList", waitMap.values());

                logger.info("供应商：sid-{}，name-{}询价统计*************", supplierSID, supplierName);
                logger.info("总数量：{}", (waitMap.size() + inquiryIngMap.size() + failedMap.size() + stopMap.size() + winMap.size()));
                logger.info("待报价数量：{}", waitMap.size());
                logger.info("报价中：{}", inquiryIngMap.size());
                logger.info("未中标数量：{}", failedMap.size());
                logger.info("中止价数量：{}", stopMap.size());
                logger.info("中标数量：{}", winMap.size());

                return CommonResponse.success("查询成功！", resp);
            } else {
                logger.error("请求ERP询价列表失败，参数：{}，结果：{}", JSONObject.toJSONString(param), reqResp);
                return CommonResponse.error("请求ERP获取询价信息失败！");
            }
        } catch (Exception e) {
            logger.error("根据供应商SID-{}，联系人SID-{}查询供应商询价列表异常，", supplierTenant.toString(), linkerSupUserId.toString(), e);
            return CommonResponse.error("请求ERP获取询价信息失败！");
        }
    }

//    public static void main(String[] args) {
//        Map<String, String> headers = null;
//        Integer pageNum = 1;
//        Integer pageSize = 1000;
//        JSONObject param = new JSONObject();
//        String reqUrl =  "http://192.168.211.24/cefoc/yql/TenderingListNew" + "?CompanyOID=000c652f-0000-0000-0000-0000a00131a6&ContactsSid=000f0207-0000-0000-0000-0000a0a8fbb9";
//
//        Map<String, InquiryVO> waitMap = new HashMap<>();
//        Map<String, InquiryVO> inquiryIngMap = new HashMap<>();
//        Map<String, InquiryVO> failedMap = new HashMap<>();
//        Map<String, InquiryVO> stopMap = new HashMap<>();
//        Map<String, InquiryVO> winMap = new HashMap<>();
//
//        //根据供应商SID+联系人SID查询询价列表
//        try {
//            headers = ZdsReqUtil.getErpHeaders("b6a70a2af8ea494fbda7c9ae118500ea", "11658934fd26400985e1e9d83f6ac7cf");
//            param.put("PageSize", pageSize);
//            param.put("PageNum", pageNum);
//            JSONObject reqJson = null;
//            JSONArray pageData =null;
//
//            Stopwatch start = Stopwatch.createStarted();
//            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
//                    headers, ZdsReqUtil.DEFAULT_TIME_OUT, ZdsReqUtil.DEFAULT_TIME_OUT);
//            Stopwatch end = start.stop();
//            logger.info("请求ERP询价列表，结束。共计耗时：「{}」秒", end.elapsed(TimeUnit.SECONDS));
//            reqJson = JSONObject.parseObject(reqResp);
//
//            if("ok".equals(reqJson.getString("status"))) {
//                pageData = reqJson.getJSONArray("Tendering");
//                logger.info("请求ERP询价列表返回数据：{} 条", null != pageData ? pageData.size() : 0);
//                handlePageData(pageData,
//                        reqJson.getJSONArray("SupplierPriceAud_SubCList"), waitMap, inquiryIngMap, failedMap, stopMap, winMap, reqJson.getJSONArray("SupplierPriceAudList"), "000c652f-0000-0000-0000-0000a00131a6");
//
//
//                logger.info("总数量：{}", (waitMap.size() + inquiryIngMap.size() + failedMap.size() + stopMap.size() + winMap.size()));
//                logger.info("待报价数量：{}", waitMap.size());
//                logger.info("报价中：{}", inquiryIngMap.size());
//                logger.info("未中标数量：{}", failedMap.size());
//                logger.info("中止价数量：{}", stopMap.size());
//                logger.info("中标数量：{}", winMap.size());
//
//            } else {
//                logger.error("请求ERP询价列表失败，参数：{}，结果：{}", JSONObject.toJSONString(param), reqResp);
//            }
//        } catch (Exception e) {
//        }
//    }

    private JSONObject handlePageData(JSONArray pageData, JSONArray supplierPriceAudSubCList,
                                             Map<String, InquiryVO> waitMap, Map<String, InquiryVO> inquiryIngMap,
                                             Map<String, InquiryVO> failedMap, Map<String, InquiryVO> stopMap, Map<String, InquiryVO> winMap,
                                             JSONArray priceAudList, String supplierSId, JSONArray supplierSignList, String linkerSid) {
        JSONObject resp = new JSONObject();

        JSONObject tmp = null;
        Map<String, JSONObject> loginMap = new HashMap<>();
        if(null != supplierSignList) {
            for(Object obj : supplierSignList) {
                tmp = (JSONObject) obj;
                if(StringUtils.equals(tmp.getString("SupplierSID"), supplierSId.toLowerCase())
                        && StringUtils.equals(tmp.getString("ContactsSid"), linkerSid.toLowerCase())) {
                    loginMap.put(tmp.getString("Tendering_FK"), tmp);
                }
            }
        }

        Map<String, BigDecimal> offerMap = new HashMap<>();
        if(null != supplierPriceAudSubCList) {
            for(Object obj : supplierPriceAudSubCList) {
                tmp = (JSONObject) obj;
                if(supplierSId.toLowerCase().equals(tmp.getString("SupplierSID"))) {
                    offerMap.put(tmp.getString("Tendering_FK"), tmp.getBigDecimal("Offer"));
                }
            }
        }

        Map<String, String> bidMap = new HashMap<>();
        if(null != priceAudList) {
            for(Object obj : priceAudList) {
                tmp = (JSONObject) obj;
                if(!"true".equals(bidMap.get(tmp.getString("Tendering_FK"))) && supplierSId.toLowerCase().equals(tmp.getString("SupplierSID"))) {
                    bidMap.put(tmp.getString("Tendering_FK"), tmp.getString("IsZhongBiao"));
                }
            }
        }

        Long curMilSec = System.currentTimeMillis();
        if(null != pageData && pageData.size() > 0) {

            JSONObject inquiry = null;
            InquiryVO tmpInquiry = null;
            for(Object obj : pageData) {
                tmp = (JSONObject) obj;
                //获取不为空个的标段信息
                    inquiry = tmp;
                    tmpInquiry = new InquiryVO();
                    tmpInquiry.setTitle(inquiry.getString("Package_Name")); //标题
                    tmpInquiry.setId(inquiry.getString("C_SCM_TenderingOID")); //SID
                    tmpInquiry.setContent(inquiry.getString("TenderContent")); //询价内容
                    tmpInquiry.setInquiryRounds(inquiry.getInteger("ProcurePlanNum")); //询价轮次
                    tmpInquiry.setProjectName(inquiry.getString("Project_Name")); //项目名称
                    tmpInquiry.setExecUnitName(inquiry.getString("DeptName")); //执行总部
                    tmpInquiry.setEndTime(DateUtil.parseDate(inquiry.getString("PriceLastDate").replace("T", " "), "yyyy-MM-dd HH:mm:ss")); //报价截至日期
                    tmpInquiry.setRemainingMilSec(tmpInquiry.getEndTime().getTime() < curMilSec ? 0L : tmpInquiry.getEndTime().getTime() - curMilSec); //剩余毫秒
                    tmpInquiry.setLoginName(inquiry.getString("LoginName")); //登录账号
                    tmpInquiry.setLoginPwd(inquiry.getString("LoginPwd")); //登录密码
                    if(StringUtils.isBlank(tmpInquiry.getLoginName()) && loginMap.containsKey(tmpInquiry.getId())) {
                        tmpInquiry.setLoginName(loginMap.get(tmpInquiry.getId()).getString("LoginName"));
                        tmpInquiry.setLoginPwd(loginMap.get(tmpInquiry.getId()).getString("LoginPwd"));
                    }

                    ERPInquiryStatus status = null;

                    if(waitMap.containsKey(tmpInquiry.getId())) {
                        waitMap.remove(tmpInquiry.getId());
                    }
                    if(inquiryIngMap.containsKey(tmpInquiry.getId())) {
                        inquiryIngMap.remove(tmpInquiry.getId());
                    }
                    if(failedMap.containsKey(tmpInquiry.getId())) {
                        failedMap.remove(tmpInquiry.getId());
                    }
                    if(stopMap.containsKey(tmpInquiry.getId())) {
                        stopMap.remove(tmpInquiry.getId());
                    }
                    if(winMap.containsKey(tmpInquiry.getId())) {
                        winMap.remove(tmpInquiry.getId());
                    }

                    switch (inquiry.getString("PackageState")) {
                        case "1":
                        case "2":
                        case "3":
                            //待报价
                            if(tmpInquiry.getRemainingMilSec() <= 0) {
                                logger.info("报价信息：{}报名已结束,跳过~！", JSONObject.toJSONString(tmpInquiry));
                                continue;
                            }
                            status = ERPInquiryStatus.UN_QUOTATION;
                            waitMap.put(tmpInquiry.getId(), tmpInquiry);
                            break;
                        case "4":
                        case "5":
                            //报价中
                            status = ERPInquiryStatus.QUOTING;
                            inquiryIngMap.put(tmpInquiry.getId(), tmpInquiry);
                            break;
                        case "6":
                        case "7":
                            if("false".equals(bidMap.get(tmpInquiry.getId()))) {
                                //未中标
                                status = ERPInquiryStatus.UN_BID;
                                failedMap.put(tmpInquiry.getId(), tmpInquiry);
                                break;
                            } else {
                                status = ERPInquiryStatus.BIDED;
                                //已中标
                                logger.info("当前已中标:{}，不做展示，跳过~！", JSONObject.toJSONString(tmpInquiry));
                                winMap.put(tmpInquiry.getId(), tmpInquiry);
                                break;
                            }
                        case "8": //询价中止
                            status = ERPInquiryStatus.STOP_QUOTATION;
                            stopMap.put(tmpInquiry.getId(), tmpInquiry);
                            break;
                        default:
                            status = ERPInquiryStatus.UN_KNOWN;
                    }

                    //取报价金额
                    tmpInquiry.setInsuredAmt(offerMap.containsKey(tmpInquiry.getId()) ? offerMap.get(tmpInquiry.getId()) : BigDecimal.ZERO);

                    tmpInquiry.setStatus(status.getCode());
                    tmpInquiry.setStatusName(status.getName());
            }
        }

        return resp;
    }

    @GetMapping(value = "getErpInquirySsoUrl")
    public CommonResponse<JSONObject> getErpInquiryUrl(@RequestParam String loginName,
                                                       @RequestParam Long linkerSupUserId,
                                                       @RequestParam Long supplierTenant,
                                                       @RequestParam String supplierType) {
        JSONObject resp = new JSONObject();
        Map<String, String> params = null;
        String linkerPhone = null;
        StringBuilder ssoUrl = new StringBuilder();

        String reqUrl = ERP_SSO_HOST + ERP_INQUIRY_SSO_URL;
        if(SupplierCommonConstants.SUPPLIER_MATERIAL.equals(supplierType)) {
            //物资供应商
            MatSupplierVO supplier = matSupplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }

            MatLinkerVO linker = matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            linkerPhone = linker.getMobileLinkPhone();
        } else {
            //分包供应商
            SupplierVO supplier = supplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }
            LinkerVO linker = linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            linkerPhone = linker.getMobileLinkPhone();
        }

        try {
            params = ZdsReqUtil.getErpHeaders();
            params.put("phone", linkerPhone);
            params.put("LoginName", loginName);
            JSONObject reqJson = null;

            Stopwatch start = Stopwatch.createStarted();
            String reqResp = HttpTookit.get(reqUrl, params,
                    new HashMap<>(), ZdsReqUtil.DEFAULT_TIME_OUT, ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            logger.info("请求ERP供方报价连接，结束。共计耗时：「{}」秒", end.elapsed(TimeUnit.SECONDS));
            logger.info("请求ERP供方报价连接，参数：{}，结果：{}",
                    JSONObject.toJSONString(params, SerializerFeature.PrettyFormat),
                    reqResp);

            reqJson = JSONObject.parseObject(reqResp.replaceAll(" ", ""));

            if("true".equals(reqJson.getString("status"))) {
                ssoUrl.append(reqJson.getString("data"))
                        .append("?LoginName=").append(loginName)
                        .append("&phone=").append(linkerPhone)
                        .append("&Ticket=").append(params.get("ticket"))
                        .append("&appid=").append(params.get("appid"))
                        .append("&sign=").append(params.get("sign"))
                        .append("&loginsid=").append(reqJson.getString("loginsid"));

                resp.put("ssoUrl", ssoUrl.toString());
                return CommonResponse.success("查询成功！", resp);
            } else {
                logger.error("请求ERP询价列表失败，参数：{}，结果：{}", JSONObject.toJSONString(params), reqResp);
                return CommonResponse.error("查询供方报价单点连接失败！");
            }

        } catch (Exception e) {
            logger.error("查询供方报价单点连接异常，参数：{}", JSONObject.toJSONString(params), e);
            return CommonResponse.error("查询供方报价单点连接失败！");
        }
    }
}