package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zds.archive.mapper.BankCategoryMapper;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Service("bankCategoryService")
public class BankCategoryServiceImpl extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity> implements IBankCategoryService{

    @Override
    public List<BankCategoryEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<BankCategoryEntity> getAllBySubBankCodes(List<String> subBankCodes) {
        QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
        query.in("sub_bank_code", subBankCodes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<BankCategoryVO> getAllByIds(List<Long> ids) {
        List<BankCategoryVO> resp =new ArrayList<>();
        QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
        query.in("id", ids);

        List<BankCategoryEntity> dbList= super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, BankCategoryVO.class);
        }
        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapBySourceIds(List<String> bankCategorySid) {
        Map<String, BankCategoryEntity> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(bankCategorySid)) {
            QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
            query.in("source_id", bankCategorySid);
            query.eq("dr", BaseVO.DR_UNDELETE);

            List<BankCategoryEntity> dbList= super.list(query);
            if(CollectionUtils.isNotEmpty(dbList)) {
                for(BankCategoryEntity c : dbList) {
                    resp.put(c.getSourceId(), c);
                }
            }
        }

        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapByNames(List<String> bankCategoryName) {
        Map<String, BankCategoryEntity> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(bankCategoryName)) {
            QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
            query.in("name", bankCategoryName);
            query.eq("dr", BaseVO.DR_UNDELETE);

            List<BankCategoryEntity> dbList= super.list(query);
            if(CollectionUtils.isNotEmpty(dbList)) {
                for(BankCategoryEntity c : dbList) {
                    resp.put(c.getName(), c);
                }
            }
        }
        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapByCodes(List<String> bankCategoryCode) {
        Map<String, BankCategoryEntity> resp = new HashMap<>();

        if(CollectionUtils.isNotEmpty(bankCategoryCode)) {
            QueryWrapper<BankCategoryEntity> query = new QueryWrapper<>();
            query.in("code", bankCategoryCode);
            query.eq("dr", BaseVO.DR_UNDELETE);

            List<BankCategoryEntity> dbList= super.list(query);
            if(CollectionUtils.isNotEmpty(dbList)) {
                for(BankCategoryEntity c : dbList) {
                    resp.put(c.getCode(), c);
                }
            }
        }
        return resp;
    }
}
