package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.mapper.BankMapper;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 银行实体
 * 
 * @author generator
 * 
 */
@Service("bankService")
public class BankServiceImpl extends BaseServiceImpl<BankMapper, BankEntity> implements IBankService{

    @Override
    public List<BankEntity> getAllBySourceIds(List<String> sourceIds) {
        List<BankEntity> resp = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(sourceIds)) {
            QueryWrapper<BankEntity> query = new QueryWrapper<>();
            query.in("source_id", sourceIds);
            query.in("tenant_id", InvocationInfoProxy.getTenantid());

            return super.list(query);
        }
        return resp;
    }

    @Override
    public List<BankVO> getAllByIds(List<Long> ids) {
        List<BankVO> resp = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper<BankEntity> query = new QueryWrapper<>();
            query.in("id", ids);
            query.in("tenant_id", InvocationInfoProxy.getTenantid());

            List<BankEntity> bankList = super.list(query);
            if(CollectionUtils.isNotEmpty(bankList)) {
                resp = BeanMapper.mapList(bankList, BankVO.class);
            }
        }

        return resp;
    }

    @Override
    public Map<String, BankEntity> getAllMapByNames(List<String> bankName) {
        Map<String, BankEntity> resp = new HashMap<>();

        if(CollectionUtils.isNotEmpty(bankName)) {
            QueryWrapper<BankEntity> query = new QueryWrapper<>();
            query.in("name", bankName);
            query.eq("dr", BaseVO.DR_UNDELETE);
            List<BankEntity> bankList = super.list(query);
            if(CollectionUtils.isNotEmpty(bankList)) {
                for(BankEntity bank : bankList) {
                    resp.put(bank.getName(), bank);
                }
            }
        }

        return resp;
    }

}
