package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.ProjectManagerCooParam;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/8 14:32
 */
public class ProjectManagerCooListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private ISupplierManagerService supplierManagerService;

    @Autowired
    private ISupplierService supplierService;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待协同项目经理信息：{}", JSON.toJSONString(mqMessage.getBody()));
        try {
            SupplierManagerVO managerVO = JSONObject.parseObject(JSON.toJSONString(mqMessage.getBody()), SupplierManagerVO.class);

            //查询项目经理信息，校验项目经理是否已生成协同账号
            SupplierManagerEntity managerEntity = supplierManagerService.selectById(managerVO.getId());
            if(null == managerEntity) {
                logger.info("供应商id-{}项目经理-{}，生成协同账号失败，系统不存在匹配的项目经理信息！", managerVO.getSupplierId(),
                        JSONObject.toJSONString(managerVO, SerializerFeature.PrettyFormat));
                return;
            }
            if("1".equals(managerEntity.getCoordination())) {
                logger.info("供应商项目经理-{},已生成协同账号，任务执行结束。。。");
                return;
            }

            SupplierEntity supplier = supplierService.selectById(managerVO.getSupplierId());

            supplierManagerService.createSupAccount(managerEntity, supplier.getTenant());
        } catch (Exception e) {
            logger.error("监听消息异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{ProjectManagerCooParam.PROJECT_MANAGER_COO_QUEUE+"_"+profile};
    }
}
