package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zds.archive.bean.PushErpRecordsEntity;
import com.ejianc.business.zds.archive.service.IPushErpRecordsService;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 接受并保存推送ERP数据记录
 *
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class PushErpRecordListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IPushErpRecordsService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待保存推送ERP数据记录：{}", mqMessage.getBody());
        try {
            PushErpRecordsEntity record = JSONObject.parseObject(mqMessage.getBody().toString(), PushErpRecordsEntity.class);
            service.saveOrUpdate(record, false);
        } catch (Exception e) {
            logger.error("供应商同步ERP异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{SupplierSyncParam.PUSH_ERP_RECORD_QUEUE+"_"+profile};
    }
}
