package com.ejianc.business.zdssupplier.material.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerChangeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerChangeVO;

/**
 * 物资联系人变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("matLinkerChange")
public class MatLinkerChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_MAT_LINKER_CHANGE";//此处需要根据实际修改

    @Autowired
    private IMatLinkerChangeService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMatLinkerService linkerService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> saveOrUpdate(@RequestBody MatLinkerChangeVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> queryDetail(Long id) {
        MatLinkerChangeVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatLinkerChangeVO> vos) {
        List<Long> linkerId = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (MatLinkerChangeVO vo : vos) {
                MatLinkerChangeEntity linkerChangeEntity = service.selectById(vo.getId());
                if (linkerChangeEntity.getSourceType().equals("1")||SupLinkerEnum.已驳回供方.getCode().equals(linkerChangeEntity.getReceiveStatus())){
                    linkerId.add(linkerChangeEntity.getLinkerId());
                }else{
                    throw new BusinessException("只有已驳回供方的变更单才可以删除！");
                }            }
        }
        if (CollectionUtil.isNotEmpty(linkerId)){
            linkerService.deleteChange(linkerId);
        }

            service.removeByIds(vos.stream().map(MatLinkerChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatLinkerChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("name");
        fuzzyFields.add("userName");
        fuzzyFields.add("linkPhone");
        fuzzyFields.add("idCardId");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MatLinkerChangeEntity> page = service.queryPage(param,false);
        IPage<MatLinkerChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MatLinkerChangeVO> linkerChangeVOS = BeanMapper.mapList(page.getRecords(), MatLinkerChangeVO.class);
        linkerChangeVOS.stream().forEach(vo -> {
            if (vo.getReceiveStatus()!=null){
                switch (vo.getReceiveStatus()){
                    case 0:
                        vo.setReceiveStatusStr("待提交");
                        break;
                    case 1:
                        vo.setReceiveStatusStr("待审核");
                        break;
                    case 2:
                        vo.setReceiveStatusStr("已审核");
                        break;
                    case 3:
                        vo.setReceiveStatusStr("已驳回");
                        break;
                    case 4:
                        vo.setReceiveStatusStr("审核中");
                        break;
                }
            }else{
                vo.setReceiveStatusStr("待提交");
            }
            vo.setBillStateStr(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
  		pageData.setRecords(linkerChangeVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<MatLinkerChangeVO>> iPageCommonResponse = queryList(param);
        List<MatLinkerChangeVO> records = new ArrayList<>();
        if (iPageCommonResponse.isSuccess()){
            IPage<MatLinkerChangeVO> pageData = iPageCommonResponse.getData();
            records =pageData.getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("MatLinkerChange-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/addConvertById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> addConvertById(Long linkerId) {
        MatLinkerChangeVO vo = service.addConvertById(linkerId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    @RequestMapping(value = "/contrast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long linkerId) {
        JSONObject contrast = service.contrast(linkerId);
        return CommonResponse.success("新增转换数据成功！",contrast);
    }

    @PostMapping(value = "syncBill")
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return service.syncBill(request);
    }

    @RequestMapping(value = "/pushStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> pushStatus(Long id) {
        return  service.pushStatus(id);
    }


}
