package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.*;
import com.ejianc.business.zdssupplier.material.service.*;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/12 15:27
 */
@RestController
@RequestMapping(value = "/zdsMatSupSync")
public class ZdsMatSupSyncController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMatSupplierService service;

    @Autowired
    private IMatLinkerService matLinkerService;

    @Autowired
    private IMatSupplierAttachesService attachesService;

    @Autowired
    private IMatSupplierBankService supplierBankService;

    @Autowired
    private IBankService bankService;

    private final static String ERP_MAT_SUPPLIER_UPDATE_URL = "/cefoc/yql/MESupplierList";

    @Autowired
    private IAdministrativeAreaService areaService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IMatSupplierMaterialInfoService materialInfoService;

    @Autowired
    private IBankCategoryService bankCategoryService;

    @Autowired
    IZDSBrandApi brandApi;

    /**
     * 中电四物资供应商同步
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/syncZdsMatSupplier")
    @ResponseBody
    public CommonResponse<String> syncZdsMatSupplier(@RequestBody JSONObject params) {
        logger.info("*********************中电四-物资供应商信息同步任务 开始*********************");
        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL;
        JSONObject reqJson = null;
        JSONArray pageData = null;

        String reqDateStr = null;
        if(null == params.get("beginDate") || null == params.get("endDate")) {
            //同步昨天数据
            if(!"all".equals(params.getString("range"))) {
                reqDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1));
                param.put("BeginDateTime", reqDateStr + " 00:00:00");
                param.put("EndDateTime", reqDateStr + " 23:59:59");
            }
        } else {
            param.put("BeginDateTime", params.getString("beginDate"));
            param.put("EndDateTime", params.getString("endDate"));
        }

        //ERP接口需传递分页参数  但ERP又不根据其过滤 故写死
        param.put("PageSize", 100);
        param.put("PageNum", 1);

        if(null != params.get("supplierSid")) {
            reqUrl = reqUrl + "?OID=" + params.getString("supplierSid");
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }

        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取物资供应商结果返回成功：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers));
                handleErpPage(reqJson);
            } else {
                logger.error("请求中电四获取物资供应商结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四物资供应商信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四物资供应商信息异常");
        }

        logger.info("*********************中电四-物资供应商信息同步任务 结束*********************");
        return CommonResponse.success("物资供应商同步任务执行成功！");
    }

    @Transactional(rollbackFor = Exception.class)
    public void handleErpPage(JSONObject dataJson) {
        List<MatSupplierEntity> supList = new ArrayList<>();
        List<MatLinkerEntity> linkerList = new ArrayList<>();
        List<MatSupplierMaterialInfoEntity> materialList = new ArrayList<>();
        List<MatSupplierBankEntity> bankList = new ArrayList<>();
        List<MatSupplierAttachesEntity> attachList = new ArrayList<>();
        Set<String> areaNames = new HashSet<>();
        Set<String> copSIds = new HashSet<>();

        MatSupplierEntity tmpSupEntity = null;
        MatLinkerEntity tmpLinkerEntity = null;
        JSONObject tmpSupJson = null;
        List<String> tmpIds = new ArrayList<>();
        List<String> tmpSIds = new ArrayList<>();
        List<String> names = new ArrayList<>();

        Map<String, MatSupplierEntity> mapSourceMap = new HashMap<>();
        Map<String, List<MatLinkerEntity>> linkerMap = new HashMap<>();
        Map<String, List<MatSupplierMaterialInfoEntity>> materialInfoMap = new HashMap<>();
        Map<Long, List<MatLinkerEntity>> dbLinkerMap = new HashMap<>();
        Map<Long, List<MatSupplierBankEntity>> dbBankMap = new HashMap<>();
        Map<Long, List<MatSupplierAttachesEntity>> dbAttachMap = new HashMap<>();
        Map<Long, List<MatSupplierMaterialInfoEntity>> dbMaterialMap = new HashMap<>();
        Map<String, List<MatSupplierBankEntity>> bankMap = new HashMap<>();
        Map<String, List<MatSupplierAttachesEntity>> attachMap = new HashMap<>();
        Map<String, AdministrativeAreaEntity> areaMap = new HashMap<>();
        Map<String, OrgVO> orgMap = new HashMap<>();

        JSONArray supplierArr = dataJson.getJSONArray("MESupplierList");
        logger.info("本次待处理供应商数据：{}条", supplierArr.size());
        if(supplierArr.size() == 0) {
            logger.info("待处理供应商数据为空，任务执行结束。。。。");
            return;
        }

        for(Object obj : supplierArr) {
            tmpSupJson = (JSONObject) obj;
            tmpSupEntity = new MatSupplierEntity();
            tmpSupEntity.setThirdSourceId(tmpSupJson.getString("C_PS_MESupplierInfoOID")); //ERP主键
            if(null != tmpSupJson.get("YQL_SID") && StringUtils.isNotBlank(tmpSupJson.getString("YQL_SID"))) { //EL平台主键
                tmpSupEntity.setId(Long.valueOf(tmpSupJson.getString("YQL_SID")));
            }
            tmpSupEntity.setMemo(tmpSupJson.getString("Memo")); //备注
            tmpSupEntity.setName(tmpSupJson.getString("Company_Name")); //供应商名称
            tmpSupEntity.setLegalPerson(tmpSupJson.getString("Company_LegalPerson"));//法人
            tmpSupEntity.setCompanyType(ErpCompanyTypeEnums.getByCode(tmpSupJson.getString("CompanyStyle"))); //公司类型
            tmpSupEntity.setRegisteredCapitalStr(tmpSupJson.getString("RegistrationCapital")); //注册资本
            tmpSupEntity.setPaidCapitalStr(tmpSupJson.getString("Paidincapital")); //实缴资本
            tmpSupEntity.setBusinessStatus(tmpSupJson.getString("regStatus")); //经营状态
            try {
                if(null != tmpSupJson.get("OperatingPeriodStart") && StringUtils.isNotBlank(tmpSupJson.getString("OperatingPeriodStart"))) {
                    tmpSupEntity.setBusinessStartDate(DateFormatUtil.parseDate("yyyy-MM-dd", tmpSupJson.getString("OperatingPeriodStart").split("T")[0])); //经营开始时间
                }
                if(null != tmpSupJson.get("OperatingPeriodStartEnd") && StringUtils.isNotBlank(tmpSupJson.getString("OperatingPeriodStartEnd"))) {
                    tmpSupEntity.setBusinessEndDate(DateFormatUtil.parseDate("yyyy-MM-dd", tmpSupJson.getString("OperatingPeriodStartEnd").split("T")[0])); //经营结束时间
                }
                if(null != tmpSupJson.get("Restricteddate") && StringUtils.isNotBlank(tmpSupJson.getString("Restricteddate"))) {
                    tmpSupEntity.setRestrictDate(DateFormatUtil.parseDate("yyyy-MM-dd", tmpSupJson.getString("Restricteddate").split("T")[0]));
                }
            } catch (Exception e) {
                logger.error("供应商时间格式化异常：{}, ", tmpSupJson.toString(SerializerFeature.PrettyFormat), e);
            }
            tmpSupEntity.setRegisteredAddress(tmpSupJson.getString("Company_Address")); //注册地址
            tmpSupEntity.setSocialCreditCode(tmpSupJson.getString("RegistrationCode")); //统一社会信用代码
            tmpSupEntity.setBusinessScope(tmpSupJson.getString("OperatingRange")); //经营范围
            tmpSupEntity.setCode(tmpSupJson.getString("Ma_id")); //供应商编码
            tmpSupEntity.setTaxCreditLevel(ErpTaxCreditLevelEnum.getByCode(tmpSupJson.getString("Taxcreditrating"))); //纳税等级
            tmpSupEntity.setDisposableState(StringUtils.isNotBlank(tmpSupJson.getString("IsitaOneTimeUse")) ?
                    "true".equals(tmpSupJson.getString("IsitaOneTimeUse").toLowerCase()) ? 1 : 0 : null); //是否一次使用
            tmpSupEntity.setDisposableReason(tmpSupJson.getString("ReasonforOneTimeUse")); //一次性使用原因
            tmpSupEntity.setSealState(StringUtils.isNotBlank(tmpSupJson.getString("IsSupportES")) ?
                    "true".equals(tmpSupJson.getString("IsSupportES").toLowerCase()) ? "1" : "0" : null); //是否支持电子签章
            tmpSupEntity.setPoState(StringUtils.isNotBlank(tmpSupJson.getString("IsPoSupplier")) ?
                    "true".equals(tmpSupJson.getString("IsPoSupplier").toLowerCase()) ? 1 : 0 : null); //是否po供应商
            tmpSupEntity.setCompanyGrade(tmpSupJson.getString("Company_Level")); //公司等级
            tmpSupEntity.setCompanyState(tmpSupJson.getString("CompanyStatus")); //公司状态
            tmpSupEntity.setSysLastUpd(tmpSupJson.getString("SYS_LAST_UPD"));
            tmpSupEntity.setErpCreatorSid(tmpSupJson.getString("SYS_CreatedBy")); //创建人SID
            tmpSupEntity.setErpRegisterName(tmpSupJson.getString("Register_Name")); //创建人名称
            tmpSupEntity.setCoordination("0"); //默认未协同
//            tmpSupEntity.setMaxContractOnYearMny(tmpSupJson.getBigDecimal("AnnualMaxVertragsbetrag")); //年度最大承接合同额
//            tmpSupEntity.setMaxContractOnTimeMny(tmpSupJson.getBigDecimal("MaxLimitConMoney")); //同时最大承接合同额(万)

            //归属部门
            tmpSupEntity.setCorpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpErpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpSid(StringUtils.isNotBlank(tmpSupJson.getString("OwnerDeptSid")) ?tmpSupJson.getString("OwnerDeptSid").toLowerCase() : null);
            //消息来源
//            tmpSupJson.getString("EntryDept"); //0-为空、3-正常开发、4-甲方指定、5-甲方推荐、8-厂家指定代理商、9-上包品牌内引入
            tmpSupEntity.setType(PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.containsKey(tmpSupJson.getString("EntryDept")) ?
                    PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.get(tmpSupJson.getString("EntryDept")) : "");
            tmpSupEntity.setErpType(tmpSupJson.getString("EntryDept"));
            //业务区域
            tmpSupEntity.setIntentId(null);
            tmpSupEntity.setIntentName(null);
            if(StringUtils.isNotBlank(tmpSupJson.getString("SupplyArea"))) {
                if(tmpSupJson.getString("SupplyArea").indexOf(",") > 0) {
                    logger.info("供应商-[name-{},code-{},sid-{}]业务区域[{}]格式错误，不做同步！", tmpSupEntity.getName(),
                            tmpSupEntity.getCode(), tmpSupEntity.getThirdSourceId(), tmpSupJson.getString("SupplyArea"));
                }

                tmpSupEntity.setIntentName(tmpSupJson.getString("SupplyArea").replaceAll("\\|", ",")); //将|替换为,
                if(tmpSupEntity.getIntentName().endsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(0,tmpSupEntity.getIntentName().length()-1));
                }
                if(tmpSupEntity.getIntentName().startsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(1));
                }
                areaNames.addAll(Arrays.asList(tmpSupEntity.getIntentName().split(",")));
            }
            //公司性质 //0生产商1贸易商2零售商3个体工商户
            tmpSupEntity.setCompanyCharacter(PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.containsKey(tmpSupJson.getString("TypeLabel")) ?
                    PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.get(tmpSupJson.getString("TypeLabel")) : null);

            if(null == tmpSupEntity.getId()) {
                tmpSupEntity.setId(IdWorker.getId());
            }

            if(StringUtils.isNotBlank(tmpSupEntity.getCorpSid())) {
                copSIds.add(tmpSupEntity.getCorpSid());
            }

            mapSourceMap.put(tmpSupEntity.getThirdSourceId(), tmpSupEntity);
        }
        //查询行政地区信息
        if(CollectionUtils.isNotEmpty(areaNames)) {
            List<AdministrativeAreaEntity> dbAreas = areaService.getAllByNames(new ArrayList<>(areaNames));
            if(CollectionUtils.isNotEmpty(dbAreas)) {
                for(AdministrativeAreaEntity area : dbAreas) {
                    areaMap.put(area.getName(), area);
                }
            }
        }
        //查询归属部门
        if(CollectionUtils.isNotEmpty(copSIds)) {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findAllBySourceIds(new ArrayList<>(copSIds));
            if(!orgResp.isSuccess()) {
                logger.error("根据组织SId-{}查询组织信息失败，{}", JSONObject.toJSONString(copSIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            }
            if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                orgMap.putAll(orgResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }

        //供应商联系人
        if(null != dataJson.get("ContactList") && dataJson.getJSONArray("ContactList").size() > 0) {
            handleLinker(linkerMap, dataJson.getJSONArray("ContactList"));
        }

        //供应商附件信息
        if(null != dataJson.get("ArchivesList") && dataJson.getJSONArray("ArchivesList").size() > 0) {
            handleArchive(attachMap, dataJson.getJSONArray("ArchivesList"));
        }

        //供应商银行信息
        if(null != dataJson.get("BankList") && dataJson.getJSONArray("BankList").size() > 0) {
            handleBank(bankMap, dataJson.getJSONArray("BankList"));
        }

        //供货内容
        if(null != dataJson.get("SupplyList") && dataJson.getJSONArray("SupplyList").size() > 0) {
            handleMaterialInfo(materialInfoMap, dataJson.getJSONArray("SupplyList"));
        }

        //判断数据库是否存在
        List<MatSupplierEntity> dbList = service.getAllByThirdSourceIds(new ArrayList(mapSourceMap.keySet()));
        if(CollectionUtils.isNotEmpty(dbList)) {
            List<Long> supplierIds = dbList.stream().map(MatSupplierEntity::getId).collect(Collectors.toList());
            //联系人
            List<MatLinkerEntity> linkers = matLinkerService.getAllBySupplierIds(supplierIds, null);
            dbLinkerMap.putAll(linkers.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(MatLinkerEntity::getSupplierId)));

            //供货内容
            List<MatSupplierMaterialInfoEntity> materials = materialInfoService.getAllBySupplierIds(supplierIds);
            dbMaterialMap.putAll(materials.stream().filter(item -> null != item.getInfoThirdSourceId()).collect(Collectors.groupingBy(MatSupplierMaterialInfoEntity::getSupplierId)));

            //银行信息
            List<MatSupplierBankEntity> dbBankList = supplierBankService.getAllBySupplierIds(supplierIds);
            dbBankMap.putAll(dbBankList.stream().filter(item -> null != item.getBankThirdSourceId()).collect(Collectors.groupingBy(MatSupplierBankEntity::getSupplierId)));

            //附件信息
            List<MatSupplierAttachesEntity> dbAttachList = attachesService.getAllBySupplierIds(supplierIds);
            dbAttachMap.putAll(dbAttachList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(MatSupplierAttachesEntity::getSupplierId)));

            for(MatSupplierEntity dbSupplier : dbList) {
                tmpSupEntity = mapSourceMap.get(dbSupplier.getThirdSourceId());

                if(StringUtils.isNotBlank(tmpSupEntity.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    names.clear();
                    Arrays.asList(tmpSupEntity.getIntentName().split(",")).stream().forEach(item -> {
                        if(areaMap.containsKey(item)) {
                            tmpIds.add(areaMap.get(item).getId().toString());
                            tmpSIds.add(areaMap.get(item).getSourceId());
                            names.add(areaMap.get(item).getName());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(tmpIds)) {
                        tmpSupEntity.setIntentId(StringUtils.join(tmpIds, ","));
                        tmpSupEntity.setIntentSid(StringUtils.join(tmpSIds, ","));
                        tmpSupEntity.setIntentName(StringUtils.join(names, ","));
                    }
                }

                if(StringUtils.isNotBlank(tmpSupEntity.getCorpSid()) && orgMap.containsKey(tmpSupEntity.getCorpSid())) {
                    tmpSupEntity.setCorpId(orgMap.get(tmpSupEntity.getCorpSid()).getId());
                    tmpSupEntity.setCorpName(orgMap.get(tmpSupEntity.getCorpSid()).getName());
                    tmpSupEntity.setCorpCode(orgMap.get(tmpSupEntity.getCorpSid()).getCode());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getErpRegisterName()) && StringUtils.isBlank(dbSupplier.getErpRegisterName())) {
                    dbSupplier.setErpRegisterName(tmpSupEntity.getErpRegisterName());
                }

                //更新供应商基本信息
                if(null == dbSupplier.getBusinessEndDate() && null != tmpSupEntity.getBusinessEndDate()) {
                    dbSupplier.setBusinessEndDate(tmpSupEntity.getBusinessEndDate());
                }
                if(null == dbSupplier.getBusinessStartDate() && null != tmpSupEntity.getBusinessStartDate()) {
                    dbSupplier.setBusinessStartDate(tmpSupEntity.getBusinessStartDate());
                }
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason());
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade());
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState());
                dbSupplier.setIntentId(tmpSupEntity.getIntentId());
                dbSupplier.setIntentName(tmpSupEntity.getIntentName());
                dbSupplier.setIntentSid(tmpSupEntity.getIntentSid());
                dbSupplier.setCompanyCharacter(tmpSupEntity.getCompanyCharacter());
                dbSupplier.setCorpSid(tmpSupEntity.getCorpSid());
                dbSupplier.setCorpName(tmpSupEntity.getCorpName());
                dbSupplier.setCorpId(tmpSupEntity.getCorpId());
                dbSupplier.setCorpCode(tmpSupEntity.getCorpCode());
                dbSupplier.setCorpErpName(tmpSupEntity.getCorpErpName());
                dbSupplier.setType(tmpSupEntity.getType());
                dbSupplier.setSysLastUpd(tmpSupEntity.getSysLastUpd());
                dbSupplier.setErpType(tmpSupEntity.getErpType());
                dbSupplier.setErpCreatorSid(tmpSupEntity.getErpCreatorSid());

                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState()); //是否一次使用
                dbSupplier.setDisposableReason(tmpSupEntity.getCompanyGrade()); //一次性使用原因
                dbSupplier.setSealState(tmpSupEntity.getSealState()); //是否支持电子签章
                dbSupplier.setPoState(tmpSupEntity.getPoState()); //是否po供应商
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade()); //公司等级
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState()); //公司状态

                supList.add(dbSupplier);

                //供应商联系人
                List<MatLinkerEntity> saveLinkers = linkerMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        linkerMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                List<MatSupplierMaterialInfoEntity> saveMaterials = materialInfoMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        materialInfoMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                List<MatSupplierBankEntity> saveBanks = bankMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        bankMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                List<MatSupplierAttachesEntity> saveAttaches = attachMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        attachMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();

                if(CollectionUtils.isNotEmpty(saveLinkers)) {
                    Map<String, MatLinkerEntity> sourceLinkers = dbLinkerMap.containsKey(dbSupplier.getId()) ? dbLinkerMap.get(dbSupplier.getId()).stream()
                            .collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap<>();
                    MatLinkerEntity tmpLink = null;
                    for(MatLinkerEntity link : saveLinkers) {
                        if(sourceLinkers.containsKey(link.getThirdSourceId())) {
                            tmpLink = sourceLinkers.get(link.getThirdSourceId());

                            tmpLink.setIdCardType(link.getIdCardType()); //证件类型
                            tmpLink.setIdCardId(link.getIdCardId()); //证件ID
                            tmpLink.setName(link.getName()); //联系人名称
                            tmpLink.setMobileLinkPhone(link.getMobileLinkPhone()); //联系人手机号
                            tmpLink.setLinkPhone(link.getLinkPhone()); //联系人固定电话
                            tmpLink.setElectronicMail(link.getElectronicMail());//联系人邮箱
                            tmpLink.setAddress(link.getAddress());//联系人通讯地址
                            tmpLink.setLinkerStatus(link.getLinkerStatus());//联系人状态
                            if(null != link.getUserType()) {
                                tmpLink.setUserType(link.getUserType()); //联系人标识
                            }

                            linkerList.add(tmpLink);
                        } else {
                            link.setSupplierName(dbSupplier.getName());
                            link.setSupplierCode(dbSupplier.getCode());
                            link.setSupplierId(dbSupplier.getId());
                            link.setDateType(0);
                            link.setChangeVersion(0);
                            if(null == link.getId()) {
                                link.setId(IdWorker.getId());
                                link.setSourceId(dbSupplier.getId());
                                link.setSourceDetailId(link.getId());
                            }
                            linkerList.add(link);
                        }
                    }
                }
                //供应商供货内容
                if(CollectionUtils.isNotEmpty(saveMaterials)) {
                    Map<String, MatSupplierMaterialInfoEntity> sourceMaterials = dbMaterialMap.containsKey(dbSupplier.getId()) ? dbMaterialMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getInfoThirdSourceId()))
                            .collect(Collectors.toMap(item -> item.getInfoThirdSourceId(), item -> item)) : new HashMap<>();
                    MatSupplierMaterialInfoEntity tmpMaterial = null;
                    for(MatSupplierMaterialInfoEntity material : saveMaterials) {
                        if(sourceMaterials.containsKey(material.getInfoThirdSourceId())) {
                            tmpMaterial = sourceMaterials.get(material.getInfoThirdSourceId());

                            tmpMaterial.setMaterialName(material.getMaterialName()); //末级分类名称
                            tmpMaterial.setMaterialSid(material.getMaterialSid()); //末级分类SID
                            tmpMaterial.setBrandName(material.getBrandName()); //品牌
                            tmpMaterial.setBrandSid(material.getBrandSid());//品牌SID
                            if(null == tmpMaterial.getBrandId() && null != material.getBrandId()) {
                                tmpMaterial.setBrandId(material.getBrandId());
                            }
                            // 属性 1-生产商，2-贸易商-代理型，3-贸易商-项目授权型
                            tmpMaterial.setPropertyValue(material.getPropertyValue());
                            tmpMaterial.setCertification(material.getCertification()); //资质 1：代理证 2：项目授权
                            tmpMaterial.setStartTime(material.getStartTime()); //起始时间
                            tmpMaterial.setTerminalTime(material.getTerminalTime()); //终止时间
                            tmpMaterial.setAffiliatedManufacturer(material.getAffiliatedManufacturer()); //关联厂家
                            tmpMaterial.setAffiliatedProjectName(material.getAffiliatedProjectName()); //关联项目
                            tmpMaterial.setAffiliatedProjectSid(material.getAffiliatedProjectSid()); //关联项目Sid

                            materialList.add(tmpMaterial);
                        } else {
                            if(null == material.getId()) {
                                material.setId(IdWorker.getId());
                                material.setSourceId(dbSupplier.getId());
                                material.setSourceDetailId(material.getId());
                            }
                            material.setEnableStatus(PlanConstant.INTEGER_YES);
                            material.setSupplierId(dbSupplier.getId());
                            materialList.add(material);
                        }
                    }
                }

                //银行信息
                if(CollectionUtils.isNotEmpty(saveBanks)) {
                    Map<String, MatSupplierBankEntity> sourceBank = dbBankMap.containsKey(dbSupplier.getId()) ? dbBankMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getBankThirdSourceId()))
                            .collect(Collectors.toMap(item -> item.getBankThirdSourceId(), item -> item)) : new HashMap<>();
                    MatSupplierBankEntity tmpBank = null;
                    for(MatSupplierBankEntity bank : saveBanks) {
                        if(sourceBank.containsKey(bank.getBankThirdSourceId())) {
                            tmpBank = sourceBank.get(bank.getBankThirdSourceId());
                            tmpBank.setBankNumber(bank.getBankNumber()); //银行账号
                            tmpBank.setNumberType(bank.getNumberType()); //账号类型
                            tmpBank.setBankName(bank.getBankName()); //银行名称
                            tmpBank.setBankType(bank.getBankType()); //银行类型
                            tmpBank.setProvince(bank.getProvince()); //省
                            tmpBank.setCity(bank.getCity()); //市
                            tmpBank.setOpenBank(bank.getOpenBank()); //开户行
                            tmpBank.setBankLineNumber(bank.getBankLineNumber()); //银行行号
                            if(StringUtils.isBlank(tmpBank.getBankSid()) && StringUtils.isNotBlank(bank.getBankSid())) {
                                tmpBank.setBankSid(bank.getBankSid());
                            }
                            if(StringUtils.isBlank(tmpBank.getBankCategorySid()) && StringUtils.isNotBlank(bank.getBankCategorySid())) {
                                tmpBank.setBankCategorySid(bank.getBankCategorySid());
                            }

                            bankList.add(tmpBank);
                        } else {
                            bank.setSupplierId(dbSupplier.getId());
                            if(null == bank.getId()) {
                                bank.setId(IdWorker.getId());
                                bank.setSourceId(dbSupplier.getId());
                                bank.setSourceDetailId(bank.getId());
                            }
                            bankList.add(bank);
                        }
                    }
                }

                //附件信息
                if(dbAttachMap.containsKey(dbSupplier.getId())) {
                    Map<String, MatSupplierAttachesEntity> sourceAttach = dbAttachMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
                    saveAttaches = saveAttaches.stream().filter(item -> !sourceAttach.containsKey(item.getThirdSourceId())).collect(Collectors.toList());
                }
                if(CollectionUtils.isNotEmpty(saveAttaches)) {
                    for(MatSupplierAttachesEntity attach : saveAttaches) {
                        attach.setSupplierId(dbSupplier.getId());
                        if(null == attach.getId()) {
                            attach.setId(IdWorker.getId());
                            attach.setSourceId(dbSupplier.getId());
                            attach.setSourceDetailId(attach.getId());
                        }
                        attachList.add(attach);
                    }
                }

                linkerMap.remove(dbSupplier.getThirdSourceId());
                materialInfoMap.remove(dbSupplier.getThirdSourceId());
                mapSourceMap.remove(dbSupplier.getThirdSourceId());
                attachMap.remove(dbSupplier.getThirdSourceId());
                bankMap.remove(dbSupplier.getThirdSourceId());
            }
        }

        if(!mapSourceMap.isEmpty()) {
            for(MatSupplierEntity erpSupplier : mapSourceMap.values()) {
                if(StringUtils.isNotBlank(erpSupplier.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    Arrays.asList(erpSupplier.getIntentName().split(",")).stream().forEach(item -> {
                        if(areaMap.containsKey(item)) {
                            tmpIds.add(areaMap.get(item).getId().toString());
                            tmpSIds.add(areaMap.get(item).getSourceId());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(tmpIds)) {
                        erpSupplier.setIntentId(StringUtils.join(tmpIds, ","));
                        erpSupplier.setIntentSid(StringUtils.join(tmpSIds, ","));
                    }
                }

                if(StringUtils.isNotBlank(erpSupplier.getCorpSid()) && orgMap.containsKey(erpSupplier.getCorpSid())) {
                    erpSupplier.setCorpId(orgMap.get(erpSupplier.getCorpSid()).getId());
                    erpSupplier.setCorpName(orgMap.get(erpSupplier.getCorpSid()).getName());
                }
                supList.add(erpSupplier);

                if(linkerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    linkerMap.get(erpSupplier.getThirdSourceId()).forEach(link -> {
                        link.setSupplierName(erpSupplier.getName());
                        link.setSupplierCode(erpSupplier.getCode());
                        link.setSupplierId(erpSupplier.getId());
                        link.setDateType(0);
                        link.setChangeVersion(0);
                        linkerList.add(link);
                    });
                }
                if(bankMap.containsKey(erpSupplier.getThirdSourceId())) {
                    bankMap.get(erpSupplier.getThirdSourceId()).forEach(bank -> {
                        bank.setSupplierId(erpSupplier.getId());
                        bankList.add(bank);
                    });
                }
                if(attachMap.containsKey(erpSupplier.getThirdSourceId())) {
                    attachMap.get(erpSupplier.getThirdSourceId()).forEach(attach -> {
                        attach.setSupplierId(erpSupplier.getId());
                        attachList.add(attach);
                    });
                }

                if(materialInfoMap.containsKey(erpSupplier.getThirdSourceId())) {
                    materialInfoMap.get(erpSupplier.getThirdSourceId()).forEach(material -> {
                        material.setSupplierId(erpSupplier.getId());
                        materialList.add(material);
                    });
                }
            }
        }

        if(CollectionUtils.isNotEmpty(supList)) {
            //保存/更新供应商
            logger.info("本次更新供应商数量：{}", supList.size());
            service.saveOrUpdateBatch(supList, supList.size(), false);
        }

        if(CollectionUtils.isNotEmpty(linkerList)) {
            //保存供应商联系人
            logger.info("本次保存供应商联系人数量：{}", linkerList.size());
            matLinkerService.saveOrUpdateBatch(linkerList, linkerList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(bankList)) {
            //保存供应商银行
            logger.info("本次保存供应商银行数量：{}", bankList.size());
            supplierBankService.saveOrUpdateBatch(bankList, bankList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(attachList)) {
            //保存供应商附件
            logger.info("本次保存供应商附件数量：{}", attachList.size());
            attachesService.saveOrUpdateBatch(attachList, attachList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(materialList)) {
            //保存供应商附件
            logger.info("本次保存供应商供货内容数量：{}", materialList.size());
            materialInfoService.saveOrUpdateBatch(materialList, materialList.size(), false);
        }
    }

    /**
     * 供货内容处理
     *
     * @param materialInfoMap
     * @param supplyList
     */
    private void handleMaterialInfo(Map<String, List<MatSupplierMaterialInfoEntity>> materialInfoMap, JSONArray supplyList) {
        logger.info("本次待处理供应商-供货内容数据:{}条", supplyList.size());
        JSONObject tmpJson = null;
        MatSupplierMaterialInfoEntity materialInfoEntity = null;

        Set<String> brandSid = new HashSet<>();
        List<MatSupplierMaterialInfoEntity> allInfo = new ArrayList<>();
        for(Object obj : supplyList) {
            tmpJson = (JSONObject) obj;
            materialInfoEntity = new MatSupplierMaterialInfoEntity();
            materialInfoEntity.setInfoThirdSourceId(tmpJson.getString("C_PS_MESupplierInfo_SubDOID")); //ERP子表主键
            materialInfoEntity.setMaterialName(tmpJson.getString("CompanyType")); //末级分类名称
            materialInfoEntity.setMaterialSid(tmpJson.getString("CompanyType_Sid")); //末级分类SID
            materialInfoEntity.setBrandName(tmpJson.getString("MainBrands")); //品牌
            materialInfoEntity.setBrandSid(tmpJson.getString("MainBrands_Sid"));//品牌SID
            // 属性 1-生产商，2-贸易商-代理型，3-贸易商-项目授权型
            materialInfoEntity.setPropertyValue(PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.containsKey(tmpJson.getString("PropertyCode"))
                    ? PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.get(tmpJson.getString("PropertyCode")) : tmpJson.getString("PropertyCode"));
            materialInfoEntity.setCertification("1".equals(tmpJson.getString("CertificationCode")) ? 2 : 1); //资质 1：代理证 2：项目授权

            if(StringUtils.isNotBlank(materialInfoEntity.getBrandSid())) {
                brandSid.add(materialInfoEntity.getBrandSid());
            }

            try {
                if(null != tmpJson.get("BeginTime") && StringUtils.isNotBlank(tmpJson.getString("BeginTime"))) {
                    materialInfoEntity.setStartTime(DateFormatUtil.parseDate("yyyy-MM-dd", tmpJson.getString("BeginTime").split("T")[0])); //起始时间
                }
                if(null != tmpJson.get("EndTime") && StringUtils.isNotBlank(tmpJson.getString("EndTime"))) {
                    materialInfoEntity.setTerminalTime(DateFormatUtil.parseDate("yyyy-MM-dd", tmpJson.getString("EndTime").split("T")[0])); //终止时间
                }
            } catch (Exception e) {
                logger.error("供货内容起止时间格式化异常：start-{},end-{}", tmpJson.getString("BeginTime"), tmpJson.getString("EndTime"));
            }

            materialInfoEntity.setAffiliatedManufacturer(StringUtils.isNotBlank(tmpJson.getString("AffiliatedCompany")) ? tmpJson.getString("AffiliatedCompany") : null); //关联厂家
            materialInfoEntity.setAffiliatedProjectName(tmpJson.getString("AffiliatedProject")); //关联项目
            materialInfoEntity.setAffiliatedProjectSid(StringUtils.isNotBlank(tmpJson.getString("AccountingProjectSet_FK")) ? tmpJson.getString("AccountingProjectSet_FK") : null); //关联项目Sid
            materialInfoEntity.setSupplierSid(tmpJson.getString("MESupplierInfo_FK")); //供应商Sid

            if(!materialInfoMap.containsKey(materialInfoEntity.getSupplierSid())) {
                materialInfoMap.put(materialInfoEntity.getSupplierSid(), new ArrayList<>());
            }
            materialInfoMap.get(materialInfoEntity.getSupplierSid()).add(materialInfoEntity);
            allInfo.add(materialInfoEntity);
        }

        if(CollectionUtils.isNotEmpty(brandSid)) {
            CommonResponse<Map<String, BrandVO>> brandSourceResp = brandApi.getAllMapBySourceIds(new ArrayList<>(brandSid));
            if(!brandSourceResp.isSuccess() || MapUtils.isEmpty(brandSourceResp.getData())) {
                logger.error("根据品牌sid-{}查询品牌信息失败: {}", JSONObject.toJSONString(brandSid),
                        JSONObject.toJSONString(brandSourceResp, SerializerFeature.PrettyFormat));
            } else {
                Map<String, BrandVO> brandSourceMap = brandSourceResp.getData();
                for(MatSupplierMaterialInfoEntity info : allInfo) {
                    if(StringUtils.isNotBlank(info.getBrandSid()) && brandSourceMap.containsKey(info.getBrandSid())) {
                        info.setBrandId(brandSourceMap.get(info.getBrandSid()).getId().toString());
                    }
                }
            }
        }
    }

    private void handleBank(Map<String, List<MatSupplierBankEntity>> bankMap, JSONArray bankList) {
        logger.info("本次待处理供应商-银行数据：{}条", bankList.size());
        JSONObject tmpBankJson = null;
        MatSupplierBankEntity bankEntity = null;

        Set<String> bankName = new HashSet<>();
        Set<String> bankCategoryName = new HashSet<>();
        Set<String> bankCategoryCode = new HashSet<>();
        List<MatSupplierBankEntity> allBank = new ArrayList<>();
        for(Object obj : bankList) {
            tmpBankJson = (JSONObject) obj;
            bankEntity = new MatSupplierBankEntity();
            bankEntity.setBankThirdSourceId(tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID")); //ERP主键
            bankEntity.setBankNumber(tmpBankJson.getString("Contact_BankAccount")); //银行账号
            bankEntity.setNumberType(null != tmpBankJson.getInteger("AccountType") ? tmpBankJson.getInteger("AccountType")+1 : null); //账号类型
            bankEntity.setBankName(tmpBankJson.getString("SubBankName")); //银行名称
            bankEntity.setBankType(tmpBankJson.getString("BankType")); //银行类型
            bankEntity.setProvince(tmpBankJson.getString("Province")); //省
            bankEntity.setCity(tmpBankJson.getString("City")); //市
            bankEntity.setOpenBank(tmpBankJson.getString("Contact_Bank")); //开户行
            bankEntity.setBankLineNumber(tmpBankJson.getString("Contact_BankNumber")); //银行行号
            bankEntity.setSupplierSid(tmpBankJson.getString("C_PS_MESupplierInfo_FK")); //供应商ERP主键
            if(!bankMap.containsKey(bankEntity.getSupplierSid())) {
                bankMap.put(bankEntity.getSupplierSid(), new ArrayList<>());
            }
            if(StringUtils.isNotBlank(bankEntity.getOpenBank())) {
                bankName.add(bankEntity.getOpenBank());
            }
            if(StringUtils.isNotBlank(bankEntity.getBankName())) {
                bankCategoryName.add(bankEntity.getBankName());
            }
            if(StringUtils.isNotBlank(bankEntity.getBankType())) {
                bankCategoryCode.add(bankEntity.getBankType());
            }
            bankMap.get(bankEntity.getSupplierSid()).add(bankEntity);
            allBank.add(bankEntity);
        }

        Map<String, BankEntity> bankNameMap = bankService.getAllMapByNames(new ArrayList<>(bankName));
        Map<String, BankCategoryEntity> bankCategoryNameMap = bankCategoryService.getAllMapByNames(new ArrayList<>(bankCategoryName));
        Map<String, BankCategoryEntity> bankCategoryCodeMap = bankCategoryService.getAllMapByCodes(new ArrayList<>(bankCategoryCode));

        for(MatSupplierBankEntity bankSub : allBank) {
            if(StringUtils.isNotBlank(bankSub.getOpenBank()) && bankNameMap.containsKey(bankSub.getOpenBank())) {
                bankSub.setBankId(bankNameMap.get(bankSub.getOpenBank()).getId());
                bankSub.setBankSid(bankNameMap.get(bankSub.getOpenBank()).getSourceId());
            }
            if(StringUtils.isNotBlank(bankSub.getBankName()) && bankCategoryNameMap.containsKey(bankSub.getBankName())) {
                bankSub.setBankCategorySid(bankCategoryNameMap.get(bankSub.getBankName()).getSourceId());
                if(StringUtils.isNotBlank(bankSub.getBankType())) {
                    bankSub.setBankType(bankCategoryNameMap.get(bankSub.getBankName()).getCode());
                }
            }
            if(StringUtils.isNotBlank(bankSub.getBankType()) && bankCategoryCodeMap.containsKey(bankSub.getBankType())
                    && StringUtils.isBlank(bankSub.getBankCategorySid())) {
                bankSub.setBankCategorySid(bankCategoryCodeMap.get(bankSub.getBankType()).getSourceId());
                if(StringUtils.isNotBlank(bankSub.getBankName())) {
                    bankSub.setBankName(bankCategoryCodeMap.get(bankSub.getBankType()).getName());
                }
            }
        }
    }

    private void handleArchive(Map<String, List<MatSupplierAttachesEntity>> attachMap, JSONArray archiveList) {
        logger.info("本次待处理供应商-附件数据：{}条", archiveList.size());
        JSONObject tmpAttachJson = null;
        MatSupplierAttachesEntity attach = null;

        for(Object obj : archiveList) {
            tmpAttachJson = (JSONObject) obj;
            attach = new MatSupplierAttachesEntity();
//            attach.setSupplierId(tmpSupEntity.getId()); //供应商Id
            attach.setThirdSourceId(tmpAttachJson.getString("C_PS_ArchivesOID")); //ERP主键
            attach.setFileName(tmpAttachJson.getString("Attach_Name")); //附件名称
            attach.setFileType(tmpAttachJson.getString("Attach_Extension")); //附件扩展名
            attach.setType(tmpAttachJson.getString("Attach_Type")); //附件类型
            attach.setFileUrl(tmpAttachJson.getString("AttachBase64")); //附件url
            attach.setSourceType(3); //默认为ERP来源附件
            attach.setSupplierSid(tmpAttachJson.getString("C_PS_MESupplierInfo_FK")); //供应商ERP主键

//            tmpSupEntity.getAttachesList().add(attach);
            if(!attachMap.containsKey(attach.getSupplierSid())) {
                attachMap.put(attach.getSupplierSid(), new ArrayList<>());
            }
            attachMap.get(attach.getSupplierSid()).add(attach);
        }
    }

    private void handleLinker(Map<String, List<MatLinkerEntity>> linkerMap, JSONArray contactList) {
        logger.info("本次待处理供应商-联系人数据：{}条", contactList.size());
        MatLinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;

        for(Object obj : contactList) {
            tmpLinkerJson = (JSONObject) obj;
            tmpLinkerEntity = new MatLinkerEntity();
            tmpLinkerEntity.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode(tmpLinkerJson.getString("IDType"))); //证件类型
            tmpLinkerEntity.setIdCardId(tmpLinkerJson.getString("IDCard")); //证件ID
            tmpLinkerEntity.setName(tmpLinkerJson.getString("Company_Contact")); //联系人名称
            tmpLinkerEntity.setSupplierSid(tmpLinkerJson.getString("C_PS_MESupplierInfo_FK")); //供应商ERPSID
            tmpLinkerEntity.setMobileLinkPhone(tmpLinkerJson.getString("Contact_Mobile")); //联系人手机号
            tmpLinkerEntity.setLinkPhone(tmpLinkerJson.getString("Contact_Telephone")); //联系人固定电话
            tmpLinkerEntity.setElectronicMail(tmpLinkerJson.getString("Contact_Email"));//联系人邮箱
            tmpLinkerEntity.setAddress(tmpLinkerJson.getString("Contact_Address"));//联系人通讯地址
            //ERP联系人类型:法定代表人为1，授权代理人为2  EL联系人类型：1:法定代表人、2:法定授权人
            try {
                tmpLinkerEntity.setUserType(null != tmpLinkerJson.getInteger("ContactType") ?
                        tmpLinkerJson.getInteger("ContactType") : null);
            } catch (Exception e) {
                tmpLinkerEntity.setUserType(null);
                logger.error("物资联系人sid-{} 联系人类型格式化错误：{}", tmpLinkerJson.getString("subA_oid"), tmpLinkerJson.getString("ContactType"));
            }
            tmpLinkerEntity.setThirdSourceId(tmpLinkerJson.getString("subA_oid")); //联系人ERP主键
            tmpLinkerEntity.setCoordination("0"); //默认未协同
            tmpLinkerEntity.setLinkerStatus(StringUtils.isNotBlank(tmpLinkerJson.getString("ContactState")) ? Integer.valueOf(tmpLinkerJson.getString("ContactState")) : null); //联系人任职状态  联系人状态 1:离职，2：在职
            tmpLinkerEntity.setEnableStatus(2); //联系人状态 默认停用
//            tmpSupEntity.getLinkerList().add(tmpLinkerEntity);

            if(!linkerMap.containsKey(tmpLinkerEntity.getSupplierSid())) {
                linkerMap.put(tmpLinkerEntity.getSupplierSid(), new ArrayList<>());
            }
            linkerMap.get(tmpLinkerEntity.getSupplierSid()).add(tmpLinkerEntity);
        }
    }

    private String getDatePattern(String operatingPeriodStartEnd) {
        StringBuilder sp = new StringBuilder();
        String[] dateArr = operatingPeriodStartEnd.split(" ");
        String[] yearDateArr = dateArr[0].split("/");
        sp.append("yyyy/M");
        if(yearDateArr[1].length() > 1) {
            sp.append("M");
        }
        sp.append("/d");
        if(yearDateArr[1].length() > 1) {
            sp.append("d");
        }
        return sp.toString();
    }
}
