package com.ejianc.business.zdssupplier.material.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;


@RestController
@RequestMapping("/api/matSupplierApi/")
public class MatSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMatSupplierService supplierService;

    /**
     * 根据供应商来源Id，获取供应商信息
     */
    @GetMapping(value = "getOneBySourceId")
    CommonResponse<MatSupplierVO> getOneBySourceId(@RequestParam("sourceId") String sourceId, @RequestParam(required = false) String supplierType) {
        MatSupplierVO resp = null;
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("third_source_id", sourceId);
        MatSupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商来源Id，获取供应商信息
     * @param params sourceIds-List<String>  supplierType-String
     * @return
     */
    @PostMapping(value = "getAllBySourceIds")
    CommonResponse<List<MatSupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List<MatSupplierVO> resp = new ArrayList<>();
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("third_source_id", params.getJSONArray("sourceIds"));
        List<MatSupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     */
    @GetMapping(value = "getOneByCode")
    CommonResponse<MatSupplierVO> getOneByCode(@RequestParam("code") String code) {
        MatSupplierVO resp = null;
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("code", code);
        MatSupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据供应商编码，获取供应商信息
     * @return
     */
    @PostMapping(value = "getAllByCodes")
    CommonResponse<List<MatSupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List<MatSupplierVO> resp = new ArrayList<>();
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("code", code);
        List<MatSupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }


    /**
     * 根据租户Id获取对应供应商信息
     *
     * @param tenantId
     * @return
     */
    @GetMapping(value = "getByTenantId")
    CommonResponse<MatSupplierVO> getByTenantId(@RequestParam Long tenantId) {
        MatSupplierVO resp = null;
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("tenant", tenantId);
        MatSupplierEntity e = supplierService.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    /**
     * 根据租户Ids获取对应供应商信息列表
     *
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "getByTenantIds")
    CommonResponse<List<MatSupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List<MatSupplierVO> resp = new ArrayList<>();
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("tenant", tenantIds);
        List<MatSupplierEntity> eList = supplierService.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MatSupplierVO.class);
        }

        return CommonResponse.success(resp);
    }

    @GetMapping(value = "getOneById")
    CommonResponse<MatSupplierVO> getOneById(@RequestParam("id") Long id) {
        MatSupplierVO resp = null;
        MatSupplierEntity e = supplierService.selectById(id);
        if(null != e) {
            resp = BeanMapper.map(e, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }


    @PostMapping(value = "getAllByIds")
    CommonResponse<List<MatSupplierVO>> getAllByIds(@RequestBody List<Long> ids) {
        List<MatSupplierVO> resp = new ArrayList<>();
        QueryWrapper<MatSupplierEntity> query = new QueryWrapper<>();
        query.in("id", ids);

        List<MatSupplierEntity> dbList = supplierService.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

}
