package com.ejianc.business.zdssupplier.material.service;

import com.ejianc.business.zdssupplier.material.vo.MatLinkerAccessVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 物资联系人准入
 * 
 * @author generator
 * 
 */
public interface IMatLinkerAccessService extends IBaseService<MatLinkerAccessEntity> {

    MatLinkerAccessVO saveOrUpdate(MatLinkerAccessVO saveOrUpdateVO);

    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 校验手机号唯一性
     * @param linker
     * @return
     */
    Boolean validateUnique(MatLinkerAccessEntity linker, Long id);

    /**
     * 校验手机号唯一性
     * @return
     */
    Boolean validateUnique(List<MatLinkerAccessEntity> linkerList);

    /**
     * 根据邀请链接重新拉取分供方准入信息
     * @param inviteId
     * @return
     */
    MatLinkerAccessVO syncDetailBill(Long inviteId);
}
