package com.ejianc.business.zdssupplier.material.service;

import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierAccessVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 物资供应商准入
 * 
 * @author generator
 * 
 */
public interface IMatSupplierAccessService extends IBaseService<MatSupplierAccessEntity> {

    MatSupplierAccessVO saveOrUpdate(MatSupplierAccessVO saveOrUpdateVO);

    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 供应商名称调用天眼查
     * @param supplierName
     * @param id
     * @return
     */
    MatSupplierAccessVO TYCDetail(String supplierName, Long id);

    /**
     * 校验统一社会信用代码唯一性
     * @param socialCreditCode
     * @return
     */
    Boolean validateUnique(String name, String socialCreditCode, Long id);

    /**
     * 根据邀请链接重新拉取分供方准入信息
     * @param inviteId
     * @return
     */
    MatSupplierAccessVO syncDetailBill(Long inviteId);
}
