package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("matLinkerAccess") 
public class MatLinkerAccessBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String sourceBillType = BillTypeEnum.物资联系人准入.getCode();
	private static final String targetBillType = BillTypeEnum.物资联系人档案.getCode();

	@Autowired
	private IAttachmentApi attachmentApi;

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IMatLinkerAccessService service;

	@Autowired
	private IMatLinkerInviteService inviteService;

	@Autowired
	private IMatLinkerService linkerService;

	@Autowired
	private IMatSupplierService supplierService;

	@Autowired
	private IZDSMatSupManagerApi izdsMatSupManagerApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		MatLinkerAccessEntity entity = service.selectById(billId);
		MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());

//		if(StringUtil.isBlank(supplier.getErpCreatorSid())) {
//			return CommonResponse.error("操作失败，联系人所属供应商创建人信息获取失败!");
//		}

		if(PlanConstant.INTEGER_YES.equals(entity.getUserType())) {
			Integer legalNum = (int) supplier.getLinkerList().stream().filter(x->PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
			if(legalNum > 0){
				return CommonResponse.error("联系人类型为法定代表人最多只能有一条！");
			}
		}
		// 联系人校验
		linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		MatLinkerAccessEntity entity = service.selectById(billId);
		// 修改邀请状态并生成流水
		MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_COMMIT);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		MatLinkerAccessEntity entity = service.selectById(billId);
		// 修改邀请状态并生成流水
		MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_AFFIRM);
		inviteVO.setFlowType(PlanConstant.FLOW_TYPE_APPROVE_BACK);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MatLinkerAccessEntity entity = service.selectById(billId);
        MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        if(PlanConstant.INTEGER_YES.equals(entity.getUserType())) {
            Integer legalNum = (int) supplier.getLinkerList().stream().filter(x->PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
            if(legalNum > 0){
                throw new BusinessException("联系人类型为法定代表人最多只能有一条！");
            }
        }
        // 联系人校验
        linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
        return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//		if(BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
//			//验证创建人
//			if("1".equals(entity.getSourceType())) {
//				//代注册  注册人为创建人
//				CommonResponse<EmployeeVO> empResp = employeeApi.getByEmpmloyeeCode(entity.getCreateUserCode());
//				if(!empResp.isSuccess() || null == empResp.getData()) {
//					return CommonResponse.error("获取注册人信息信息失败！");
//				}
//				if(StringUtil.isBlank(empResp.getData().getSourceId())) {
//					return CommonResponse.error("操作失败，注册人Sid信息为空！");
//				}
//			} else {
//				//邀请  邀请人为创建人
//				CommonResponse<EmployeeVO> empResp = employeeApi.getById(entity.getInviterId());
//				if(!empResp.isSuccess() || null == empResp.getData()) {
//					return CommonResponse.error("获取邀请人信息信息失败！");
//				}
//				if(StringUtil.isBlank(empResp.getData().getSourceId())) {
//					return CommonResponse.error("操作失败，邀请人Sid信息为空！");
//				}
//			}
//		}

		MatLinkerAccessEntity entity = service.selectById(billId);
		// 生成档案
		Long linkerId = this.pushToArchive(entity);

		//推送ERP
		String msg = supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), linkerId,
				PlanConstant.联系人新增同步ERP, billId, true, entity.getInviterId(), entity.getInviterName()));
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException(msg);
		}

		//推送ERP成功 生成联系人账号
		try {
			linkerService.createSupAccount(linkerId);
		} catch (Exception e) {
			logger.error("***********供应商id-{}，联系人准入成功，推送ERP成功，联系人id-{}生成协同账号失败！！！", entity.getSupplierId(), linkerId, e);
		}

		// 修改邀请状态并生成流水
		MatLinkerInviteVO inviteVO = new MatLinkerInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_APPROVE);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	}

	/**
	 * 生成档案
	 * @param entity
	 */
	@Transactional(rollbackFor = Exception.class)
	public Long pushToArchive(MatLinkerAccessEntity entity) {
		// 初始化数据，包含子表
		MatLinkerVO save = EntityUtil.clearInvalidEntity(entity, MatLinkerVO.class);
		save.setAccessId(entity.getId());
//		save.setThirdSourceId(UUID.randomUUID().toString());// 推送ERP
		save.setLinkerStatus(2);// 默认在职
		save.setEnableStatus(1);// 默认启用
		save.setChangeVersion(0);//默认0
		save.setDateType(0);//默认 档案
		MatLinkerVO linker = linkerService.saveOrUpdate(save, "false", false);

		// 附件处理
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
				String.valueOf(linker.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

		String sourceType = entity.getUserType() == 2 ? PlanConstant.AGENT_SOURCE_TYPE : PlanConstant.LEGAL_PERSON_SOURCE_TYPE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, sourceType,
				String.valueOf(linker.getId()), targetBillType, sourceType);
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.CERTIFY_SOURCE_TYPE,
				String.valueOf(linker.getId()), targetBillType, PlanConstant.CERTIFY_SOURCE_TYPE);
	    return linker.getId();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
		JSONArray resp = new JSONArray();
		MatLinkerAccessEntity entity = service.selectById(billId);
		MatSupplierEntity supplier = supplierService.selectById(entity.getSupplierId());

		//获取供应商公户信息中的物料分类Id列表
		List<MatSupplierMaterialInfoEntity> msList = supplier.getMaterialInfoList();
		List<Long> categoryIds = msList.stream().map(MatSupplierMaterialInfoEntity::getMaterialId).collect(Collectors.toList());

		if(CollectionUtils.isEmpty(categoryIds)) {
			return CommonResponse.error("操作失败，联系人所属供应商下供货内容的物资分类为空，无法获取到对应审核人信息！");
		}
		CommonResponse<List<MatSupplierManagerVO>> settingResp = izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
		if(!settingResp.isSuccess()) {
			logger.error("根据物料分类ids-{}获取对应审核人信息失败，{}", categoryIds, JSONObject.toJSONString(settingResp, SerializerFeature.PrettyFormat));
			return CommonResponse.error("获取供应商审核人信息失败！");
		}
		List<MatSupplierManagerVO> settingList = settingResp.getData();
		if(CollectionUtils.isNotEmpty(settingList)) {
			for(MatSupplierManagerVO m : settingList) {
				JSONObject obj = new JSONObject();
				obj.put("userId", m.getManagerId());
				obj.put("userName", m.getManagerName());
				resp.add(obj);
			}
		}

		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，联系人所属供应商的供货内容的物资分类未设置审核人信息！");
		}

		return CommonResponse.success(resp);
	}

}
