package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupStatusEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatLinkerChangeMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资联系人变更
 *
 * @author generator
 */
@Service("matLinkerChangeService")
public class MatLinkerChangeServiceImpl extends BaseServiceImpl<MatLinkerChangeMapper, MatLinkerChangeEntity> implements IMatLinkerChangeService {
    private final String OPERATE = "matLinkerChangeBill";


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matLinkerChange/syncBill";//推送接口
    private static final String BILL_CODE = "ZDS_MAT_LINKER_CHANGE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IMatLinkerService linkerService;
    @Autowired
    private IAttachmentApi attachmentRefApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Override
    public MatLinkerChangeVO addConvertById(Long linkerId) {
        MatLinkerEntity linkerEntity = linkerService.selectById(linkerId);
        if (SupLinkerEnum.变更中.getCode().equals(linkerEntity.getChangeStatus())) {
            return queryDetail(linkerEntity.getChangeId());
        }
        MatLinkerChangeVO changeVO = BeanMapper.map(linkerEntity, MatLinkerChangeVO.class);
        changeVO.setChangeVersion(changeVO.getChangeVersion()+1);
        changeVO.setBillState(null);
        changeVO.setLinkerId(linkerId);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setSourceType(SupStatusEnum.项目.getCode());

        changeVO.setBeforeAgencyFileId(linkerEntity.getAgencyFileId());
        changeVO.setAgencyFileId(null);
        changeVO.setAgencyFileName(null);
        changeVO.setBeforeAgencyFileName(linkerEntity.getAgencyFileName());
        changeVO.setBeforeCertifyFileId(linkerEntity.getCertifyFileId());
        changeVO.setBeforeCertifyFileName(linkerEntity.getCertifyFileName());
        changeVO.setCertifyFileId(null);
        changeVO.setCertifyFileName(null);
        changeVO.setBeforePersonFileId(linkerEntity.getLegalPersonFileId());
        changeVO.setBeforePersonFileName(linkerEntity.getLegalPersonFileName());
        changeVO.setLegalPersonFileId(null);
        changeVO.setLegalPersonFileName(null);

        return changeVO;
    }

    @Override
    public MatLinkerChangeVO queryDetail(Long changeId) {
        MatLinkerChangeEntity matLinkerChangeEntity = super.selectById(changeId);
        MatLinkerChangeVO changeVO = BeanMapper.map(matLinkerChangeEntity, MatLinkerChangeVO.class);
        changeField(changeVO);
        return changeVO;
    }

    public void changeField(MatLinkerChangeVO changeVO) {
        List<String> changeField = new ArrayList<>();
        //先查询联系人信息
        MatLinkerEntity matLinkerEntity = linkerService.selectById(changeVO.getLinkerId());
        MatLinkerChangeVO resultData = BeanMapper.map(matLinkerEntity, MatLinkerChangeVO.class);
        //比较请求数据
        if(!StringUtils.equals(resultData.getMobileLinkPhone(), changeVO.getMobileLinkPhone())) {
            changeField.add("mobileLinkPhone");
        }
        if(!StringUtils.equals(resultData.getElectronicMail(), changeVO.getElectronicMail())) {
            changeField.add("electronicMail");
        }
        if(!StringUtils.equals(resultData.getAddress(), changeVO.getAddress())) {
            changeField.add("address");
        }
        if(!StringUtils.equals(String.valueOf(resultData.getUserType()), String.valueOf(changeVO.getUserType()))) {
            changeField.add("userType");
            if (changeVO.getUserType() == 1) {
                changeField.add("legalPersonFile");
            } else {
                changeField.add("agencyFile");
                if(null != resultData.getCertifyFileId()) {
                    changeField.add("certifyFile");
                }
            }
        } else {
            if (changeVO.getUserType() == 1) {
                if (null != changeVO.getLegalPersonFileId()) {
                    changeField.add("legalPersonFile");
                }
            } else {
                if (null != changeVO.getAgencyFileId()) {
                    changeField.add("agencyFile");
                }
                if (null != changeVO.getCertifyFileId()) {
                    changeField.add("certifyFile");
                }
            }
        }
        if(!matLinkerEntity.getName().equals(changeVO.getUserName())) {
            changeField.add("name");
            changeField.add("userName");
            changeField.add("beforeName");
        }
        if(!String.valueOf(changeVO.getLinkerStatus()).equals(changeVO.getLinkerStatus())) {
            changeField.add("linkerStatus");
        }
        changeVO.setChangeField(changeField);
    }

    @Override
    public JSONObject contrast(Long linkerId) {
        //先查询联系人信息
        JSONObject js = new JSONObject();
        MatLinkerEntity linkerEntity = linkerService.selectById(linkerId);
        js.put("MatLinkerEntity", BeanMapper.map(linkerEntity, MatLinkerChangeVO.class));
        MatLinkerChangeVO matLinkerChangeVO = queryDetail(linkerEntity.getChangeId());
        js.put("MatLinkerChangeVO", matLinkerChangeVO);
        return js;
    }

    @Override
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        //变更查询当前是否是变更中
        String transData = request.getParameter("transData");
        String fileListStr = request.getParameter("fileList");
        List<AttachmentVO> fileList = JSONObject.parseObject(fileListStr, new TypeReference<List<AttachmentVO>>(){});
        logger.info("接收到数据transData：{}，fileList：{}", transData, fileList);
        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        MatLinkerChangeEntity entity = JSONObject.parseObject(transData, MatLinkerChangeEntity.class);
        Long linkerId = entity.getLinkerId();
        long id = IdWorker.getId();
        //查询当前是否变更中
        boolean b = linkerService.linkerChangeStatus(linkerId, id);
        if (b){
            return CommonResponse.error("当前联系人正在变更中，请稍后重试！");
        }
        //查询附件
        entity.setSourceId(entity.getId());
        entity.setId(id);
//        fileLock(entity);
        // 保存单据中附件并获取到上传后附件的Id
//        List<Long> attachIds = pushSupUtil.uploadFileFormNet(fileList, SupLinkerEnum.物资联系人变更单据类型.getValue());
//        entity.setAttachIds(attachIds);

        if(Integer.valueOf(1).equals(entity.getUserType())) {
            if(StringUtils.isNotBlank(entity.getLegalPersonFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.物资联系人变更单据类型.getValue(), entity.getId(), PlanConstant.LEGAL_PERSON_SOURCE_TYPE,
                        Long.valueOf(entity.getLegalPersonFileId()));
                entity.setLegalPersonFileId(fileId.toString());
            }
        } else {
            if(StringUtils.isNotBlank(entity.getAgencyFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.物资联系人变更单据类型.getValue(), entity.getId(), PlanConstant.AGENT_SOURCE_TYPE,
                        Long.valueOf(entity.getAgencyFileId()));
                entity.setAgencyFileId(fileId.toString());
            }
            if(StringUtils.isNotBlank(entity.getCertifyFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.物资联系人变更单据类型.getValue(), entity.getId(), PlanConstant.CERTIFY_SOURCE_TYPE,
                        Long.valueOf(entity.getCertifyFileId()));
                entity.setCertifyFileId(fileId.toString());
            }
        }

        //讲项目方变更前文件Id更新至变更单中
        MatLinkerEntity dbLinker = linkerService.selectById(linkerId);
        entity.setBeforeAgencyFileId(dbLinker.getAgencyFileId());
        entity.setBeforeCertifyFileId(dbLinker.getCertifyFileId());
        entity.setBeforePersonFileId(dbLinker.getLegalPersonFileId());

        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(SupLinkerEnum.初审待确认.getCode());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        logger.info("物资联系人转换保存单据: {}", JSONObject.toJSONString(entity));
        super.saveOrUpdate(entity, false);

        return CommonResponse.success("单据同步成功！");
    }

    @Override
    public CommonResponse<MatLinkerChangeVO> saveOrUpdate(MatLinkerChangeVO saveOrUpdateVO) {
        MatLinkerChangeEntity entity = BeanMapper.map(saveOrUpdateVO, MatLinkerChangeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
            boolean b = linkerService.linkerChangeStatus(entity.getLinkerId(), entity.getId());
            if (b){
                return CommonResponse.error("当前联系人正在变更中，请稍后重试！");
            }
        }
        super.saveOrUpdate(entity, false);

        MatLinkerChangeVO changeVO = queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！", changeVO);
    }

//    public void fileLock(MatLinkerChangeEntity entity) {
//        if (entity.getNewFileIds()!=null&&entity.getNewFileIds().size()>0) {
//            CommonResponse<AttachmentVO> fileResp = attachmentRefApi.queryDetail(String.valueOf(entity.getNewFileIds().get(0)));
//            if (fileResp.isSuccess() && null == fileResp.getData()) {
//                UploadFileForNetParam uploadFileForNetParam = new UploadFileForNetParam();
//                uploadFileForNetParam.setTenantId(InvocationInfoProxy.getTenantid());
//                uploadFileForNetParam.setBillType(SupLinkerEnum.物资联系人变更单据类型.getValue());
//                uploadFileForNetParam.setSourceId(entity.getId());
//                uploadFileForNetParam.setSourceType(entity.getUserType() == 1 ? SupLinkerEnum.法人sourceType.getValue() : SupLinkerEnum.代理人人sourceType.getValue());
//                uploadFileForNetParam.setFilePathList(entity.getFilePathList());
//                uploadFileForNetParam.setNewFileIds(entity.getNewFileIds());
//                CommonResponse<String> stringCommonResponse = attachmentRefApi.uploadFileFormNet(uploadFileForNetParam);
//                logger.info("上传附件结果:{}", JSONObject.toJSONString(stringCommonResponse));
//            }
//        }
//    }

    @Override
    public CommonResponse<MatLinkerChangeVO> pushStatus(Long id) {
        MatLinkerChangeEntity entity = super.selectById(id);
        linkerService.upLinkerChangeStatus(entity.getLinkerId(), SupLinkerEnum.未变更.getCode(), null);
        entity.setReceiveStatus(SupLinkerEnum.已驳回供方.getCode());
        String s = pushBill(entity);
        if (StringUtils.isNotBlank(s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate(entity, false);
        MatLinkerChangeVO vo = BeanMapper.map(entity, MatLinkerChangeVO.class);
        return CommonResponse.success("驳回成功！", vo);
    }


    @Override
    public String pushBill(MatLinkerChangeEntity entity) {
        //推送当前单据

        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "物资联系人变更推送供应链平台失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(entity));
            logger.info("物资联系人变更推送供应链平台: url-{}, 物资联系人变更：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), null);
            logger.error("物资联系人变更推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("物资联系人变更id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "物资联系人变更推送供应链平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("物资联系人变更id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "物资联系人变更推送供应链平台失败";
            }
        } catch (Exception e) {
            logger.error("物资联系人变更id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，物资联系人变更推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

}
