package com.ejianc.business.zdssupplier.material.service.impl;

import com.ejianc.business.zdssupplier.material.bean.MatLinkerInviteFlowEntity;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.material.mapper.MatLinkerInviteFlowMapper;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerInviteFlowEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteFlowService;

import java.util.Date;

/**
 * 物资联系人邀请流水
 * 
 * @author generator
 * 
 */
@Service("matLinkerInviteFlowService")
public class MatLinkerInviteFlowServiceImpl extends BaseServiceImpl<MatLinkerInviteFlowMapper, MatLinkerInviteFlowEntity> implements IMatLinkerInviteFlowService{

    @Autowired
    private SessionManager sessionManager;

    @Override
    public MatLinkerInviteFlowVO saveOrUpdate(MatLinkerInviteFlowVO saveOrUpdateVO) {
        MatLinkerInviteFlowEntity entity = BeanMapper.map(saveOrUpdateVO, MatLinkerInviteFlowEntity.class);
        UserContext user = sessionManager.getUserContext();
        entity.setOperatorId(user.getUserId());
        entity.setOperatorCode(user.getUserCode());
        entity.setOperatorName(user.getUserName());
        entity.setOperatorPhone(user.getUserMobile());
        entity.setOperateTime(new Date());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MatLinkerInviteFlowVO.class);
    }
}
