package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.consumer.TransferVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierAccessMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierAccessVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资供应商准入
 * 
 * @author generator
 * 
 */
@Service("matSupplierAccessService")
public class MatSupplierAccessServiceImpl extends BaseServiceImpl<MatSupplierAccessMapper, MatSupplierAccessEntity> implements IMatSupplierAccessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = BillTypeEnum.物资供应商准入.getCode();
    private static final String BILL_NAME = BillTypeEnum.物资供应商准入.getName();
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_ACCESS";//此处需要根据实际修改
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierAccess/syncDetailBill";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMatSupplierInviteService inviteService;

    @Autowired
    private IMatSupplierService supplierService;

    @Autowired
    private IMatLinkerAccessService linkerService;

    @Override
    public MatSupplierAccessVO saveOrUpdate(MatSupplierAccessVO saveOrUpdateVO) {
        MatSupplierAccessEntity entity = BeanMapper.map(saveOrUpdateVO, MatSupplierAccessEntity.class);

//        // 校验统一社会信用代码唯一性
//        this.validateUnique(entity.getSocialCreditCode(), entity.getLinkerList(), entity.getId());
//
//        if(CollectionUtils.isEmpty(entity.getLinkerList())){
//            throw new BusinessException("请添加至少一条联系人！");
//        }
//        if(CollectionUtils.isEmpty(entity.getBankList())){
//            throw new BusinessException("请添加至少一条银行信息！");
//        }
//        if(CollectionUtils.isEmpty(entity.getMaterialInfoList())){
//            throw new BusinessException("请添加至少一条供货信息！");
//        }
//
//        // 校验附件必输性
//        for(MatSupplierAccessAttachesEntity attach : entity.getAttachesList()){
//            if(PlanConstant.matCompanyAttachNameMap.containsKey(attach.getFileType()) &&
//                    PlanConstant.matCompanyAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//                throw new BusinessException(attach.getFileType() + "未上传附件，请上传后保存！");
//            }
//            if(PlanConstant.matPersonAttachNameMap.containsKey(attach.getFileType()) &&
//                    PlanConstant.matPersonAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//                throw new BusinessException(attach.getFileType() + "未上传附件，请上传后保存！");
//            }
//        }
        // 联系人校验
        linkerService.validateUnique(entity.getLinkerList());

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            // 待注册，默认邀请人为当前登录人
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(sessionManager.getUserContext().getUserName());
        }
        // 切换公司性质，需更新附件
        this.updateAttachList(entity);
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MatSupplierAccessVO.class);
    }

    /**
     * 切换公司性质，需更新附件
     * @param entity
     */
    private void updateAttachList(MatSupplierAccessEntity entity) {
        Map<String, Boolean> nameMap = PlanConstant.matCompanyAttachNameMap;
        if(PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
            nameMap = PlanConstant.pdCompanyAttachNameMap;
        }
        Map<String, Boolean> finalNameMap = nameMap;
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        if(attachList.stream().noneMatch(x-> finalNameMap.keySet().contains(x.getFileType()))){
            for(String name : nameMap.keySet()){
                MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setType("企业");
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        } else {
            for(MatSupplierAccessAttachesEntity vo : attachList){
                if(vo.getFileType().startsWith("资质类证书（有资质的，必须上传盖公章版资质文件扫描件）")){
                    StringBuilder fileType = new StringBuilder();
                    fileType.append("资质类证书（有资质的，必须上传盖公章版资质文件扫描件）");
                    if(PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
                        fileType.append("安环认证体系、质量认证体系");
                    }
                    vo.setFileType(fileType.toString());
                }
                if(vo.getFileType().equals("生产商出具的授权文件")){
                    if(PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
                        vo.setRowState("del");
                    }
                }
            }
            if(!PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
                if(attachList.stream().noneMatch(x-> "生产商出具的授权文件".equals(x.getFileType()))){
                    MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                    vo.setFileType("生产商出具的授权文件");
                    vo.setType("企业");
                    vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                    attachList.add(vo);
                }
            }
        }
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        MatSupplierAccessEntity saveEntity = JSONObject.parseObject(transData, MatSupplierAccessEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter(QueryParam.EQ, saveEntity.getInviteId()));
        List<MatSupplierAccessEntity> list = super.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该邀请链接已生成准入，不允许重复生成！");
        }

//        // 校验统一社会信用代码唯一性
//        List<MatLinkerAccessEntity> linkerList = BeanMapper.mapList(saveEntity.getJSONArray("linkerList"), MatLinkerAccessEntity.class);
//        this.validateUnique(saveEntity.getString("socialCreditCode"), linkerList, null);
//
//        if(CollectionUtils.isEmpty(saveEntity.getJSONArray("linkerList"))){
//            throw new BusinessException("请添加至少一条联系人！");
//        }
//        if(CollectionUtils.isEmpty(saveEntity.getJSONArray("bankList"))){
//            throw new BusinessException("请添加至少一条银行信息！");
//        }
//        if(CollectionUtils.isEmpty(saveEntity.getJSONArray("materialInfoList"))){
//            throw new BusinessException("请添加至少一条供货信息！");
//        }
//
//        // 校验附件必输性
//        for(Object obj : saveEntity.getJSONArray("attachesList")){
//            JSONObject attach = (JSONObject) obj;
//            String fileType = attach.getString("fileType");
//            if(PlanConstant.matCompanyAttachNameMap.containsKey(fileType) &&
//                    PlanConstant.matCompanyAttachNameMap.get(fileType) && null == attach.getString("fileId")){
//                throw new BusinessException(fileType + "未上传附件，请上传后保存！");
//            }
//            if(PlanConstant.matPersonAttachNameMap.containsKey(fileType) &&
//                    PlanConstant.matPersonAttachNameMap.get(fileType) && null == attach.getString("fileId")){
//                throw new BusinessException(fileType + "未上传附件，请上传后保存！");
//            }
//        }
        // 联系人校验
        linkerService.validateUnique(saveEntity.getLinkerList());

        Long id = pushSupUtil.saveSyncBill(request, MatSupplierAccessEntity.class, BILL_TYPE, BILL_NAME);
        if(null == id) {
            throw new BusinessException("同步数据异常！");
        }
        MatSupplierAccessEntity entity = super.selectById(id);
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        // MQ同步文件
        List<MatLinkerAccessEntity> likerList = entity.getLinkerList();
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        for(MatLinkerAccessEntity liker : likerList){
            Long fileId = null;
            List<Long> attachIds = new ArrayList<>();
            if(liker.getUserType() == 2){
                fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.AGENT_SOURCE_TYPE, Long.valueOf(liker.getAgencyFileId()));
                liker.setAgencyFileId(fileId.toString());
                attachIds.add(fileId);
                if(null != liker.getCertifyFileId()) {
                    Long certifyFileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.CERTIFY_SOURCE_TYPE, Long.valueOf(liker.getCertifyFileId()));
                    liker.setCertifyFileId(certifyFileId.toString());
                    attachIds.add(certifyFileId);
                }
            } else {
                fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(liker.getLegalPersonFileId()));
                liker.setLegalPersonFileId(fileId.toString());
                attachIds.add(fileId);
            }
            liker.setAttachIds(attachIds);
        }
        for(MatSupplierAccessAttachesEntity attach : attachList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), PlanConstant.FILE_SOURCE_TYPE, attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate(entity, false);
        // 修改邀请状态并生成流水
        MatSupplierInviteVO inviteVO = new MatSupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus(PlanConstant.INVITE_STATUS_AFFIRM);
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public MatSupplierAccessVO TYCDetail(String supplierName, Long id) {
        if(StringUtils.isEmpty(supplierName)){
            throw new BusinessException("企业名称不能为空！");
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, supplierName));
//        queryParam.getOrderMap().put("invokeDate", QueryParam.DESC);
//        List<MatSupplierAccessEntity> dataList = super.queryList(queryParam);
//        if(CollectionUtils.isNotEmpty(dataList)){
//            Date invokeDate = dataList.get(0).getInvokeDate();
//            if(invokeDate != null && DateUtil.compareDate(DateUtil.addDays(DateUtil.beginOfDate(invokeDate), 1), new Date()) > 0){
//                throw new BusinessException("一个企业名称当天只能调用一次天眼查，请明天再试！");
//            }
//        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company){
            return new MatSupplierAccessVO();
        }
        MatSupplierAccessEntity entity = null;
        if(id != null){
            entity = super.selectById(id);
        }
        if(entity == null){
            entity = new MatSupplierAccessEntity();
            // 生成单据编码
            entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
            // 待注册，默认邀请人为当前登录人
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(sessionManager.getUserContext().getUserName());
            entity.setCompanyGrade("临时");
            entity.setCompanyState("正常");
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(StringUtils.isNotEmpty(company.getPaidCapitalStr())?company.getPaidCapitalStr():"-");
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
//        List<BaseCertificateVO> certList = company.getCertiList();
        // 默认附件
        if(StringUtils.isEmpty(entity.getCompanyCharacter())){
            entity.setCompanyCharacter(PlanConstant.STRING_YES);// 默认生产商
        }
        Map<String, Boolean> nameMap = PlanConstant.matCompanyAttachNameMap;
        if(PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
            nameMap = PlanConstant.pdCompanyAttachNameMap;
        }
        Map<String, Boolean> finalNameMap = nameMap;
        List<MatSupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        if(attachList.stream().noneMatch(x-> finalNameMap.keySet().contains(x.getFileType()))){
            for(String name : nameMap.keySet()){
                MatSupplierAccessAttachesEntity vo = new MatSupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setType("企业");
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        }
        super.saveOrUpdate(entity, false);
        MatSupplierAccessVO vo = BeanMapper.map(entity, MatSupplierAccessVO.class);
        return vo;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id) {
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<MatSupplierAccessEntity> accessList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(accessList)){
            throw new BusinessException("该供应商的统一社会信用代码已生成准入【" + accessList.get(0).getCode() + "】，不允许重复准入！");
        }
        // 校验统一社会信用代码唯一性
        supplierService.validateUnique(name, socialCreditCode, null, "准入");
        return true;
    }

    @Override
    public MatSupplierAccessVO syncDetailBill(Long inviteId) {
        MatSupplierAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if(null == entity.getId()){
            // 不存在准入，从分供方重新拉取
            Map<String, String> params = new HashMap<>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()){
                CommonResponse<String> resp = JSONObject.parseObject(response.getData(), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf(resp.getData()));
            }else {
                throw new BusinessException(response.getMsg());
            }
        }
        return BeanMapper.map(entity, MatSupplierAccessVO.class);
    }

    /**
     * 根据邀请链接id查询准入
     * @param inviteId
     * @return
     */
    private MatSupplierAccessEntity getEntityByInviteId(Long inviteId, Long sourceId){
        QueryParam queryParam = new QueryParam();
        if(sourceId != null){
            queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.EQ, inviteId));
        }
        List<MatSupplierAccessEntity> list = super.queryList(queryParam);
        MatSupplierAccessEntity entity = new MatSupplierAccessEntity();
        if(CollectionUtils.isNotEmpty(list)){
            entity = super.selectById(list.get(0).getId());
        }
        return entity;
    }
}
