package com.ejianc.business.zdssupplier.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierBankMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierBankService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;

import java.util.List;

/**
 * 物资供应商档案-银行信息
 * 
 * @author generator
 * 
 */
@Service("matSupplierBankService")
public class MatSupplierBankServiceImpl extends BaseServiceImpl<MatSupplierBankMapper, MatSupplierBankEntity> implements IMatSupplierBankService {

    @Override
    public List<MatSupplierBankEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<MatSupplierBankEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
