package com.ejianc.business.zdssupplier.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierChangeMaterialInfoMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeMaterialInfoVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资供应商变更-供货信息
 * 
 * @author generator
 * 
 */
@Service("matSupplierChangeMaterialInfoService")
public class MatSupplierChangeMaterialInfoServiceImpl extends BaseServiceImpl<MatSupplierChangeMaterialInfoMapper, MatSupplierChangeMaterialInfoEntity> implements IMatSupplierChangeMaterialInfoService{

    @Autowired
    private MatSupplierChangeMaterialInfoMapper mapper;

    @Override
    public List<MatSupplierChangeMaterialInfoEntity> getAllByChangeId(Long changeId) {
        QueryWrapper<MatSupplierChangeMaterialInfoEntity> query = new QueryWrapper<>();
        query.eq("change_id", changeId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<MatSupplierChangeMaterialInfoVO> getDeledRecord(Long changeId) {
        return mapper.getDeledRecord(changeId);
    }

    @Override
    public List<Long> getAllSupIdsByCategoryIds(List<Long> categoryIds) {
        List<Long> resp = new ArrayList<>();
        QueryWrapper<MatSupplierChangeMaterialInfoEntity> query = new QueryWrapper<>();
        query.in("material_id", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
//        query.eq("enable_status", 1);

        List<MatSupplierChangeMaterialInfoEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            resp = new ArrayList<>(list.stream().map(MatSupplierChangeMaterialInfoEntity::getChangeId).collect(Collectors.toSet()));
        }

        return resp;
    }
}
