package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.*;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierChangeMapper;
import com.ejianc.business.zdssupplier.material.service.*;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeFlowVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierHistoryAttachesVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierHistoryVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资供应商变更
 * 
 * @author generator
 * 
 */
@Service("matSupplierChangeService")
public class MatSupplierChangeServiceImpl extends BaseServiceImpl<MatSupplierChangeMapper, MatSupplierChangeEntity> implements IMatSupplierChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_CHANGE";//此处需要根据实际修改
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.物资供应商变更.getCode();
    private static final String BILL_NAME = BillTypeEnum.物资供应商变更.getName();
    private static final String sourceBillType = BillTypeEnum.物资供应商档案.getCode();
    private static final String targetBillType = BillTypeEnum.物资供应商变更.getCode();
    private static final String historyBillType = BillTypeEnum.物资供应商历史.getCode();

    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierChange/syncBillStatus";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IMatSupplierService supplierService;

    @Autowired
    private IMatSupplierHistoryService historyService;

    @Autowired
    private IMatSupplierChangeFlowService flowService;

    @Autowired
    private IMatSupplierChangeMaterialInfoService matSupplierChangeMaterialInfoService;

    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    @Override
    public MatSupplierChangeVO saveOrUpdate(MatSupplierChangeVO saveOrUpdateVO) {
        MatSupplierChangeEntity entity = BeanMapper.map(saveOrUpdateVO, MatSupplierChangeEntity.class);
        if(null == entity.getId()) {
            MatSupplierEntity supplier = supplierService.selectById(saveOrUpdateVO.getSupplierId());
            if(!supplier.getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), supplier.getInvokeDate()) == 0){
                throw new BusinessException("供应商名称已修改，请先点击天眼查同步企业信息！");
            }
        } else {
            MatSupplierChangeEntity data = super.selectById(entity.getId());
            if(!data.getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), data.getInvokeDate()) == 0){
                throw new BusinessException("供应商名称已修改，请先点击天眼查同步企业信息！");
            }
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        }
        super.saveOrUpdate(entity, false);
        MatSupplierChangeVO vo = BeanMapper.map(entity, MatSupplierChangeVO.class);
        return vo;
    }

    @Override
    public MatSupplierChangeVO saveChangeBySupplierId(Long id) {
        MatSupplierEntity supplier = supplierService.selectById(id);
        // 初始化数据，包含子表
        MatSupplierChangeEntity entity = EntityUtil.clearInvalidEntity(supplier, MatSupplierChangeEntity.class);
        entity.setSupplierId(id);
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        UserContext user = pushSupUtil.getUser();
        entity.setEmployeeId(user.getEmployeeId());
        entity.setEmployeeName(user.getEmployeeName());
        entity.setBillDate(new Date());
        // 保存
        super.saveOrUpdate(entity, false);
        // TODO 同步附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(supplier.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
                String.valueOf(entity.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

        Map<Long, MatSupplierChangeAttachesEntity> attachMap = entity.getAttachesList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
        for(MatSupplierAttachesEntity source : supplier.getAttachesList()){
            if(attachMap.containsKey(source.getId())){
                MatSupplierChangeAttachesEntity target = attachMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
                        String.valueOf(target.getId()), targetBillType, PlanConstant.FILE_SOURCE_TYPE);
            }
        }

        // 生成历史记录
        this.pushToHistory(entity.getSupplierId(), entity.getId());

        MatSupplierChangeVO resp = BeanMapper.map(entity, MatSupplierChangeVO.class);
        resp.setCorpSid(supplier.getCorpSid());
        resp.setCorpErpName(supplier.getCorpErpName());
        resp.setErpType(supplier.getErpType());
        return resp;
    }

    @Override
    public MatSupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id) {
        if(StringUtils.isEmpty(supplierName)){
            throw new BusinessException("企业名称不能为空！");
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, supplierName));
//        queryParam.getOrderMap().put("invokeDate", QueryParam.DESC);
//        List<SupplierChangeEntity> dataList = super.queryList(queryParam);
//        if(CollectionUtils.isNotEmpty(dataList)){
//            Date invokeDate = dataList.get(0).getInvokeDate();
//            if(invokeDate != null && DateUtil.compareDate(DateUtil.addDays(DateUtil.beginOfDate(invokeDate), 1), new Date()) > 0){
//                throw new BusinessException("一个企业名称当天只能调用一次天眼查，请明天再试！");
//            }
//        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company){
            return new MatSupplierChangeVO();
        }
        MatSupplierChangeEntity entity = null;
        if(id != null){
            entity = super.selectById(id);
        }
        if(entity == null){
            MatSupplierChangeVO vo = this.saveChangeBySupplierId(supplierId);
            entity = BeanMapper.map(vo, MatSupplierChangeEntity.class);
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(company.getPaidCapitalStr());
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List<BaseCertificateVO> certList = company.getCertiList();
        super.saveOrUpdate(entity, false);
        MatSupplierChangeVO vo = BeanMapper.map(entity, MatSupplierChangeVO.class);
        return vo;
    }

    @Override
    public Boolean validateRunning(Long supplierId, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        param.getParams().put("id", new Parameter(QueryParam.NE, id));
        param.getParams().put("status", new Parameter(QueryParam.IN, "2,3"));// 在途状态
        List<MatSupplierChangeEntity> list = super.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> billCodes = list.stream().map(MatSupplierChangeEntity::getCode).collect(Collectors.toSet());
            throw new BusinessException("该供应商存在进行中变更单【" + StringUtils.join(billCodes, ",") + "】，不允许再次发起变更!");
        }
        return true;
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        MatSupplierChangeEntity saveEntity = JSONObject.parseObject(transData, MatSupplierChangeEntity.class);
        // 校验是否有在途单据
        this.validateRunning(saveEntity.getSupplierId(), saveEntity.getId());

        // 推送生成
        Long id = pushSupUtil.saveSyncBill(request, MatSupplierChangeEntity.class, BILL_TYPE, BILL_NAME, false);
        if(null == id) {
            throw new BusinessException("同步数据异常！");
        }
        MatSupplierChangeEntity entity = super.selectById(id);
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER.toString());
        // MQ同步文件
        List<MatSupplierChangeAttachesEntity> attachList = entity.getAttachesList();
        for(MatSupplierChangeAttachesEntity attach : attachList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), PlanConstant.FILE_SOURCE_TYPE, attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate(entity, false);

        // 生成历史记录
        this.pushToHistory(entity.getSupplierId(), entity.getId());

        // 修改变更状态并生成流水
        MatSupplierChangeVO vo = new MatSupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus(PlanConstant.CHANGE_STATUS_AFFIRM);
        vo.setEmployeeId(entity.getEmployeeId());
        vo.setEmployeeName(entity.getEmployeeName());
        vo.setBillDate(entity.getBillDate());
        this.updateBillStatus(vo, true);
        return id;
    }

    @Override
    public String updateBillStatus(MatSupplierChangeVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(MatSupplierChangeVO vo, Boolean saveFlag) {
        MatSupplierChangeEntity entity = super.selectById(vo.getId());
        // 自制变更无需更新状态及生成流水
        if(PlanConstant.SOURCE_TYPE_EL.equals(Integer.valueOf(entity.getSourceType()))){
            return null;
        }
        // 校验业务状态
        pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        // 供方推送无需推送供方
        if(!saveFlag){
            pushSupUtil.updateBillStatus((JSONObject) JSONObject.toJSON(entity), "status", SYSTEM_ID,
                    BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        super.saveOrUpdate(entity);
        if(saveFlag){
            // 供方推送过来的数据操作人为供方登录人，生成流水
            MatSupplierChangeFlowEntity flow = new MatSupplierChangeFlowEntity();
            flow.setChangeId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getEmployeeId());
            flow.setOperatorName(vo.getEmployeeName());
            flow.setOperateTime(vo.getBillDate());
            flowService.saveOrUpdate(flow, false);
        } else {
            // 生成流水
            MatSupplierChangeFlowVO flow = new MatSupplierChangeFlowVO();
            flow.setChangeId(entity.getId());
            // 更新状态flowType必传，否则流转状态有可能不对应
            flow.setFlowType(StringUtils.isNotEmpty(vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            flowService.saveOrUpdate(flow);
        }
        return null;
    }

    @Override
    public JSONObject contrast(Long changeId) {
        MatSupplierChangeEntity entity = super.selectById(changeId);
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter(QueryParam.EQ, changeId));
        List<MatSupplierHistoryEntity> list = historyService.queryList(param);
        MatSupplierHistoryEntity history = historyService.selectById(list.get(0).getId());
        JSONObject json = new JSONObject();
        json.put("change", BeanMapper.map(entity, MatSupplierChangeVO.class));
        json.put("source", BeanMapper.map(history, MatSupplierHistoryVO.class));
        return json;
    }

    @Override
    public Boolean pushToHistory(Long supplierId, Long changeId) {
        MatSupplierEntity supplier = supplierService.selectById(supplierId);
        // 初始化数据，包含子表
        MatSupplierHistoryVO save = EntityUtil.clearInvalidEntity(supplier, MatSupplierHistoryVO.class);
        save.setSupplierId(supplier.getId());
        save.setChangeId(changeId);
        MatSupplierHistoryVO history = historyService.saveOrUpdate(save);

        // 附件处理
        attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(supplier.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
                String.valueOf(history.getId()), historyBillType, PlanConstant.BILL_SOURCE_TYPE);

        Map<Long, MatSupplierHistoryAttachesVO> attachMap = history.getAttachesList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
        for(MatSupplierAttachesEntity source : supplier.getAttachesList()){
            if(attachMap.containsKey(source.getId())){
                MatSupplierHistoryAttachesVO target = attachMap.get(source.getId());
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
                        String.valueOf(target.getId()), historyBillType, PlanConstant.FILE_SOURCE_TYPE);
            }
        }
        return true;
    }

    @Override
    public JSONArray getApprUserList(Long changeId) {
        JSONArray resp = new JSONArray();
        List<MatSupplierChangeMaterialInfoEntity> msList = matSupplierChangeMaterialInfoService.getAllByChangeId(changeId);

        List<Long> categoryIds = msList.stream().map(MatSupplierChangeMaterialInfoEntity::getMaterialId).collect(Collectors.toList());

        if(CollectionUtils.isEmpty(categoryIds)) {
            throw new BusinessException("操作失败，供应商下供货内容的物资分类为空，无法获取到对应审核人信息！");
        }
        CommonResponse<List<MatSupplierManagerVO>> settingResp = izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
        if(!settingResp.isSuccess()) {
            logger.error("根据物料分类ids-{}获取对应审核人信息失败，{}", categoryIds, JSONObject.toJSONString(settingResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("获取供应商审核人信息失败！");
        }

        List<MatSupplierManagerVO> settingList = settingResp.getData();
        if(CollectionUtils.isNotEmpty(settingList)) {
            for(MatSupplierManagerVO m : settingList) {
                JSONObject obj = new JSONObject();
                obj.put("userId", m.getManagerId());
                obj.put("userName", m.getManagerName());
                resp.add(obj);
            }
        }
        return resp;
    }
}
