package com.ejianc.business.zdssupplier.material.service.impl;

import com.ejianc.business.zdssupplier.material.bean.MatSupplierHistoryEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierHistoryMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierHistoryService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 物资供应商历史
 * 
 * @author generator
 * 
 */
@Service("matSupplierHistoryService")
public class MatSupplierHistoryServiceImpl extends BaseServiceImpl<MatSupplierHistoryMapper, MatSupplierHistoryEntity> implements IMatSupplierHistoryService {

    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_HISTORY";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public MatSupplierHistoryVO saveOrUpdate(MatSupplierHistoryVO saveOrUpdateVO) {
        MatSupplierHistoryEntity entity = BeanMapper.map(saveOrUpdateVO, MatSupplierHistoryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        MatSupplierHistoryVO vo = BeanMapper.map(entity, MatSupplierHistoryVO.class);
        return vo;
    }
}
