package com.ejianc.business.zdssupplier.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.material.mapper.MatSupplierMaterialInfoMapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierMaterialInfoService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资供应商档案-供货信息
 * 
 * @author generator
 * 
 */
@Service("matSupplierMaterialInfoService")
public class MatSupplierMaterialInfoServiceImpl extends BaseServiceImpl<MatSupplierMaterialInfoMapper, MatSupplierMaterialInfoEntity> implements IMatSupplierMaterialInfoService{

    @Override
    public List<Long> getAllSupIdsByCategoryIds(List<Long> categoryIds) {
        List<Long> resp = new ArrayList<>();
        QueryWrapper<MatSupplierMaterialInfoEntity> query = new QueryWrapper<>();
        query.in("material_id", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MatSupplierMaterialInfoEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            resp = new ArrayList<>(list.stream().map(MatSupplierMaterialInfoEntity::getSupplierId).collect(Collectors.toSet()));
        }

        return resp;
    }

    @Override
    public List<MatSupplierMaterialInfoEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<MatSupplierMaterialInfoEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
