package com.ejianc.business.zdssupplier.sub.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包供应商档案
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_sub")
public class SupplierEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="access_id")
    private Long accessId; // 供应商准入Id
    @TableField(value="code")
    private String code; // 供应商编码
    @TableField(value="name")
    private String name; // 供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="tax_credit_level")
    private String taxCreditLevel; // 纳税信用等级:A,B,C,D,M
    @TableField(value="company_type")
    private String companyType; // 公司类型
    @TableField(value="legal_person")
    private String legalPerson; // 法人
    @TableField(value="business_status")
    private String businessStatus; // 经营状态
    @TableField(value="registered_capital_str")
    private String registeredCapitalStr; // 注册资本
    @TableField(value="paid_capital_str")
    private String paidCapitalStr; // 实缴金额
    @TableField(value="registered_address")
    private String registeredAddress; // 注册地址
    @TableField(value="business_start_date")
    private Date businessStartDate; // 经营起始日期
    @TableField(value="business_end_date")
    private Date businessEndDate; // 经营终止日期
    @TableField(value="labor_serv_nums")
    private Integer laborServNums; // 劳务人数总量
    @TableField(value="max_contract_on_time_mny")
    private BigDecimal maxContractOnTimeMny; // 同时承接最大合同额(万)'
    @TableField(value="max_contract_on_year_mny")
    private BigDecimal maxContractOnYearMny; // 年度最大承接合同额(万)
    @TableField(value="business_scope")
    private String businessScope; // 经营范围
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "corp_sid")
    private String corpSid; //归属部门Sid
    @TableField(value = "corp_erp_name")
    private String corpErpName;// 归属部门ERP名称
    @TableField(value="corp_id")
    private Long corpId; // 归属部门id
    @TableField(value="corp_code")
    private String corpCode; // 归属部门编码
    @TableField(value="corp_name")
    private String corpName; // 归属部门名称
    @TableField(value="type")
    private String type; // 信息来源 1-正常开发、2-甲方指定、3-甲方推荐、4-政府指定、5-政府推荐
    @TableField(value = "erp_type")
    private String erpType; //ERP中信息来源：0-业务单元，1-供应链管理中心，2-外部注册，3-正常开发，4-甲方指定，5甲方推荐，6-政府指定，7-政府推荐，8-厂家指定代理商，9-上包品牌内引入
    @TableField(value="intent_sid")
    private String intentSid; // 意向区域sid
    @TableField(value="intent_id")
    private String intentId; // 意向区域id
    @TableField(value="intent_name")
    private String intentName; // 意向区域名称
    @TableField(value="profession_sid")
    private String professionSid; // 主导专业Sid
    @TableField(value="profession_id")
    private String professionId; // 主导专业id
    @TableField(value="profession_name")
    private String professionName; // 主导专业名称

    @TableField(value = "dep_profession_sid")
    private String depProfessionSid;//发展专业sid
    @TableField(value = "dep_profession_name")
    private String depProfessionName; //发展专业名称
    @TableField(value = "dep_profession_id")
    private String depProfessionId; //发展专业id

    @TableField(value="group_train")
    private String groupTrain; // 执行总部培养
    @TableField(value="disposable_state")
    private Integer disposableState; // 是否一次性使用：0-否，1-是
    @TableField(value="disposable_reason")
    private String disposableReason; // 一次性使用原因
    @TableField(value="company_grade")
    private String companyGrade; // 公司等级
    @TableField(value="company_state")
    private String companyState; // 公司状态
    @TableField(value="affiliated_company")
    private String affiliatedCompany; // 关联公司
    @TableField(value="affiliated_company_name")
    private String affiliatedCompanyName; //关联公司名称
    @TableField(value = "affiliated_company_sid")
    private String affiliatedCompanySid;//关联公司SID
    @TableField(value="seal_state")
    private String sealState; // 是否电签 0-否，1-是
    @TableField(value="source_id")
    private Long sourceId; // 来源Id
    @TableField(value="source_type")
    private String sourceType; // 来源类型：1-项目，2-供应商
    @TableField(value="system_id")
    private String systemId; // 系统Id
    @TableField(value="tenant_name")
    private String tenantName; // 协同租户名称
    @TableField(value="tenant")
    private Long tenant; // 协同租户Id
    @TableField(value="coordination")
    private String coordination; // 是否已生成供方租户：0-否，1-是
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="third_source_id")
    private String thirdSourceId; // 第三方来源Id
    @TableField(value="major_id")
    private Long majorId; // 主导专业id
    @TableField(value="major_name")
    private String majorName; // 主导专业名称
    @TableField(value="type_label")
    private String typeLabel; // 类型标签
    @TableField(value="invoke_date")
    private Date invokeDate; // 调用企查查日期

    @TableField(value = "major_sid")
    private String majorSid; //主导专业SID

    @TableField(value = "sys_last_upd")
    private String sysLastUpd; //ERP最后更新时间

    @TableField(value = "erp_creator_sid")
    private String erpCreatorSid; //ERP创建人SID

    @TableField(value = "erp_register_name")
    private String erpRegisterName;//ERP录入人名称

    @TableField(exist=false)
    @SubEntity(serviceName="linkerService", pidName = "supplierId")//此处有pid="xxx"，默认值pid="pid"
    private List<LinkerEntity> linkerList = new ArrayList<>(); // 分包供应商档案-联系人信息
    @TableField(exist=false)
    @SubEntity(serviceName="supplierManagerService", pidName = "supplierId")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplierManagerEntity> managerList = new ArrayList<>(); // 分包供应商档案-项目经理
    @TableField(exist=false)
    @SubEntity(serviceName="supplierBankService", pidName = "supplierId")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplierBankEntity> bankList = new ArrayList<>(); // 分包供应商档案-银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="supplierCertificateService", pidName = "supplierId")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplierCertificateEntity> certificateList = new ArrayList<>(); // 分包供应商档案-资质信息
    @TableField(exist=false)
    @SubEntity(serviceName="supplierAttachesService", pidName = "supplierId")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplierAttachesEntity> attachesList = new ArrayList<>(); // 分包供应商档案-附件信息

    public String getErpRegisterName() {
        return erpRegisterName;
    }

    public void setErpRegisterName(String erpRegisterName) {
        this.erpRegisterName = erpRegisterName;
    }

    public String getErpType() {
        return erpType;
    }

    public void setErpType(String erpType) {
        this.erpType = erpType;
    }

    public String getCorpErpName() {
        return corpErpName;
    }

    public void setCorpErpName(String corpErpName) {
        this.corpErpName = corpErpName;
    }

    public String getDepProfessionSid() {
        return depProfessionSid;
    }

    public void setDepProfessionSid(String depProfessionSid) {
        this.depProfessionSid = depProfessionSid;
    }

    public String getDepProfessionName() {
        return depProfessionName;
    }

    public void setDepProfessionName(String depProfessionName) {
        this.depProfessionName = depProfessionName;
    }

    public String getDepProfessionId() {
        return depProfessionId;
    }

    public void setDepProfessionId(String depProfessionId) {
        this.depProfessionId = depProfessionId;
    }

    public String getErpCreatorSid() {
        return erpCreatorSid;
    }

    public void setErpCreatorSid(String erpCreatorSid) {
        this.erpCreatorSid = erpCreatorSid;
    }

    public String getSysLastUpd() {
        return sysLastUpd;
    }

    public void setSysLastUpd(String sysLastUpd) {
        this.sysLastUpd = sysLastUpd;
    }

    public String getAffiliatedCompanyName() {
        return affiliatedCompanyName;
    }

    public void setAffiliatedCompanyName(String affiliatedCompanyName) {
        this.affiliatedCompanyName = affiliatedCompanyName;
    }

    public String getProfessionSid() {
        return professionSid;
    }

    public void setProfessionSid(String professionSid) {
        this.professionSid = professionSid;
    }

    public String getIntentSid() {
        return intentSid;
    }

    public void setIntentSid(String intentSid) {
        this.intentSid = intentSid;
    }

    public String getAffiliatedCompanySid() {
        return affiliatedCompanySid;
    }

    public void setAffiliatedCompanySid(String affiliatedCompanySid) {
        this.affiliatedCompanySid = affiliatedCompanySid;
    }

    public String getCorpSid() {
        return corpSid;
    }

    public void setCorpSid(String corpSid) {
        this.corpSid = corpSid;
    }

    public String getMajorSid() {
        return majorSid;
    }

    public void setMajorSid(String majorSid) {
        this.majorSid = majorSid;
    }

    public Long getAccessId() {
        return accessId;
    }

    public void setAccessId(Long accessId) {
        this.accessId = accessId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getTaxCreditLevel() {
        return taxCreditLevel;
    }

    public void setTaxCreditLevel(String taxCreditLevel) {
        this.taxCreditLevel = taxCreditLevel;
    }
    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }
    public String getRegisteredCapitalStr() {
        return registeredCapitalStr;
    }

    public void setRegisteredCapitalStr(String registeredCapitalStr) {
        this.registeredCapitalStr = registeredCapitalStr;
    }
    public String getPaidCapitalStr() {
        return paidCapitalStr;
    }

    public void setPaidCapitalStr(String paidCapitalStr) {
        this.paidCapitalStr = paidCapitalStr;
    }
    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }
    public Date getBusinessStartDate() {
        return businessStartDate;
    }

    public void setBusinessStartDate(Date businessStartDate) {
        this.businessStartDate = businessStartDate;
    }
    public Date getBusinessEndDate() {
        return businessEndDate;
    }

    public void setBusinessEndDate(Date businessEndDate) {
        this.businessEndDate = businessEndDate;
    }
    public Integer getLaborServNums() {
        return laborServNums;
    }

    public void setLaborServNums(Integer laborServNums) {
        this.laborServNums = laborServNums;
    }
    public BigDecimal getMaxContractOnTimeMny() {
        return maxContractOnTimeMny;
    }

    public void setMaxContractOnTimeMny(BigDecimal maxContractOnTimeMny) {
        this.maxContractOnTimeMny = maxContractOnTimeMny;
    }
    public BigDecimal getMaxContractOnYearMny() {
        return maxContractOnYearMny;
    }

    public void setMaxContractOnYearMny(BigDecimal maxContractOnYearMny) {
        this.maxContractOnYearMny = maxContractOnYearMny;
    }
    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getIntentId() {
        return intentId;
    }

    public void setIntentId(String intentId) {
        this.intentId = intentId;
    }
    public String getIntentName() {
        return intentName;
    }

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }
    public String getProfessionId() {
        return professionId;
    }

    public void setProfessionId(String professionId) {
        this.professionId = professionId;
    }
    public String getProfessionName() {
        return professionName;
    }

    public void setProfessionName(String professionName) {
        this.professionName = professionName;
    }
    public String getGroupTrain() {
        return groupTrain;
    }

    public void setGroupTrain(String groupTrain) {
        this.groupTrain = groupTrain;
    }
    public Integer getDisposableState() {
        return disposableState;
    }

    public void setDisposableState(Integer disposableState) {
        this.disposableState = disposableState;
    }
    public String getDisposableReason() {
        return disposableReason;
    }

    public void setDisposableReason(String disposableReason) {
        this.disposableReason = disposableReason;
    }
    public String getCompanyGrade() {
        return companyGrade;
    }

    public void setCompanyGrade(String companyGrade) {
        this.companyGrade = companyGrade;
    }
    public String getCompanyState() {
        return companyState;
    }

    public void setCompanyState(String companyState) {
        this.companyState = companyState;
    }
    public String getAffiliatedCompany() {
        return affiliatedCompany;
    }

    public void setAffiliatedCompany(String affiliatedCompany) {
        this.affiliatedCompany = affiliatedCompany;
    }
    public String getSealState() {
        return sealState;
    }

    public void setSealState(String sealState) {
        this.sealState = sealState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }
    public Long getTenant() {
        return tenant;
    }

    public void setTenant(Long tenant) {
        this.tenant = tenant;
    }
    public String getCoordination() {
        return coordination;
    }

    public void setCoordination(String coordination) {
        this.coordination = coordination;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getThirdSourceId() {
        return thirdSourceId;
    }

    public void setThirdSourceId(String thirdSourceId) {
        this.thirdSourceId = thirdSourceId;
    }
    public Long getMajorId() {
        return majorId;
    }

    public void setMajorId(Long majorId) {
        this.majorId = majorId;
    }
    public String getMajorName() {
        return majorName;
    }

    public void setMajorName(String majorName) {
        this.majorName = majorName;
    }
    public String getTypeLabel() {
        return typeLabel;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }
    public Date getInvokeDate() {
        return invokeDate;
    }

    public void setInvokeDate(Date invokeDate) {
        this.invokeDate = invokeDate;
    }

    public List<LinkerEntity> getLinkerList() {
        return linkerList;
    }

    public void setLinkerList(List<LinkerEntity> linkerList) {
        this.linkerList = linkerList;
    }

    public List<SupplierManagerEntity> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<SupplierManagerEntity> managerList) {
        this.managerList = managerList;
    }

    public List<SupplierBankEntity> getBankList() {
        return bankList;
    }

    public void setBankList(List<SupplierBankEntity> bankList) {
        this.bankList = bankList;
    }

    public List<SupplierCertificateEntity> getCertificateList() {
        return certificateList;
    }

    public void setCertificateList(List<SupplierCertificateEntity> certificateList) {
        this.certificateList = certificateList;
    }

    public List<SupplierAttachesEntity> getAttachesList() {
        return attachesList;
    }

    public void setAttachesList(List<SupplierAttachesEntity> attachesList) {
        this.attachesList = attachesList;
    }
}
