package com.ejianc.business.zdssupplier.sub.controller;

import java.io.Serializable;

import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.service.impl.LinkerAccessBpmServiceImpl;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerAccessVO;

/**
 * 分包联系人准入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("linkerAccess")
public class LinkerAccessController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_LINKER_ACCESS";//此处需要根据实际修改

    @Autowired
    private ILinkerAccessService service;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LinkerAccessVO> saveOrUpdate(@RequestBody LinkerAccessVO saveOrUpdateVO) {
    	LinkerAccessVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerAccessVO> queryDetail(Long id) {
    	LinkerAccessEntity entity = service.selectById(id);
    	LinkerAccessVO vo = BeanMapper.map(entity, LinkerAccessVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LinkerAccessVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LinkerAccessVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(LinkerAccessVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LinkerAccessVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("name");
        fuzzyFields.add("inviterName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LinkerAccessEntity> page = service.queryPage(param,false);
        IPage<LinkerAccessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LinkerAccessVO> records = BeanMapper.mapList(page.getRecords(), LinkerAccessVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            // 查询分包商档案信息
            List<Long> ids = records.stream().map(LinkerAccessVO::getSupplierId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<SupplierEntity> list = supplierService.queryList(queryParam);
            Map<Long, SupplierEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x, (v1, v2)->v2));
            for(LinkerAccessVO vo : records){
                if(map.containsKey(vo.getSupplierId())){
                    SupplierEntity entity = map.get(vo.getSupplierId());
                    vo.setSocialCreditCode(entity.getSocialCreditCode());
                    vo.setLegalPerson(entity.getLegalPerson());
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LinkerAccessEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LinkerAccess-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLinkerAccessData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LinkerAccessVO>> refLinkerAccessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LinkerAccessEntity> page = service.queryPage(param,false);
        IPage<LinkerAccessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LinkerAccessVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 保存同步单据
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveSyncBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveSyncBill(request));
    }

    /**
     * @Description syncDetailBill 根据邀请链接重新拉取分供方准入信息
     * @param inviteId
     */
    @RequestMapping(value = "/syncDetailBill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerAccessVO> syncDetailBill(Long inviteId) {
        LinkerAccessVO vo = service.syncDetailBill(inviteId);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @Autowired
    private LinkerAccessBpmServiceImpl bpmService;

    /**
     * 审批后事件
     * @param id
     * @return
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String > test(@RequestParam Long id) {
        CommonResponse<String> response = bpmService.afterApprovalProcessor(id, null, null);
        LinkerAccessEntity entity = service.selectById(id);
        entity.setBillState(1);
        service.updateById(entity);
        return response;
    }
}
