package com.ejianc.business.zdssupplier.sub.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerChangeService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包联系人变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("linkerChange")
public class LinkerChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_LINKER_CHANGE";//此处需要根据实际修改

    @Autowired
    private ILinkerChangeService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private ILinkerService linkerService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LinkerChangeVO> saveOrUpdate(@RequestBody LinkerChangeVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerChangeVO> queryDetail(Long id) {
        LinkerChangeVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LinkerChangeVO> vos) {
        List<Long> linkerId = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (LinkerChangeVO vo : vos) {
                LinkerChangeEntity linkerChangeEntity = service.selectById(vo.getId());
                if (linkerChangeEntity.getSourceType().equals("1")||SupLinkerEnum.已驳回供方.getCode().equals(linkerChangeEntity.getReceiveStatus())){
                    linkerId.add(linkerChangeEntity.getLinkerId());
                }else{
                    throw new BusinessException("只有已驳回供方的变更单才可以删除！");
                }

            }
        }
        if (CollectionUtil.isNotEmpty(linkerId)){
            linkerService.deleteChange(linkerId);

        }
        service.removeByIds(vos.stream().map(LinkerChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LinkerChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("name");
        fuzzyFields.add("userName");
        fuzzyFields.add("linkPhone");
        fuzzyFields.add("idCardId");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<LinkerChangeEntity> page = service.queryPage(param,false);
        IPage<LinkerChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LinkerChangeVO> linkerChangeVOS = BeanMapper.mapList(page.getRecords(), LinkerChangeVO.class);
        linkerChangeVOS.stream().forEach(vo -> {
            if (vo.getReceiveStatus()!=null){
                switch (vo.getReceiveStatus()){
                    case 0:
                        vo.setReceiveStatusStr("待提交");
                        break;
                    case 1:
                        vo.setReceiveStatusStr("待审核");
                        break;
                    case 2:
                        vo.setReceiveStatusStr("已审核");
                        break;
                    case 3:
                        vo.setReceiveStatusStr("已驳回");
                        break;
                    case 4:
                        vo.setReceiveStatusStr("审核中");
                        break;
                }
            }else{
                vo.setReceiveStatusStr("待提交");
            }
            vo.setBillStateStr(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        pageData.setRecords(linkerChangeVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<LinkerChangeVO>> iPageCommonResponse = queryList(param);
        List<LinkerChangeVO> records = new ArrayList<>();
        if (iPageCommonResponse.isSuccess()){
            IPage<LinkerChangeVO> pageData = iPageCommonResponse.getData();
            records =pageData.getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("LinkerChange-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/addConvertById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerChangeVO> addConvertById(Long linkerId) {
        LinkerChangeVO vo = service.addConvertById(linkerId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    @RequestMapping(value = "/contrast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long linkerId,Long changeId,String flagType) {
        JSONObject contrast = service.contrast(linkerId,changeId,flagType);
        return CommonResponse.success("新增转换数据成功！",contrast);
    }

    @PostMapping(value = "syncBill")
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return service.syncBill(request);
    }

    @RequestMapping(value = "/pushStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LinkerChangeVO> pushStatus(Long id) {
        return  service.pushStatus(id);
    }
}
