package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.teautil.Common;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包分包商档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplier")
public class SupplierController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO saveOrUpdateVO) {
    	SupplierVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(Long id) {
    	SupplierEntity entity = service.selectById(id);
    	SupplierVO vo = BeanMapper.map(entity, SupplierVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SupplierVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SupplierVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SupplierEntity> page = service.queryPage(param,false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SupplierEntity> list = service.queryList(param);
        List<SupplierVO> rerords = BeanMapper.mapList(list, SupplierVO.class);
        rerords.forEach(vo->{
            vo.setType(PlanConstant.SUPPLIER_TYPE.get(vo.getType()));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", rerords);
        ExcelExport.getInstance().export("Supplier-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<SupplierEntity> page = service.queryPage(param,false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @PostMapping(value = "/syncToErp")
    @ResponseBody
    public CommonResponse<String> syncToErp(@RequestBody SupplierSyncErpParamVO paramVO) {
        UserContext user = sessionManager.getUserContext();
        paramVO.setOperatorId(user.getUserId());
        paramVO.setOperatorName(user.getUserName());

        String msg = service.syncSupplierChangeToErp(paramVO);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("供应商任务执行成功！");
    }

    /**
     * 供方查询详情
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryDetailBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierEntity> queryDetailBill(HttpServletRequest request){
        return service.queryDetailBill(request);
    }

    @PostMapping(value = "/syncSupplierErpSid")
    @ResponseBody
    public CommonResponse<String> syncSupplierErpSid(@RequestBody Long supplierId) {
        service.syncSupplierErpSid(supplierId);
        return CommonResponse.success("更新成功！");
    }

    @GetMapping(value = "/getSupErpInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getSupErpInfo(@RequestParam Long supplierId) {
        return CommonResponse.success( "查询成功！", service.getSupErpInfo(supplierId));
    }
}
