package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.service.*;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/12 15:30
 */
@RestController
@RequestMapping(value = "/zdsSubSupSync")
public class ZdsSubSupSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierService service;

    private final static String ERP_SUB_SUPPLIER_UPDATE_URL = "/cefoc/yql/SubContractorList";

    @Autowired
    private ILinkerService linkerService;

    @Autowired
    private ISupplierAttachesService attachesService;

    @Autowired
    private ISupplierBankService supplierBankService;

    @Autowired
    private IBankService bankService;

    @Autowired
    private ISupplierManagerService managerService;

    @Autowired
    private ISupplierCertificateService certificateService;

    @Autowired
    private IAdministrativeAreaService areaService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IZDSSubTypeApi subTypeApi;

    @Autowired
    private IBankCategoryService bankCategoryService;

    /**
     * 中电四物资分包商同步
     *
     * @param params
     * @return
     */
    @PostMapping(value = "/syncZdsSubSupplier")
    @ResponseBody
    public CommonResponse<String> syncZdsMatSupplier(@RequestBody JSONObject params) {
        logger.info("*********************中电四-分包分包商信息同步任务 开始*********************");
        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL;
        JSONObject reqJson = null;
        JSONArray pageData = null;

        String reqDateStr = null;
        if(null == params.get("beginDate") || null == params.get("endDate")) {
            if(!"all".equals(params.getString("range"))) {
                reqDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1));
                param.put("BeginDateTime", reqDateStr + " 00:00:00");
                param.put("EndDateTime", reqDateStr + " 23:59:59");
            }
        } else {
            param.put("BeginDateTime", params.getString("beginDate"));
            param.put("EndDateTime", params.getString("endDate"));
        }
        if(null != params.get("supplierSid")) {
            reqUrl = reqUrl + "?OID=" + params.getString("supplierSid");
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }
        //ERP接口需传递分页参数  但ERP又不根据其过滤 故写死
        param.put("PageSize", 100);
        param.put("PageNum", 1);
        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
//                logger.info("请求中电四获取分包分包商结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                handleErpPage(reqJson);
            } else {
                logger.error("请求中电四获取分包分包商结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四分包分包商信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四分包分包商信息异常");
        }

        logger.info("*********************中电四-分包分包商信息同步任务 结束*********************");
        return CommonResponse.success("分包分包商同步任务执行成功！");
    }

//    public static void main(String[] args) throws Exception {
//        String reqUrl = "http://192.168.211.24" + ERP_SUB_SUPPLIER_UPDATE_URL;
//        Map<String, Object> param = new HashMap<>();
//        Map<String, String> headers = ZDSReqUtil.getErpHeader("b6a70a2af8ea494fbda7c9ae118500ea", "11658934fd26400985e1e9d83f6ac7cf");
//        param.put("PageSize", 100);
//        param.put("PageNum", 1);
//
//        String startDateStr = "2022-09-01";
//        boolean hasNext = true;
//        long today = new Date().getTime();
//                Date start = null;
//        Date end = null;
//        while (hasNext) {
//            if(null == start) {
//                start = DateFormatUtil.parseDate("yyyy-MM-dd", startDateStr);
//            } else {
//                start = DateUtils.addDays(end, 1);
//            }
//
//            if(start.getTime() > today) {
//                return;
//            }
//
//            end = DateUtils.addDays(start, 29);
//            if(end.getTime() > today) {
//                end = DateFormatUtil.parseDate("yyyy-MM-dd", "2024-06-19");
//                hasNext = false;
//            }
//
//            String startStr = DateFormatUtil.formatDate("yyyy-MM-dd", start);
//            String endStr = DateFormatUtil.formatDate("yyyy-MM-dd", end);
//
//            param.put("startDate", startStr + " 00:00:00");
//            param.put("endDate", endStr + " 23:59:59");
//
//            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
//                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);
//            JSONObject reqJson = JSONObject.parseObject(reqResp);
//
//            JSONArray supplierArr = reqJson.getJSONArray("SubContractorInfo");
//            JSONObject tmp = null;
//            System.out.println("size :" + supplierArr.size());
//            if(null == supplierArr || supplierArr.size() == 0) {
//                hasNext = false;
//            }
//            for(Object obj : supplierArr) {
//                tmp = (JSONObject) obj;
//                if("茂盛建设工程科技（大连）有限公司".equals(tmp.getString("Company_Name"))) {
//                    System.out.println("****************************************");
//                    System.out.println("****************************************");
//                    System.out.println(tmp.getString("Company_Name"));
//                    System.out.println(tmp.getString("SYS_LAST_UPD"));
//                    System.out.println("****************************************");
//                    System.out.println("****************************************");
//                    hasNext = false;
//                    return;
//                }
//            }
//        }
//
//
//
//    }

    @Transactional(rollbackFor = Exception.class)
    public void handleErpPage(JSONObject dataJson) {
        List<SupplierEntity> supList = new ArrayList<>();
        List<LinkerEntity> linkerList = new ArrayList<>();
        List<SupplierBankEntity> bankList = new ArrayList<>();
        List<SupplierAttachesEntity> attachList = new ArrayList<>();
        List<SupplierManagerEntity> managerList = new ArrayList<>();
        List<SupplierCertificateEntity> certList = new ArrayList<>();
        Set<String> areaSids = new HashSet<>();
        Set<String> copSIds = new HashSet<>();
        Set<String> subTypeSIds = new HashSet<>();

        List<String> tmpIds = new ArrayList<>();
        List<String> tmpSIds = new ArrayList<>();
        List<String> intenatNames = new ArrayList<>();
        List<String> subTypeNames = new ArrayList<>();
        List<String> subTypeIds = new ArrayList<>();

        SupplierEntity tmpSupEntity = null;
        JSONObject tmpSupJson = null;

        Map<String, SupplierEntity> mapSourceMap = new HashMap<>();
        Map<String, List<LinkerEntity>> linkerMap = new HashMap<>();
        Map<Long, List<LinkerEntity>> dbLinkerMap = new HashMap<>();
        Map<String, List<SupplierBankEntity>> bankMap = new HashMap<>();
        Map<Long, List<SupplierBankEntity>> dbBankMap = new HashMap<>();
        Map<String, List<SupplierAttachesEntity>> attachMap = new HashMap<>();
        Map<Long, List<SupplierAttachesEntity>> dbAttachMap = new HashMap<>();
        Map<String, List<SupplierManagerEntity>> managerMap = new HashMap<>();
        Map<Long, List<SupplierManagerEntity>> dbManagerMap = new HashMap<>();
        Map<String, List<SupplierCertificateEntity>> certMap = new HashMap<>();
        Map<Long, List<SupplierCertificateEntity>> dbCertMap = new HashMap<>();
        Map<String, AdministrativeAreaEntity> areaMap = new HashMap<>();
        Map<String, OrgVO> orgMap = new HashMap<>();
        Map<String, SubTypeVO> subTypeMap = new HashMap<>();

        JSONArray supplierArr = dataJson.getJSONArray("SubContractorInfo");
        logger.info("本次待处理分包商数据：{}条", supplierArr.size());
        if(supplierArr.size() == 0) {
            logger.info("待处理分包商数据为空，任务执行结束。。。。");
            return;
        }
        for(Object obj : supplierArr) {
            tmpSupJson = (JSONObject) obj;
            tmpSupEntity = new SupplierEntity();
            tmpSupEntity.setThirdSourceId(tmpSupJson.getString("C_PS_SubContractorInfoOID")); //ERP主键
            if(null != tmpSupJson.get("YQL_SID") && StringUtils.isNotBlank(tmpSupJson.getString("YQL_SID"))) { //EL平台主键
                tmpSupEntity.setId(Long.valueOf(tmpSupJson.getString("YQL_SID")));
            }
            tmpSupEntity.setMemo(tmpSupJson.getString("Memo")); //备注
            tmpSupEntity.setName(tmpSupJson.getString("Company_Name")); //分包商名称
            tmpSupEntity.setLegalPerson(tmpSupJson.getString("Company_LegalPerson"));//法人
            tmpSupEntity.setCompanyType(ErpCompanyTypeEnums.getByCode(tmpSupJson.getString("CompanyStyle"))); //公司类型
            tmpSupEntity.setRegisteredCapitalStr(tmpSupJson.getString("RegistrationCapital")); //注册资本
            tmpSupEntity.setPaidCapitalStr(tmpSupJson.getString("Paidincapital")); //实缴资本
            tmpSupEntity.setBusinessStatus(tmpSupJson.getString("regStatus")); //经营状态
            tmpSupEntity.setSysLastUpd(tmpSupJson.getString("SYS_LAST_UPD"));
            tmpSupEntity.setErpCreatorSid(tmpSupJson.getString("SYS_CreatedBy")); //创建人SID
            tmpSupEntity.setErpRegisterName(tmpSupJson.getString("Register_Name")); //创建人名称
            try {
                if(null != tmpSupJson.get("OperatingPeriodStart") && StringUtils.isNotBlank(tmpSupJson.getString("OperatingPeriodStart"))) {
                    tmpSupEntity.setBusinessStartDate(DateFormatUtil.parseDate("yyyy-MM-dd", tmpSupJson.getString("OperatingPeriodStart").split("T")[0])); //经营开始时间
                }
                if(null != tmpSupJson.get("OperatingPeriodEnd") && StringUtils.isNotBlank(tmpSupJson.getString("OperatingPeriodEnd"))) {
                    tmpSupEntity.setBusinessEndDate(DateFormatUtil.parseDate("yyyy-MM-dd", tmpSupJson.getString("OperatingPeriodEnd").split("T")[0])); //经营结束时间
                }
            } catch (Exception e) {
                logger.error("分包商时间格式化异常：{}, ", tmpSupJson.toString(SerializerFeature.PrettyFormat), e);
            }
            tmpSupEntity.setRegisteredAddress(tmpSupJson.getString("Company_Address")); //注册地址
            tmpSupEntity.setSocialCreditCode(tmpSupJson.getString("RegistrationCode")); //统一社会信用代码
            tmpSupEntity.setBusinessScope(tmpSupJson.getString("OperatingRange")); //经营范围
            tmpSupEntity.setCode(tmpSupJson.getString("Ma_id")); //分包商编码
            tmpSupEntity.setTaxCreditLevel(ErpTaxCreditLevelEnum.getByCode(tmpSupJson.getString("Taxcreditrating"))); //纳税等级
            tmpSupEntity.setDisposableState(StringUtils.isNotBlank(tmpSupJson.getString("IsitaOneTimeUse")) ?
                    "true".equals(tmpSupJson.getString("IsitaOneTimeUse").toLowerCase()) ? 1 : 0 : null); //是否一次使用
            tmpSupEntity.setDisposableReason(tmpSupJson.getString("ReasonforOneTimeUse")); //一次性使用原因
            tmpSupEntity.setSealState(StringUtils.isNotBlank(tmpSupJson.getString("IsSupportES")) ?
                    "true".equals(tmpSupJson.getString("IsSupportES")) ? "1" : "0" : null); //是否支持电子签章
            tmpSupEntity.setCompanyGrade(tmpSupJson.getString("Company_Level")); //公司等级
            tmpSupEntity.setCoordination("0"); //默认未协同
            tmpSupEntity.setCompanyState(tmpSupJson.getString("CompanyStatus")); //公司状态
            tmpSupEntity.setMaxContractOnYearMny(null != tmpSupJson.get("AnnualMaxVertragsbetrag") ? tmpSupJson.getBigDecimal("AnnualMaxVertragsbetrag") : null); //年度最大承接合同额
            tmpSupEntity.setMaxContractOnTimeMny(null != tmpSupJson.get("MaxLimitConMoney") ? tmpSupJson.getBigDecimal("MaxLimitConMoney") : null); //同时最大承接合同额(万)
            tmpSupEntity.setGroupTrain(tmpSupJson.getString("ExecutiveHeadquartersTraining")); //执行总部培养
            tmpSupEntity.setProfessionSid(StringUtils.isNotBlank(tmpSupJson.getString("MainCompanyTypeSid")) ? tmpSupJson.getString("MainCompanyTypeSid").toLowerCase() : null); //主导专业ERPID
            tmpSupEntity.setProfessionName(tmpSupJson.getString("MainCompanyType")); //主导专业
            tmpSupEntity.setAffiliatedCompanySid(StringUtils.isNotBlank(tmpSupJson.getString("RelatedCompanySid")) ? tmpSupJson.getString("RelatedCompanySid").toLowerCase() : null); //关联公司SID
            tmpSupEntity.setAffiliatedCompanyName(StringUtils.isNotBlank(tmpSupJson.getString("RelatedCompany")) ? tmpSupJson.getString("RelatedCompany") : null); //关联公司
            tmpSupEntity.setTypeLabel(tmpSupJson.getString("TypeLabel")); //类型标签

            tmpSupEntity.setDepProfessionName(StringUtils.isNotBlank(tmpSupJson.getString("CompanyType")) ? tmpSupJson.getString("CompanyType").toLowerCase() : null); //发展专业名称
            tmpSupEntity.setDepProfessionSid(StringUtils.isNotBlank(tmpSupJson.getString("CompanyType_Sid")) ? tmpSupJson.getString("CompanyType_Sid").toLowerCase() : null); //发展专业名称

            //归属部门
            tmpSupEntity.setCorpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpErpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpSid(StringUtils.isNotBlank(tmpSupJson.getString("OwnerDeptSid")) ?tmpSupJson.getString("OwnerDeptSid").toLowerCase() : null);

            if(StringUtils.isNotBlank(tmpSupEntity.getCorpSid())) {
                copSIds.add(tmpSupEntity.getCorpSid());
            }

            //消息来源
            tmpSupEntity.setType(PlanConstant.ERP_SUB_INFO_TYPE_TO_EL_MAPPING.containsKey(tmpSupJson.getString("EntryDept")) ?
                    PlanConstant.ERP_SUB_INFO_TYPE_TO_EL_MAPPING.get(tmpSupJson.getString("EntryDept")) : "");
            tmpSupEntity.setErpType(tmpSupJson.getString("EntryDept"));
            //业务区域
            tmpSupEntity.setIntentId(null);
            tmpSupEntity.setIntentName(null);
            if(StringUtils.isNotBlank(tmpSupJson.getString("ServiceAreaSid"))) {
                tmpSupEntity.setIntentSid(tmpSupJson.getString("ServiceAreaSid").toLowerCase());
                if(StringUtils.isNotBlank(tmpSupJson.getString("ServiceArea"))) {
                    tmpSupEntity.setIntentName(tmpSupJson.getString("ServiceArea").replaceAll("\\|", ","));
                }

                if(tmpSupEntity.getIntentSid().endsWith(",")) {
                    tmpSupEntity.setIntentSid(tmpSupEntity.getIntentSid().substring(0, tmpSupEntity.getIntentSid().length()-1));
                }
                if(tmpSupEntity.getIntentSid().startsWith(",")) {
                    tmpSupEntity.setIntentSid(tmpSupEntity.getIntentSid().substring(1));
                }
                areaSids.addAll(Arrays.asList(tmpSupEntity.getIntentSid().split(",")));
            }
            //TODO 关联公司

            //劳务人数总量
            try {
                tmpSupEntity.setLaborServNums(StringUtils.isNotBlank(tmpSupJson.getString("TotalStaff")) ?
                        Integer.valueOf(tmpSupJson.getString("TotalStaff").replace("人", "")) : null);
            } catch (Exception e) {
                logger.error("格式化劳务人数总量:{} 异常：", tmpSupJson.get("TotalStaff"), e);
                tmpSupEntity.setLaborServNums(null);
            }

            if(null == tmpSupEntity.getId()) {
                tmpSupEntity.setId(IdWorker.getId());
            }
            if(StringUtils.isNotBlank(tmpSupEntity.getProfessionSid())) {
                subTypeSIds.addAll(Arrays.asList(tmpSupEntity.getProfessionSid().split(",")));
            }
            if(StringUtils.isNotBlank(tmpSupEntity.getDepProfessionSid())) {
                subTypeSIds.addAll(Arrays.asList(tmpSupEntity.getDepProfessionSid().split(",")));
            }

            mapSourceMap.put(tmpSupEntity.getThirdSourceId(), tmpSupEntity);
        }

        //查询行政地区信息
        if(CollectionUtils.isNotEmpty(areaSids)) {
            List<AdministrativeAreaEntity> dbAreas = areaService.getAllBySourceIds(new ArrayList<>(areaSids));
            if(CollectionUtils.isNotEmpty(dbAreas)) {
                for(AdministrativeAreaEntity area : dbAreas) {
                    areaMap.put(area.getSourceId(), area);
                }
            }
        }
        //查询归属部门
        if(CollectionUtils.isNotEmpty(copSIds)) {
            CommonResponse<List<OrgVO>> orgResp = orgApi.findAllBySourceIds(new ArrayList<>(copSIds));
            if(!orgResp.isSuccess()) {
                logger.error("根据组织SId-{}查询组织信息失败，{}", JSONObject.toJSONString(copSIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            }
            if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                orgMap.putAll(orgResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }

        //查询分包专业
        if(CollectionUtils.isNotEmpty(subTypeSIds)) {
            CommonResponse<List<SubTypeVO>> subTypeResp = subTypeApi.getAllBySourceIds(new ArrayList<>(subTypeSIds));
            if(!subTypeResp.isSuccess()) {
                logger.error("根据分包专业SId列表-{}查询分包类型失败, {}！", JSONObject.toJSONString(subTypeSIds), JSONObject.toJSONString(subTypeResp, SerializerFeature.PrettyFormat));
            }
            if(CollectionUtils.isNotEmpty(subTypeResp.getData())) {
                subTypeMap.putAll(subTypeResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }

        //分包商联系人
        if(null != dataJson.get("ContactList") && dataJson.getJSONArray("ContactList").size() > 0) {
            handleLinker(linkerMap, dataJson.getJSONArray("ContactList"));
        }

        //分包商附件信息
        if(null != dataJson.get("ArchivesList") && dataJson.getJSONArray("ArchivesList").size() > 0) {
            handleArchive(attachMap, dataJson.getJSONArray("ArchivesList"));
        }

        //分包商银行信息
        if(null != dataJson.get("BankList") && dataJson.getJSONArray("BankList").size() > 0) {
            handleBank(bankMap, dataJson.getJSONArray("BankList"));
        }
        //分包商项目经理信息
        if(null != dataJson.get("ProjectManagerList") && dataJson.getJSONArray("ProjectManagerList").size() > 0) {
            handleProjectManager(managerMap, dataJson.getJSONArray("ProjectManagerList"));
        }
        //分包商资质信息
        if(null != dataJson.get("QualificationInfoList") && dataJson.getJSONArray("QualificationInfoList").size() > 0) {
            handleQualification(certMap, dataJson.getJSONArray("QualificationInfoList"));
        }

        //判断数据库是否存在
        List<SupplierEntity> dbList = service.getAllByThirdSourceIds(new ArrayList(mapSourceMap.keySet()));

        if(CollectionUtils.isNotEmpty(dbList)) {
            List<Long> supplierIds = dbList.stream().map(SupplierEntity::getId).collect(Collectors.toList());
            List<LinkerEntity> linkers = linkerService.getAllBySupplierIds(supplierIds);
            dbLinkerMap.putAll(linkers.stream().collect(Collectors.groupingBy(LinkerEntity::getSupplierId)));

            //项目经理信息
            List<SupplierManagerEntity> dbManagerList = managerService.getAllBySupplierIds(supplierIds);
            dbManagerMap.putAll(dbManagerList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierManagerEntity::getSupplierId)));

            //资质信息
            List<SupplierCertificateEntity> dbCertList = certificateService.getAllBySupplierIds(supplierIds);
            dbCertMap.putAll(dbCertList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierCertificateEntity::getSupplierId)));

            //银行信息
            List<SupplierBankEntity> dbBankList = supplierBankService.getAllBySupplierIds(supplierIds);
            dbBankMap.putAll(dbBankList.stream().filter(item -> null != item.getBankThirdSourceId()).collect(Collectors.groupingBy(SupplierBankEntity::getSupplierId)));

            //附件信息
            List<SupplierAttachesEntity> dbAttachList = attachesService.getAllBySupplierIds(supplierIds);
            dbAttachMap.putAll(dbAttachList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierAttachesEntity::getSupplierId)));

            for(SupplierEntity dbSupplier : dbList) {
                tmpSupEntity = mapSourceMap.get(dbSupplier.getThirdSourceId());

                if(StringUtils.isNotBlank(tmpSupEntity.getIntentSid())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    intenatNames.clear();
                    Arrays.asList(tmpSupEntity.getIntentSid().split(",")).stream().forEach(item -> {
                        if(areaMap.containsKey(item)) {
                            tmpIds.add(areaMap.get(item).getId().toString());
                            tmpSIds.add(areaMap.get(item).getSourceId());
                            intenatNames.add(areaMap.get(item).getName());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(tmpIds)) {
                        tmpSupEntity.setIntentId(StringUtils.join(tmpIds, ","));
                        tmpSupEntity.setIntentSid(StringUtils.join(tmpSIds, ","));
                        tmpSupEntity.setIntentName(StringUtils.join(intenatNames, ","));
                    }
                }

                if(StringUtils.isNotBlank(tmpSupEntity.getCorpSid()) && orgMap.containsKey(tmpSupEntity.getCorpSid())) {
                    tmpSupEntity.setCorpId(orgMap.get(tmpSupEntity.getCorpSid()).getId());
                    tmpSupEntity.setCorpName(orgMap.get(tmpSupEntity.getCorpSid()).getName());
                    tmpSupEntity.setCorpCode(orgMap.get(tmpSupEntity.getCorpSid()).getCode());
                }
                //主导专业
                if(StringUtils.isNotBlank(tmpSupEntity.getProfessionSid())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getProfessionSid().split(",")).stream().forEach(item -> {
                        if(subTypeMap.containsKey(item)) {
                            subTypeNames.add(subTypeMap.get(item).getName());
                            subTypeIds.add(subTypeMap.get(item).getId().toString());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setProfessionId(StringUtils.join(subTypeIds, ","));
                        tmpSupEntity.setProfessionName(StringUtils.join(subTypeNames, ","));
                    }
                }
                //发展专业
                if(StringUtils.isNotBlank(tmpSupEntity.getDepProfessionSid())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getDepProfessionSid().split(",")).stream().forEach(item -> {
                        if(subTypeMap.containsKey(item)) {
                            subTypeNames.add(subTypeMap.get(item).getName());
                            subTypeIds.add(subTypeMap.get(item).getId().toString());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setDepProfessionId(StringUtils.join(subTypeIds, ","));
                        tmpSupEntity.setDepProfessionName(StringUtils.join(subTypeNames, ","));
                    }
                }

                //更新分包商基本信息
                if(StringUtils.isNotBlank(tmpSupEntity.getErpRegisterName()) && StringUtils.isBlank(dbSupplier.getErpRegisterName())) {
                    dbSupplier.setErpRegisterName(tmpSupEntity.getErpRegisterName());
                }
                if(null == dbSupplier.getBusinessEndDate() && null != tmpSupEntity.getBusinessEndDate()) {
                    dbSupplier.setBusinessEndDate(tmpSupEntity.getBusinessEndDate());
                }
                if(null == dbSupplier.getBusinessStartDate() && null != tmpSupEntity.getBusinessStartDate()) {
                    dbSupplier.setBusinessStartDate(tmpSupEntity.getBusinessStartDate());
                }
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason());
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade());
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState());
                dbSupplier.setType(tmpSupEntity.getType());
                dbSupplier.setCorpSid(tmpSupEntity.getCorpSid());
                dbSupplier.setCorpId(tmpSupEntity.getCorpId());
                dbSupplier.setCorpName(tmpSupEntity.getCorpName());
                dbSupplier.setCorpCode(tmpSupEntity.getCorpCode());
                dbSupplier.setCorpErpName(tmpSupEntity.getCorpErpName());
                dbSupplier.setErpType(tmpSupEntity.getErpType());
//                dbSupplier.setProfessionId(tmpSupEntity.getProfessionId());
//                dbSupplier.setProfessionName(tmpSupEntity.getProfessionName());
//                dbSupplier.setProfessionSid(tmpSupEntity.getProfessionSid());
                dbSupplier.setLaborServNums(tmpSupEntity.getLaborServNums());
                dbSupplier.setTypeLabel(tmpSupEntity.getTypeLabel());
                dbSupplier.setSysLastUpd(tmpSupEntity.getSysLastUpd());
                dbSupplier.setErpCreatorSid(tmpSupEntity.getErpCreatorSid());

                //主导专业
                if(StringUtils.isNotBlank(tmpSupEntity.getProfessionId())) {
                    dbSupplier.setProfessionId(tmpSupEntity.getProfessionId());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getProfessionSid())) {
                    dbSupplier.setProfessionSid(tmpSupEntity.getProfessionSid());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getProfessionName())) {
                    dbSupplier.setProfessionSid(tmpSupEntity.getProfessionName());
                }

                //发展专业
                if(StringUtils.isNotBlank(tmpSupEntity.getDepProfessionId())) {
                    dbSupplier.setDepProfessionId(tmpSupEntity.getDepProfessionId());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getDepProfessionSid())) {
                    dbSupplier.setDepProfessionSid(tmpSupEntity.getDepProfessionSid());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getDepProfessionName())) {
                    dbSupplier.setDepProfessionName(tmpSupEntity.getDepProfessionName());
                }

                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState()); //是否一次使用
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason()); //一次性使用原因
                dbSupplier.setSealState(tmpSupEntity.getSealState()); //是否支持电子签章

                dbSupplier.setIntentName(tmpSupEntity.getIntentName());
                dbSupplier.setIntentId(tmpSupEntity.getIntentId());
                dbSupplier.setIntentSid(tmpSupEntity.getIntentSid());
                dbSupplier.setGroupTrain(tmpSupEntity.getGroupTrain());

                supList.add(dbSupplier);
                mapSourceMap.remove(dbSupplier.getThirdSourceId());

                //联系人信息更新
                List<LinkerEntity> saveLinkers = linkerMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        linkerMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();

                if(CollectionUtils.isNotEmpty(saveLinkers)) {
                    Map<String, LinkerEntity> sourceLinkers = dbLinkerMap.containsKey(dbSupplier.getId()) ? dbLinkerMap.get(dbSupplier.getId()).stream()
                            .collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap<>();
                    LinkerEntity tmpLink = null;
                    for(LinkerEntity link : saveLinkers) {
                        if(sourceLinkers.containsKey(link.getThirdSourceId())) {
                            tmpLink = sourceLinkers.get(link.getThirdSourceId());

                            tmpLink.setIdCardType(link.getIdCardType()); //证件类型
                            tmpLink.setIdCardId(link.getIdCardId()); //证件ID
                            tmpLink.setName(link.getName()); //联系人名称
                            tmpLink.setMobileLinkPhone(link.getMobileLinkPhone()); //联系人手机号
                            tmpLink.setLinkPhone(link.getLinkPhone()); //联系人固定电话
                            tmpLink.setElectronicMail(link.getElectronicMail());//联系人邮箱
                            tmpLink.setAddress(link.getAddress());//联系人通讯地址
                            tmpLink.setLinkerStatus(link.getLinkerStatus());//联系人状态
                            tmpLink.setUserType(link.getUserType()); //联系人标识

                            linkerList.add(tmpLink);
                        } else {
                            link.setSupplierName(dbSupplier.getName());
                            link.setSupplierCode(dbSupplier.getCode());
                            link.setSupplierId(dbSupplier.getId());
                            link.setDateType(0);
                            link.setEnableStatus(2); //默认停用
                            link.setChangeVersion(0);
                            if(null == link.getId()) {
                                link.setId(IdWorker.getId());
                                link.setSourceId(dbSupplier.getId());
                                link.setSourceDetailId(link.getId());
                            }
                            linkerList.add(link);
                        }
                    }
                }

                //项目经理信息
                List<SupplierManagerEntity> saveManagers = managerMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        managerMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                if(CollectionUtils.isNotEmpty(saveManagers)) {
                    Map<String, SupplierManagerEntity> sourceManager = dbManagerMap.containsKey(dbSupplier.getId()) ? dbManagerMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap<>();
                    SupplierManagerEntity tmpManager = null;
                    for(SupplierManagerEntity manager : saveManagers) {
                        if(sourceManager.containsKey(manager.getThirdSourceId())) {
                            tmpManager = sourceManager.get(manager.getThirdSourceId());
                            tmpManager.setIdCardId(manager.getIdCardId());
                            tmpManager.setIdCardType(manager.getIdCardType());
                            tmpManager.setProjectManagerName(manager.getProjectManagerName());
                            tmpManager.setMobileLinkPhone(manager.getMobileLinkPhone());//联系人手机号
                            tmpManager.setLinkPhone(manager.getLinkPhone());//联系人固定电话
                            tmpManager.setElectronicMail(manager.getElectronicMail());//联系人邮箱
                            tmpManager.setAddress(manager.getAddress());//联系人通讯地址
                            tmpManager.setProjectManagerStatus(manager.getProjectManagerStatus()); //项目经理状态
                            managerList.add(tmpManager);
                        } else {
                            manager.setCoordination(PlanConstant.STRING_NO);//未协同
                            manager.setSynergyAccountStatus(2); //未协同
                            manager.setEnableStatus(2);//停用
                            manager.setSupplierId(dbSupplier.getId());
                            if(null == manager.getId()) {
                                manager.setId(IdWorker.getId());
                                manager.setSourceId(dbSupplier.getId());
                                manager.setSourceDetailId(manager.getId());
                            }
                            managerList.add(manager);
                        }
                    }
                }

                //资质信息
                List<SupplierCertificateEntity> saveCerts = certMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        certMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                if(CollectionUtils.isNotEmpty(saveCerts)) {
                    Map<String, SupplierCertificateEntity> sourceCert = dbCertMap.containsKey(dbSupplier.getId())? dbCertMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getThirdSourceId()))
                            .collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap<>();
                    SupplierCertificateEntity tmpCert = null;
                    for(SupplierCertificateEntity cert : saveCerts) {
                        if(sourceCert.containsKey(cert.getThirdSourceId())) {
                            tmpCert= sourceCert.get(cert.getThirdSourceId());
                            tmpCert.setCertificateNumber(cert.getCertificateNumber());
                            tmpCert.setCertificateTypeName(cert.getCertificateTypeName());
                            if(StringUtils.isNotBlank(cert.getCertificateFileName())) {
                                tmpCert.setCertificateFileName(cert.getCertificateFileName());
                            }
                            if(StringUtils.isNotBlank(cert.getCertificateTypeCode())) {
                                tmpCert.setCertificateTypeCode(cert.getCertificateTypeCode());
                            }
                            if(null == tmpCert.getCertificateTypeId() && null != cert.getCertificateTypeId()) {
                                tmpCert.setCertificateTypeId(cert.getCertificateTypeId());
                            }
                            if(StringUtils.isNotBlank(cert.getCertificateFileUrl())) {
                                tmpCert.setCertificateFileUrl(cert.getCertificateFileUrl());
                            }

                            tmpCert.setPeriodOfValidity(cert.getPeriodOfValidity());
                            certList.add(tmpCert);
                        } else {
                            cert.setSupplierId(dbSupplier.getId());
                            if(null == cert.getId()) {
                                cert.setId(IdWorker.getId());
                                cert.setSourceId(dbSupplier.getId());
                                cert.setSourceDetailId(cert.getId());
                            }
                            certList.add(cert);
                        }
                    }
                }

                //银行信息
                List<SupplierBankEntity> saveBanks = bankMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        bankMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                if(CollectionUtils.isNotEmpty(saveBanks)) {
                    Map<String, SupplierBankEntity> sourceBank = dbBankMap.containsKey(dbSupplier.getId()) ? dbBankMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getBankThirdSourceId()))
                            .collect(Collectors.toMap(item -> item.getBankThirdSourceId(), item -> item)) : new HashMap<>();

                    SupplierBankEntity tmpBank = null;
                    for(SupplierBankEntity bank : saveBanks) {
                        if(sourceBank.containsKey(bank.getBankThirdSourceId())) {
                            tmpBank = sourceBank.get(bank.getBankThirdSourceId());
                            tmpBank.setBankNumber(bank.getBankNumber()); //银行账号
                            tmpBank.setNumberType(bank.getNumberType()); //账号类型
                            tmpBank.setBankName(bank.getBankName()); //银行名称
                            tmpBank.setBankType(bank.getBankType()); //银行类型
                            tmpBank.setProvince(bank.getProvince()); //省
                            tmpBank.setCity(bank.getCity()); //市
                            tmpBank.setOpenBank(bank.getOpenBank()); //开户行
                            tmpBank.setBankLineNumber(bank.getBankLineNumber()); //银行行号
                            if(StringUtils.isBlank(tmpBank.getBankSid()) && StringUtils.isNotBlank(bank.getBankSid())) {
                                tmpBank.setBankSid(bank.getBankSid());
                            }
                            if(StringUtils.isBlank(tmpBank.getBankCategorySid()) && StringUtils.isNotBlank(bank.getBankCategorySid())) {
                                tmpBank.setBankCategorySid(bank.getBankCategorySid());
                            }

                            bankList.add(tmpBank);
                        } else {
                            bank.setSupplierId(dbSupplier.getId());
                            if(null == bank.getId()) {
                                bank.setId(IdWorker.getId());
                                bank.setSourceId(dbSupplier.getId());
                                bank.setSourceDetailId(bank.getId());
                            }
                            bankList.add(bank);
                        }
                    }
                }
                //附件信息
                List<SupplierAttachesEntity> saveAttaches = attachMap.containsKey(dbSupplier.getThirdSourceId()) ?
                        attachMap.get(dbSupplier.getThirdSourceId()).stream().collect(Collectors.toList()) : new ArrayList<>();
                if(dbAttachMap.containsKey(dbSupplier.getId())) {
                    Map<String, SupplierAttachesEntity> sourceAttach = dbAttachMap.get(dbSupplier.getId()).stream()
                            .filter(item -> StringUtils.isNotBlank(item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
                    SupplierAttachesEntity saveAttach = null;
                    for(SupplierAttachesEntity attach : saveAttaches) {
                        if(!sourceAttach.containsKey(attach.getThirdSourceId())) {
                            attach.setSupplierId(dbSupplier.getId());
                            if(null == attach.getId()) {
                                attach.setId(IdWorker.getId());
                                attach.setSourceId(dbSupplier.getId());
                                attach.setSourceDetailId(attach.getId());
                            }
                            attachList.add(attach);
                        }
                    }
                }

                linkerMap.remove(dbSupplier.getThirdSourceId());
                attachMap.remove(dbSupplier.getThirdSourceId());
                bankMap.remove(dbSupplier.getThirdSourceId());
                managerMap.remove(dbSupplier.getThirdSourceId());
                certMap.remove(dbSupplier.getThirdSourceId());
            }
        }

        if(!mapSourceMap.isEmpty()) {
            for(SupplierEntity erpSupplier : mapSourceMap.values()) {

                if(StringUtils.isNotBlank(erpSupplier.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    Arrays.asList(erpSupplier.getIntentName().split(",")).stream().forEach(item -> {
                        if(areaMap.containsKey(item)) {
                            tmpIds.add(areaMap.get(item).getId().toString());
                            tmpSIds.add(areaMap.get(item).getSourceId());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(tmpIds)) {
                        erpSupplier.setIntentId(StringUtils.join(tmpIds, ","));
                        erpSupplier.setIntentSid(StringUtils.join(tmpSIds, ","));
                    }
                }
                if(StringUtils.isNotBlank(erpSupplier.getCorpSid()) && orgMap.containsKey(erpSupplier.getCorpSid())) {
                    erpSupplier.setCorpId(orgMap.get(erpSupplier.getCorpSid()).getId());
                    erpSupplier.setCorpName(orgMap.get(erpSupplier.getCorpSid()).getName());
                }
                if(StringUtils.isNotBlank(tmpSupEntity.getProfessionId())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getProfessionId().split(",")).stream().forEach(item -> {
                        if(subTypeMap.containsKey(item)) {
                            subTypeNames.add(subTypeMap.get(item).getName());
                            subTypeIds.add(subTypeMap.get(item).getId().toString());
                        }
                    });
                    if(CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setProfessionId(StringUtils.join(subTypeIds, ","));
                        tmpSupEntity.setProfessionName(StringUtils.join(subTypeNames, ","));
                    }
                }

                supList.add(erpSupplier);
                if(linkerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    linkerMap.get(erpSupplier.getThirdSourceId()).forEach(link -> {
                        link.setSupplierName(erpSupplier.getName());
                        link.setSupplierCode(erpSupplier.getCode());
                        link.setSupplierId(erpSupplier.getId());
                        link.setDateType(0);
                        link.setChangeVersion(0);
                        linkerList.add(link);
                    });
                }
                if(bankMap.containsKey(erpSupplier.getThirdSourceId())) {
                    bankMap.get(erpSupplier.getThirdSourceId()).forEach(bank -> {
                        bank.setSupplierId(erpSupplier.getId());
                        bankList.add(bank);
                    });

                }
                if(attachMap.containsKey(erpSupplier.getThirdSourceId())) {
                    attachMap.get(erpSupplier.getThirdSourceId()).forEach(attach -> {
                        attach.setSupplierId(erpSupplier.getId());
                        attachList.add(attach);
                    });
                }
                if(managerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    managerMap.get(erpSupplier.getThirdSourceId()).forEach(manager -> {
                        manager.setSupplierId(erpSupplier.getId());
                        managerList.add(manager);
                    });

                }
                if(certMap.containsKey(erpSupplier.getThirdSourceId())) {
                    certMap.get(erpSupplier.getThirdSourceId()).forEach(cert -> {
                        cert.setSupplierId(erpSupplier.getId());
                        certList.add(cert);
                    });
                }
            }
        }

        if(CollectionUtils.isNotEmpty(supList)) {
            //保存/更新分包商
            logger.info("本次更新分包商数量：{}", supList.size());
            service.saveOrUpdateBatch(supList, supList.size(), false);
        }

        if(CollectionUtils.isNotEmpty(linkerList)) {
            //保存分包商联系人
            logger.info("本次保存分包商联系人数量：{}", linkerList.size());
            linkerService.saveOrUpdateBatch(linkerList, linkerList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(bankList)) {
            //保存分包商银行
            logger.info("本次保存分包商银行数量：{}", bankList.size());
            supplierBankService.saveOrUpdateBatch(bankList, bankList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(attachList)) {
            //保存分包商附件
            logger.info("本次保存分包商附件数量：{}", attachList.size());
            attachesService.saveOrUpdateBatch(attachList, attachList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(managerList)) {
            //保存分包商项目经理
            logger.info("本次保存分包商项目经理数量：{}", managerList.size());
            managerService.saveOrUpdateBatch(managerList, managerList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(certList)) {
            //保存分包商资质证书
            logger.info("本次保存分包商资质证书数量：{}", certList.size());
            certificateService.saveOrUpdateBatch(certList, certList.size(), false);
        }
    }

    private void handleQualification(Map<String, List<SupplierCertificateEntity>> certMap, JSONArray qualificationInfoList) {
        logger.info("本次待处理分包商-资质证书数据：{}条", qualificationInfoList.size());
        JSONObject tmpQuaJson = null;
        SupplierCertificateEntity tmpQua = null;
        Set<String> certTypeSid = new HashSet<>();
        Set<String> certTypeName = new HashSet<>();
        List<SupplierCertificateEntity> allCert = new ArrayList<>();
        for(Object obj : qualificationInfoList) {
            tmpQuaJson = (JSONObject) obj;
            tmpQua = new SupplierCertificateEntity();
            tmpQua.setThirdSourceId(tmpQuaJson.getString("C_PS_QualificationInfoOID")); //ERP主键
            tmpQua.setCertificateTypeName(tmpQuaJson.getString("LQualificationcateGoryandevel")); //资质类别及等级name
            tmpQua.setCertificateTypeCode(tmpQuaJson.getString("LQualificationcateGoryandevelsid")); //资质类别等级sid
            tmpQua.setCertificateNumber(tmpQuaJson.getString("CertificateNumber"));//证书编号
            tmpQua.setSourceType(3); //默认来源ERP
            if(StringUtils.isNotEmpty(tmpQua.getCertificateTypeCode())) {
                certTypeSid.add(tmpQua.getCertificateTypeCode());
            }
            if(StringUtils.isNotEmpty(tmpQua.getCertificateTypeName())) {
                certTypeName.add(tmpQua.getCertificateTypeName());
            }
            try {
                if(null != tmpQuaJson.get("Validityperiod") && StringUtils.isNotBlank(tmpQuaJson.getString("Validityperiod"))) {
                    tmpQua.setPeriodOfValidity(DateFormatUtil.parseDate("yyyy-MM-dd", tmpQuaJson.getString("Validityperiod").split("T")[0])); //有效期
                }
            } catch (Exception e) {
                logger.error("分包商资质证书有效期格式化异常：{}, ", tmpQuaJson.toString(SerializerFeature.PrettyFormat), e);
            }

            tmpQua.setSupplierSid(tmpQuaJson.getString("C_PS_SubContractorInfo_FK")); //分包商ERPSID

            if(!certMap.containsKey(tmpQua.getSupplierSid())) {
                certMap.put(tmpQua.getSupplierSid(), new ArrayList<>());
            }
            allCert.add(tmpQua);
            certMap.get(tmpQua.getSupplierSid()).add(tmpQua);
        }

        Map<String, DefdocDetailVO> sidMap = certificateService.getAllCertTypeByCertTypeSid(new ArrayList<>(certTypeSid));
        Map<String, DefdocDetailVO> nameMap = certificateService.getAllCertTypeByCertTypeName(new ArrayList<>(certTypeName));

        for(SupplierCertificateEntity cert : allCert) {
            if(sidMap.containsKey(cert.getCertificateTypeCode())) {
                cert.setCertificateTypeId(sidMap.get(cert.getCertificateTypeCode()).getId());
            }
            if(null == cert.getCertificateTypeId() && nameMap.containsKey(cert.getCertificateTypeName())) {
                cert.setCertificateTypeId(nameMap.get(cert.getCertificateTypeName()).getId());
                cert.setCertificateTypeCode(nameMap.get(cert.getCertificateTypeName()).getCode());
            }
        }
    }

    private void handleProjectManager(Map<String, List<SupplierManagerEntity>> managerMap, JSONArray projectManagerList) {
        logger.info("本次待处理分包商-项目经理数据：{}条", projectManagerList.size());
        JSONObject tmpManagerJson = null;
        SupplierManagerEntity tmpManager = null;
        for(Object obj : projectManagerList) {
            tmpManagerJson = (JSONObject) obj;
            tmpManager = new SupplierManagerEntity();
            tmpManager.setThirdSourceId(tmpManagerJson.getString("C_PS_ProjektleiterInfoOID")); //ERP 主键
            tmpManager.setProjectManagerStatus(tmpManagerJson.getInteger("ContactStatus")); //0正常、1禁用、2黑名单
            tmpManager.setEnableStatus(2); //默认停用
            tmpManager.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode(tmpManagerJson.getString("IDType"))); //证件类型
            tmpManager.setIdCardId(tmpManagerJson.getString("IDCard")); //证件ID
            tmpManager.setProjectManagerName(tmpManagerJson.getString("ContactName")); //联系人名称
//            tmpManager.setSupplierId(tmpSupEntity.getIntentId()); //分包商Id
            tmpManager.setCoordination("0");//默认未协同
            tmpManager.setMobileLinkPhone(tmpManagerJson.getString("Contact_Mobile")); //联系人手机号
            tmpManager.setLinkPhone(tmpManagerJson.getString("Contact_Telephone")); //联系人固定电话
            tmpManager.setElectronicMail(tmpManagerJson.getString("Contact_Email"));//联系人邮箱
            tmpManager.setAddress(tmpManagerJson.getString("Contact_Address"));//联系人通讯地址
            tmpManager.setSupplierSid(tmpManagerJson.getString("C_PS_SubContractorInfo_FK")); //分包商ERPSID

//            tmpSupEntity.getManagerList().add(tmpManager);

            if(!managerMap.containsKey(tmpManager.getSupplierSid())) {
                managerMap.put(tmpManager.getSupplierSid(), new ArrayList<>());
            }
            managerMap.get(tmpManager.getSupplierSid()).add(tmpManager);
        }
    }

    private void handleLinker(Map<String, List<LinkerEntity>> linkerMap, JSONArray contactList) {
        logger.info("本次待处理分包商-联系人数据：{}条", contactList.size());
        LinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;

        for(Object obj : contactList) {
            tmpLinkerJson = (JSONObject) obj;
            tmpLinkerEntity = new LinkerEntity();
            tmpLinkerEntity.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode(tmpLinkerJson.getString("IDType"))); //证件类型
            tmpLinkerEntity.setIdCardId(tmpLinkerJson.getString("IDCard")); //证件ID
            tmpLinkerEntity.setName(tmpLinkerJson.getString("Company_Contact")); //联系人名称
            tmpLinkerEntity.setSupplierSid(tmpLinkerJson.getString("C_PS_SubContractorInfo_FK")); //分包商ERPSID
            //ERP联系人类型: 法人为0，授权人为1  EL联系人类型：1:法定代表人、2:法定授权人
            try {
                tmpLinkerEntity.setUserType(StringUtils.isNotBlank(tmpLinkerJson.getString("AuthorFlag"))  ?
                        "0".equals(tmpLinkerJson.getString("AuthorFlag")) ? 1 : 2 : null);
            } catch (Exception e) {
                logger.error("分包联系人sid-{} 联系人类型格式化错误：{}", tmpLinkerJson.getString("subA_oid"), tmpLinkerJson.getString("AuthorFlag"));
                tmpLinkerEntity.setUserType(null);
            }

            tmpLinkerEntity.setMobileLinkPhone(tmpLinkerJson.getString("Contact_Mobile")); //联系人手机号
            tmpLinkerEntity.setLinkPhone(tmpLinkerJson.getString("Contact_Telephone")); //联系人固定电话
            tmpLinkerEntity.setElectronicMail(tmpLinkerJson.getString("Contact_Email"));//联系人邮箱
            tmpLinkerEntity.setAddress(tmpLinkerJson.getString("Contact_Address"));//联系人通讯地址
            tmpLinkerEntity.setLinkerStatus(tmpLinkerJson.getInteger("ContactState"));//联系人状态 0正常、1禁用、2黑名单
            tmpLinkerEntity.setThirdSourceId(tmpLinkerJson.getString("subA_oid")); //联系人ERP主键
            tmpLinkerEntity.setCoordination("0"); //默认未协同
            tmpLinkerEntity.setEnableStatus(2); //联系人状态 默认停用

//            tmpSupEntity.getLinkerList().add(tmpLinkerEntity);
            if(!linkerMap.containsKey(tmpLinkerEntity.getSupplierSid())) {
                linkerMap.put(tmpLinkerEntity.getSupplierSid(), new ArrayList<>());
            }
            linkerMap.get(tmpLinkerEntity.getSupplierSid()).add(tmpLinkerEntity);
        }
    }

    private void handleBank(Map<String, List<SupplierBankEntity>> bankMap, JSONArray bankList) {
        logger.info("本次待处理分包商-银行数据：{}条", bankList.size());
        JSONObject tmpBankJson = null;
        SupplierBankEntity bankEntity = null;

        Set<String> bankName = new HashSet<>();
        Set<String> bankCategoryName = new HashSet<>();
        Set<String> bankCategoryCode = new HashSet<>();
        List<SupplierBankEntity> allBank = new ArrayList<>();
        for(Object obj : bankList) {
            tmpBankJson = (JSONObject) obj;
            bankEntity = new SupplierBankEntity();
            bankEntity.setBankThirdSourceId(tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID")); //ERP字表主键
            bankEntity.setBankNumber(tmpBankJson.getString("Contact_BankAccount")); //银行账号
            bankEntity.setNumberType(null != tmpBankJson.getInteger("AccountType") ? tmpBankJson.getInteger("AccountType")+1 : null); //账号类型
            bankEntity.setBankName(tmpBankJson.getString("SubBankName")); //银行名称
            bankEntity.setBankType(tmpBankJson.getString("BankType")); //银行类型
            bankEntity.setProvince(tmpBankJson.getString("Province")); //省
            bankEntity.setCity(tmpBankJson.getString("City")); //市
            bankEntity.setOpenBank(tmpBankJson.getString("Contact_Bank")); //开户行
            bankEntity.setBankLineNumber(tmpBankJson.getString("Contact_BankNumber")); //银行行号
            bankEntity.setSupplierSid(tmpBankJson.getString("C_PS_SubContractorInfo_FK")); //分包商ERP主键
//            bankEntity.setSupplierId(tmpSupEntity.getId()); //分包商主键
//            tmpSupEntity.getBankList().add(bankEntity);

            if(!bankMap.containsKey(bankEntity.getSupplierSid())) {
                bankMap.put(bankEntity.getSupplierSid(), new ArrayList<>());
            }
            if(StringUtils.isNotBlank(bankEntity.getOpenBank())) {
                bankName.add(bankEntity.getOpenBank());
            }
            if(StringUtils.isNotBlank(bankEntity.getBankName())) {
                bankCategoryName.add(bankEntity.getBankName());
            }
            if(StringUtils.isNotBlank(bankEntity.getBankType())) {
                bankCategoryCode.add(bankEntity.getBankType());
            }
            bankMap.get(bankEntity.getSupplierSid()).add(bankEntity);
            allBank.add(bankEntity);
        }

        Map<String, BankEntity> bankNameMap = bankService.getAllMapByNames(new ArrayList<>(bankName));
        Map<String, BankCategoryEntity> bankCategoryNameMap = bankCategoryService.getAllMapByNames(new ArrayList<>(bankCategoryName));
        Map<String, BankCategoryEntity> bankCategoryCodeMap = bankCategoryService.getAllMapByCodes(new ArrayList<>(bankCategoryCode));

        for(SupplierBankEntity bankSub : allBank) {
            if(StringUtils.isNotBlank(bankSub.getOpenBank()) && bankNameMap.containsKey(bankSub.getOpenBank())) {
                bankSub.setBankId(bankNameMap.get(bankSub.getOpenBank()).getId());
                bankSub.setBankSid(bankNameMap.get(bankSub.getOpenBank()).getSourceId());
            }
            if(StringUtils.isNotBlank(bankSub.getBankName()) && bankCategoryNameMap.containsKey(bankSub.getBankName())) {
                bankSub.setBankCategorySid(bankCategoryNameMap.get(bankSub.getBankName()).getSourceId());
                if(StringUtils.isNotBlank(bankSub.getBankType())) {
                    bankSub.setBankType(bankCategoryNameMap.get(bankSub.getBankName()).getCode());
                }
            }
            if(StringUtils.isNotBlank(bankSub.getBankType()) && bankCategoryCodeMap.containsKey(bankSub.getBankType())
                    && StringUtils.isBlank(bankSub.getBankCategorySid())) {
                bankSub.setBankCategorySid(bankCategoryCodeMap.get(bankSub.getBankType()).getSourceId());
                if(StringUtils.isNotBlank(bankSub.getBankName())) {
                    bankSub.setBankName(bankCategoryCodeMap.get(bankSub.getBankType()).getName());
                }
            }
        }
    }

    private void handleArchive(Map<String, List<SupplierAttachesEntity>> attachMap, JSONArray archiveList) {
        logger.info("本次待处理分包商-附件数据：{}条", archiveList.size());
        JSONObject tmpAttachJson = null;
        SupplierAttachesEntity attach = null;

        for(Object obj : archiveList) {
            tmpAttachJson = (JSONObject) obj;
            attach = new SupplierAttachesEntity();
//            attach.setSupplierId(tmpSupEntity.getId()); //分包商Id
            attach.setThirdSourceId(tmpAttachJson.getString("C_PS_ArchivesOID")); //ERP主键
            attach.setFileName(tmpAttachJson.getString("Attach_Name")); //附件名称
            attach.setFileType(tmpAttachJson.getString("Attach_Extension")); //附件扩展名
            attach.setFileUrl(tmpAttachJson.getString("AttachBase64")); //附件url
            attach.setSourceType(3); //默认为ERP来源附件
            attach.setSupplierSid(tmpAttachJson.getString(""));

            attach.setSupplierSid(tmpAttachJson.getString("C_PS_SubContractorInfo_FK")); //分包商ERP主键
//            tmpSupEntity.getAttachesList().add(attach);

            if(!attachMap.containsKey(attach.getSupplierSid())) {
                attachMap.put(attach.getSupplierSid(), new ArrayList<>());
            }
            attachMap.get(attach.getSupplierSid()).add(attach);
        }
    }

    private String getDatePattern(String operatingPeriodStartEnd) {
        StringBuilder sp = new StringBuilder();
        String[] dateArr = operatingPeriodStartEnd.split(" ");
        String[] yearDateArr = dateArr[0].split("/");
        sp.append("yyyy/M");
        if(yearDateArr[1].length() > 1) {
            sp.append("M");
        }
        sp.append("/d");
        if(yearDateArr[1].length() > 1) {
            sp.append("d");
        }
        return sp.toString();
    }

}
