package com.ejianc.business.zdssupplier.sub.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeEntity;

import javax.servlet.http.HttpServletRequest;

/**
 * 分包供应商变更
 * 
 * @author generator
 * 
 */
public interface ISupplierChangeService extends IBaseService<SupplierChangeEntity> {

    SupplierChangeVO saveOrUpdate(SupplierChangeVO saveOrUpdateVO);

    SupplierChangeVO saveChangeBySupplierId(Long id);

    /**
     * 供应商名称调用天眼查
     * @param supplierName
     * @param id
     * @return
     */
    SupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id);

    /**
     * 校验是否有在途单据
     * @param id
     * @return
     */
    Boolean validateRunning(Long supplierId, Long id);

    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 同步单据供应商状态信息
     *
     * @param vo
     */
    String updateBillStatus(SupplierChangeVO vo);

    /**
     * 同步单据供应商状态信息
     *
     * @param vo
     * @param saveFlag 是否供方推送保存单据
     */
    String updateBillStatus(SupplierChangeVO vo, Boolean saveFlag);

    /**
     * 查询对比数据
     * @param changeId
     * @return
     */
    JSONObject contrast(Long changeId);

    /**
     * 生成历史记录
     * @param supplierId
     * @param changeId
     * @return
     */
    Boolean pushToHistory(Long supplierId, Long changeId);

    JSONArray getSupplierApprList(Long id);

    JSONArray getSupplierApprList(SupplierChangeEntity entity);
}
