package com.ejianc.business.zdssupplier.sub.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包供应商档案
 * 
 * @author generator
 * 
 */
public interface ISupplierService extends IBaseService<SupplierEntity> {

    String sendMq(String queueName, String body);

    SupplierVO saveOrUpdate(SupplierVO saveOrUpdateVO);

    /**
     * 供方列表查询
     * @param request
     * @return
     */
    CommonResponse<IPage<SupplierVO>> queryListBill(HttpServletRequest request);

    /**
     * 供方查询详情
     * @param request
     * @return
     */
    CommonResponse<SupplierEntity> queryDetailBill(HttpServletRequest request);

    /**
     * 供应商生成协同租户
     * @param supplier
     * @return
     */
    TenantVO createSupTenant(SupplierEntity supplier);

    SupplierVO getByTenantId(Long supplierTenant);

    List<SupplierEntity> getAllByThirdSourceIds(ArrayList arrayList);

    /**
     * 校验统一社会信用代码唯一性
     * @param socialCreditCode
     * @return
     */
    Boolean validateUnique(String name, String socialCreditCode, Long id, String operate);

    /**
     * 推送分包供应商变更信息至ERP
     *
     * @param syncParam
     */
    String syncSupplierChangeToErp(SupplierSyncErpParamVO syncParam);

    JSONArray getSupplierApprList(Long supplierId);

    void syncSupplierErpSid(Long supplierId);

    JSONObject getSupErpInfo(Long supplierId);

    SupplierVO saveOrUpdateSupInfo(SupplierVO save, boolean cooFlag);

    void initCooInfo(Long supplierId);

    List<SupplierEntity> getAllByIds(List<Long> supplierIds);
}
