package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupStatusEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerChangeVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.LinkerChangeMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerChangeService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包联系人变更
 *
 * @author generator
 */
@Service("linkerChangeService")
public class LinkerChangeServiceImpl extends BaseServiceImpl<LinkerChangeMapper, LinkerChangeEntity> implements ILinkerChangeService {
    private final String OPERATE = "linkerChangeBill";
    private final String FILE_TYPE = "EJCBT202403000017";
    private final String LEGAL_FILE_BILL_TYPE = "legalPersonFile";
    private final String AGENT_FILE_BILL_TYPE = "agentFile";
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/linkerChange/syncBill";//推送接口
    private static final String BILL_CODE = "ZDS_SUB_LINKER_CHANGE";//此处需要根据实际修改


    @Value("${file.batchdownflow}")
    private String batchdownflow;// 供方下载附件地址


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentRefApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Override
    public LinkerChangeVO addConvertById(Long linkerId) {
        LinkerEntity linkerEntity = linkerService.selectById(linkerId);
        if (SupLinkerEnum.变更中.getCode().equals(linkerEntity.getChangeStatus())) {
            return queryDetail(linkerEntity.getChangeId());
        }
        LinkerChangeVO changeVO = BeanMapper.map(linkerEntity, LinkerChangeVO.class);
        changeVO.setChangeVersion(changeVO.getChangeVersion()+1);
        changeVO.setBillState(null);
        changeVO.setLinkerId(linkerId);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setSourceType(SupStatusEnum.项目.getCode());

        changeVO.setBeforeAgencyFileId(linkerEntity.getAgencyFileId());
        changeVO.setAgencyFileId(null);
        changeVO.setAgencyFileName(null);
        changeVO.setBeforeAgencyFileName(linkerEntity.getAgencyFileName());
        changeVO.setBeforeCertifyFileId(linkerEntity.getCertifyFileId());
        changeVO.setBeforeCertifyFileName(linkerEntity.getCertifyFileName());
        changeVO.setCertifyFileId(null);
        changeVO.setCertifyFileName(null);
        changeVO.setBeforePersonFileId(linkerEntity.getLegalPersonFileId());
        changeVO.setBeforePersonFileName(linkerEntity.getLegalPersonFileName());
        changeVO.setLegalPersonFileId(null);
        changeVO.setLegalPersonFileName(null);

        return changeVO;
    }

    @Override
    public LinkerChangeVO queryDetail(Long changeId) {
        LinkerChangeEntity matLinkerChangeEntity = super.selectById(changeId);
        LinkerChangeVO changeVO = BeanMapper.map(matLinkerChangeEntity, LinkerChangeVO.class);
        changeField(changeVO);
        return changeVO;
    }

    public void changeField(LinkerChangeVO changeVO) {
        List<String> changeField = new ArrayList<>();
        //先查询联系人信息
        LinkerEntity matLinkerEntity = linkerService.selectById(changeVO.getLinkerId());
        LinkerChangeVO resultData = BeanMapper.map(matLinkerEntity, LinkerChangeVO.class);
        //比较请求数据
        if(!StringUtils.equals(resultData.getMobileLinkPhone(), changeVO.getMobileLinkPhone())) {
            changeField.add("mobileLinkPhone");
        }
        if(!StringUtils.equals(resultData.getElectronicMail(), changeVO.getElectronicMail())) {
            changeField.add("electronicMail");
        }
        if(!StringUtils.equals(resultData.getAddress(), changeVO.getAddress())) {
            changeField.add("address");
        }
        if(!StringUtils.equals(String.valueOf(resultData.getUserType()), String.valueOf(changeVO.getUserType()))) {
            changeField.add("userType");
            if (changeVO.getUserType() == 1) {
                changeField.add("legalPersonFile");
            } else {
                changeField.add("agencyFile");
                if(null != resultData.getCertifyFileId()) {
                    changeField.add("certifyFile");
                }
            }
        } else {
            if (changeVO.getUserType() == 1) {
                if (null != changeVO.getLegalPersonFileId()) {
                    changeField.add("legalPersonFile");
                }
            } else {
                if (null != changeVO.getAgencyFileId()) {
                    changeField.add("agencyFile");
                }
                if (null != changeVO.getCertifyFileId()) {
                    changeField.add("certifyFile");
                }
            }
        }
        if(!matLinkerEntity.getName().equals(changeVO.getUserName())) {
            changeField.add("name");
            changeField.add("userName");
            changeField.add("beforeName");
        }
        if(!String.valueOf(changeVO.getLinkerStatus()).equals(changeVO.getLinkerStatus())) {
            changeField.add("linkerStatus");
        }

        changeVO.setChangeField(changeField);
    }

    @Autowired
    private IMatLinkerService mapService;
    @Autowired
    private IMatLinkerChangeService matLinkerChangeService;

    @Override
    public JSONObject contrast(Long linkerId,Long changeId, String flagType) {
        if ("sub".equals(flagType)) {
            //先查询联系人信息
            JSONObject js = new JSONObject();
            LinkerChangeVO LinkerChangeVO = queryDetail(changeId);
            js.put("LinkerChangeVO", LinkerChangeVO);
            QueryWrapper<LinkerEntity> queryWrapper = new QueryWrapper<>();
            if(BillStateEnum.PASSED_STATE.getBillStateCode().equals(LinkerChangeVO.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(LinkerChangeVO.getBillState())) {
                //变更完成 查询历史纪录
                queryWrapper.eq("change_version", LinkerChangeVO.getChangeVersion());
                queryWrapper.eq("main_linker_id", linkerId);
            } else {
                //查询当前联系人信息
                queryWrapper.eq("id", linkerId);
            }

            List<LinkerEntity> list = linkerService.list(queryWrapper);
            LinkerEntity supplierEntity = list.get(0);
            LinkerVO vo = BeanMapper.map(supplierEntity, LinkerVO.class);
            js.put("LinkerVO", vo);
            return js;
        } else {
            JSONObject js = new JSONObject();
            MatLinkerChangeEntity matLinkerChangeEntity = matLinkerChangeService.selectById(changeId);
            MatLinkerChangeVO matLinkerChangeVO = BeanMapper.map(matLinkerChangeEntity, MatLinkerChangeVO.class);
            js.put("LinkerChangeVO", matLinkerChangeVO);
            QueryWrapper<MatLinkerEntity> queryWrapper = new QueryWrapper<>();
            if(BillStateEnum.PASSED_STATE.getBillStateCode().equals(matLinkerChangeVO.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(matLinkerChangeVO.getBillState())) {
                //变更完成 查询历史纪录
                queryWrapper.eq("change_version", matLinkerChangeVO.getChangeVersion());
                queryWrapper.eq("main_linker_id", linkerId);
            } else {
                //查询当前联系人信息
                queryWrapper.eq("id", linkerId);
            }
            List<MatLinkerEntity> list = mapService.list(queryWrapper);
            MatLinkerEntity supplierEntity = list.get(0);
            MatLinkerVO matLinkerVO = BeanMapper.map(supplierEntity, MatLinkerVO.class);
            js.put("LinkerVO", matLinkerVO);
            return js;
        }
    }


    @Override
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        //变更查询当前是否是变更中
        String transData = request.getParameter("transData");
        String fileListStr = request.getParameter("fileList");
        List<AttachmentVO> fileList = JSONObject.parseObject(fileListStr, new TypeReference<List<AttachmentVO>>(){});
        logger.info("接收到数据transData：{}，fileList：{}", transData, fileList);
        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        LinkerChangeEntity entity = JSONObject.parseObject(transData, LinkerChangeEntity.class);
        Long linkerId = entity.getLinkerId();
        long id = IdWorker.getId();
        //查询当前是否变更中
        boolean b = linkerService.linkerChangeStatus(linkerId, id);
        if(b){
            return CommonResponse.error("该联系人正在变更中，请稍后再试！");
        }
        entity.setSourceId(entity.getId());
        entity.setId(id);
//        fileLock(entity);
        // 保存单据中附件并获取到上传后附件的Id
        if(Integer.valueOf(1).equals(entity.getUserType())) {
            if(StringUtils.isNotBlank(entity.getLegalPersonFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.分包联系人变更单据类型.getValue(), entity.getId(),
                        PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(entity.getLegalPersonFileId()));
                entity.setLegalPersonFileId(fileId.toString());
            }
        } else {
            if(StringUtils.isNotBlank(entity.getAgencyFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.分包联系人变更单据类型.getValue(), entity.getId(), PlanConstant.AGENT_SOURCE_TYPE,
                        Long.valueOf(entity.getAgencyFileId()));
                entity.setAgencyFileId(fileId.toString());
            }
            if(StringUtils.isNotBlank(entity.getCertifyFileId())) {
                Long fileId = pushSupUtil.uploadFileFormNet(SupLinkerEnum.分包联系人变更单据类型.getValue(), entity.getId(), PlanConstant.CERTIFY_SOURCE_TYPE,
                        Long.valueOf(entity.getCertifyFileId()));
                entity.setCertifyFileId(fileId.toString());
            }
        }

        //讲项目方变更前文件Id更新至变更单中
        LinkerEntity dbLinker = linkerService.selectById(linkerId);
        entity.setBeforeAgencyFileId(dbLinker.getAgencyFileId());
        entity.setBeforeCertifyFileId(dbLinker.getCertifyFileId());
        entity.setBeforePersonFileId(dbLinker.getLegalPersonFileId());

        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(SupLinkerEnum.初审待确认.getCode());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        logger.info("物资联系人转换保存单据: {}", JSONObject.toJSONString(entity));
        super.saveOrUpdate(entity, false);
        return CommonResponse.success("单据同步成功！");
    }

//    public void fileLock(LinkerChangeEntity entity) {
//        if (entity.getNewFileIds()!=null&&entity.getNewFileIds().size()>0) {
//            CommonResponse<AttachmentVO> fileResp = attachmentRefApi.queryDetail(String.valueOf(entity.getNewFileIds().get(0)));
//            if (fileResp.isSuccess() && null == fileResp.getData()) {
//                UploadFileForNetParam uploadFileForNetParam = new UploadFileForNetParam();
//                uploadFileForNetParam.setTenantId(InvocationInfoProxy.getTenantid());
//                uploadFileForNetParam.setBillType(SupLinkerEnum.分包联系人变更单据类型.getValue());
//                uploadFileForNetParam.setSourceId(entity.getId());
//                uploadFileForNetParam.setSourceType(entity.getUserType() == 1 ? SupLinkerEnum.法人sourceType.getValue() : SupLinkerEnum.代理人人sourceType.getValue());
//                uploadFileForNetParam.setFilePathList(entity.getFilePathList());
//                uploadFileForNetParam.setNewFileIds(entity.getNewFileIds());
//                CommonResponse<String> stringCommonResponse = attachmentRefApi.uploadFileFormNet(uploadFileForNetParam);
//                logger.info("上传附件结果:{}", JSONObject.toJSONString(stringCommonResponse));
//            }else {
//                logger.error("查询附件失败，附件id:{}", JSONObject.toJSONString(entity.getNewFileIds()));
//            }
//        }
//
//    }


    @Override
    public CommonResponse<LinkerChangeVO> pushStatus(Long id) {
        LinkerChangeEntity entity = super.selectById(id);
        linkerService.upLinkerChangeStatus(entity.getLinkerId(), SupLinkerEnum.未变更.getCode(), null);
        entity.setReceiveStatus(SupLinkerEnum.已驳回供方.getCode());
        String s = pushBill(entity);
        if (StringUtils.isNotBlank(s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate(entity, false);
        LinkerChangeVO vo = BeanMapper.map(entity, LinkerChangeVO.class);
        return CommonResponse.success("驳回成功！", vo);
    }

    @Override
    public CommonResponse<LinkerChangeVO> saveOrUpdate(LinkerChangeVO saveOrUpdateVO) {
        LinkerChangeEntity entity = BeanMapper.map(saveOrUpdateVO, LinkerChangeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
            boolean b = linkerService.linkerChangeStatus(entity.getLinkerId(), entity.getId());
            if (b){
                return CommonResponse.error("当前联系人正在变更中，请稍后重试！");
            }
        }
        super.saveOrUpdate(entity, false);

        LinkerChangeVO changeVO = queryDetail(entity.getId());
        return CommonResponse.success("保存或修改单据成功！", changeVO);
    }


    @Override
    public String pushBill(LinkerChangeEntity entity) {
        //推送当前单据

        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "物资联系人变更推送供应链平台失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(entity));
            logger.info("物资联系人变更推送供应链平台: url-{}, 物资联系人变更：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), null);
            logger.error("物资联系人变更推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("物资联系人变更id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "物资联系人变更推送供应链平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("物资联系人变更id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "物资联系人变更推送供应链平台失败";
            }
        } catch (Exception e) {
            logger.error("物资联系人变更id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，物资联系人变更推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}
