package com.ejianc.business.zdssupplier.sub.service.impl;

import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdssupplier.sub.mapper.LinkerInviteFlowMapper;
import com.ejianc.business.zdssupplier.sub.bean.LinkerInviteFlowEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteFlowService;

import java.util.Date;

/**
 * 分包联系人邀请流水
 * 
 * @author generator
 * 
 */
@Service("linkerInviteFlowService")
public class LinkerInviteFlowServiceImpl extends BaseServiceImpl<LinkerInviteFlowMapper, LinkerInviteFlowEntity> implements ILinkerInviteFlowService{

    @Autowired
    private SessionManager sessionManager;

    @Override
    public LinkerInviteFlowVO saveOrUpdate(LinkerInviteFlowVO saveOrUpdateVO) {
        LinkerInviteFlowEntity entity = BeanMapper.map(saveOrUpdateVO, LinkerInviteFlowEntity.class);
        UserContext user = sessionManager.getUserContext();
        entity.setOperatorId(user.getUserId());
        entity.setOperatorCode(user.getUserCode());
        entity.setOperatorName(user.getUserName());
        entity.setOperatorPhone(user.getUserMobile());
        entity.setOperateTime(new Date());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, LinkerInviteFlowVO.class);
    }
}
