package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.mapper.LinkerMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包联系人档案
 * 
 * @author generator
 * 
 */
@Service("linkerService")
public class LinkerServiceImpl extends BaseServiceImpl<LinkerMapper, LinkerEntity> implements ILinkerService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_SUB_LINKER";//此处需要根据实际修改
    private static final String CHANGE_BILL_TYPE = "EJCBT202403000017";//此处需要根据实际修改
    private static final String SOURCE_TYPE_ONE = "legalPersonFile";//此处需要根据实际修改
    private static final String SOURCE_TYPE_TWO = "agentFile";//此处需要根据实际修改
    private static final String LINKER_BILL_TYPE = "EJCBT202403000015";//此处需要根据实际修改

    @Value("${file.openDownUrl}")
    private String openDownUrl;// 项目方下载附件地址
    @Autowired
    private CoordinationUtil coordinationUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private LinkerMapper linkerMapper;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO) {
        return saveOrUpdate(saveOrUpdateVO, "true", true);
    }

    @Override
    public LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO, String checkFlag, boolean cooFlag) {
        LinkerEntity entity = BeanMapper.map(saveOrUpdateVO, LinkerEntity.class);

        SupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        // 联系人校验
        supplier.getLinkerList().add(entity);
        if(!"false".equals(checkFlag)) {
            this.validateUnique(supplier.getLinkerList());
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);

//        SupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
        if(cooFlag) {
            if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
                // 供应商未生成协同租户，则先创建协同租户
                supplierService.createSupTenant(supplier);
            }
            if(!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
                // 联系人未生成协同账号，则先创建协同账号
                this.createSupAccount(entity, supplier.getTenant());
            }
        }

        return BeanMapper.map(entity, LinkerVO.class);
    }

    @Override
    public void generateAccount(Long linkerId) {
        LinkerEntity linker = super.selectById(linkerId);
        SupplierEntity supplier = supplierService.selectById(linker.getSupplierId());

        if(!PlanConstant.STRING_YES.equals(supplier.getCoordination())) {
            supplierService.createSupTenant(supplier);
        }

        if(!PlanConstant.STRING_YES.equals(linker.getCoordination())) {
            if(StringUtils.isBlank(linker.getMobileLinkPhone())) {
                throw new BusinessException("联系人电话为空");
            }
            Map<String, String> reqParam = new HashMap<>();
            reqParam.put("linkMobile", linker.getMobileLinkPhone());
            reqParam.put("linkName", linker.getName());
            reqParam.put("linkSupType", PlanConstant.SUB_SUPPLIER);
            reqParam.put("supplierAccRole", PlanConstant.分包联系人);
            reqParam.put("supplierTenantId", supplier.getTenant().toString());
            reqParam.put("accRoleCheck", Boolean.TRUE.toString());
            reqParam.put("supplierId", linker.getSupplierId().toString());
            reqParam.put("billId", linker.getId().toString());

            // 联系人生成协同账号
            JSONObject resp = coordinationUtil.createSupAccount(reqParam);

            // 发送邮件和短信
            JSONObject entity = new JSONObject();
            entity.put("linkPhone", linker.getMobileLinkPhone());
            entity.put("linkerName", linker.getName());
            entity.put("linkEmail", linker.getElectronicMail());
            entity.put("supplierName", linker.getSupplierName());
            coordinationUtil.sendApproveSms(entity);
            coordinationUtil.sendApproveEmail(entity);

            linker.setEnableStatus(PlanConstant.INTEGER_YES);
            linker.setCoordination(PlanConstant.STRING_YES);
            linker.setTenant(resp.getLong("tenantId"));
            linker.setSupUserId(resp.getLong("userId"));
            super.saveOrUpdate(linker, false);
        }


    }

    @Override
    public List<LinkerVO> getBySourceIds(List<String> sourceIds) {
        List<LinkerVO> resp = new ArrayList<>();
        QueryWrapper<LinkerEntity> query = new QueryWrapper<>();
        query.in("third_source_id", sourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", BaseVO.DR_UNDELETE);
        List<LinkerEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, LinkerVO.class);
        }
        return resp;
    }

    @Override
    public LinkerVO getByMobileLinkPhone(String mobileLinkPhone) {
        QueryWrapper<LinkerEntity> query = new QueryWrapper<>();
        query.eq("mobile_link_phone", mobileLinkPhone);
        query.eq("coordination", 1);
        query.eq("date_type", BaseVO.DR_UNDELETE);
//        query.eq("enable_status", 1);
//        query.eq("enable_status", 1);
//        query.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<LinkerEntity> list = super.list(query);
        if (CollectionUtils.isNotEmpty(list)){
            return BeanMapper.map(list.get(0), LinkerVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<LinkerVO> queryDetailBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String supUserId = jsonObject.getString("supUserId");
        Long supTenant =jsonObject.getLong("supTenant");
        QueryWrapper<LinkerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sup_user_id", supUserId);
        queryWrapper.eq("date_type", 0);
        if(null != supTenant) {
            queryWrapper.eq("tenant", supTenant);
        }

        if (jsonObject.containsKey("changeVersion")){
            Integer changeVersion = jsonObject.getInteger("changeVersion");
            if (changeVersion>1){
                queryWrapper.eq("change_version", changeVersion-1);
                List<LinkerEntity> list = super.list(queryWrapper);
                if (list.size() == 0) {
                    return CommonResponse.error("未查询到单据！");
                }
                LinkerVO vo = BeanMapper.map(list.get(0), LinkerVO.class);
                return CommonResponse.success("查询详情数据成功！", vo);
            }
        }
        List<LinkerEntity> list = super.list(queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error("未查询到单据！");
        }
        LinkerEntity supplierEntity = list.get(0);
        LinkerVO vo = BeanMapper.map(supplierEntity, LinkerVO.class);
        List<Long> fileIds = new ArrayList<>();
        if(vo.getUserType()==1) {
            if(StringUtils.isNotBlank(vo.getLegalPersonFileId())) {
                fileIds.add(Long.valueOf(vo.getLegalPersonFileId()));
            }
        } else {
            if(StringUtils.isNotBlank(vo.getAgencyFileId())) {
                fileIds.add(Long.valueOf(vo.getAgencyFileId()));
            }
            if(StringUtils.isNotBlank(vo.getCertifyFileId())) {
                fileIds.add(Long.valueOf(vo.getCertifyFileId()));
            }
        }
        if (CollectionUtils.isNotEmpty(fileIds)) {
            CommonResponse<List<AttachmentVO>> attachmentVOCommonResponse = attachmentApi.queryAllByIds(fileIds);
            if (!attachmentVOCommonResponse.isSuccess()){
                throw new BusinessException("网络异常， 附件查询失败， 请稍后再试");
            }
            if (attachmentVOCommonResponse.getData()==null){
                throw new BusinessException("网络异常， 附件查询为空， 请稍后再试");
            }
            List<AttachmentVO> attachmentVos =  attachmentVOCommonResponse.getData();
            List<String> filePathList = new ArrayList<>();
            List<Long> newFileIds = new ArrayList<>();
            for(AttachmentVO attachmentVo : attachmentVos) {
                filePathList.add(openDownUrl+attachmentVo.getFilePath());
                newFileIds.add(attachmentVo.getId());
            }
            vo.setFilePathList(filePathList);
            vo.setNewFileIds(newFileIds);
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryNoAuthListBySourceId(vo.getId(), null, null, null);
        if (fileResp.isSuccess()) {
            vo.setFileList(fileResp.getData());
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @Override
    public LinkerVO createSupAccount(LinkerEntity linker, Long supTenantId) {
        if(StringUtils.isBlank(linker.getMobileLinkPhone())) {
            throw new BusinessException("联系人电话为空");
        }
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("linkMobile", linker.getMobileLinkPhone());
        reqParam.put("linkName", linker.getName());
        reqParam.put("linkSupType", PlanConstant.SUB_SUPPLIER);
        reqParam.put("supplierAccRole", PlanConstant.分包联系人);
        reqParam.put("supplierTenantId", supTenantId.toString());
        reqParam.put("accRoleCheck", Boolean.TRUE.toString());
        reqParam.put("supplierId", linker.getSupplierId().toString());
        reqParam.put("billId", linker.getId().toString());

        // 联系人生成协同账号
        JSONObject resp = coordinationUtil.createSupAccount(reqParam);

        // 发送邮件和短信
        JSONObject entity = new JSONObject();
        entity.put("linkPhone", linker.getMobileLinkPhone());
        entity.put("linkerName", linker.getName());
        entity.put("linkEmail", linker.getElectronicMail());
        entity.put("supplierName", linker.getSupplierName());
        coordinationUtil.sendApproveSms(entity);
        coordinationUtil.sendApproveEmail(entity);

        linker.setEnableStatus(PlanConstant.INTEGER_YES);
        linker.setCoordination(PlanConstant.STRING_YES);
        linker.setTenant(resp.getLong("tenantId"));
        linker.setSupUserId(resp.getLong("userId"));
        super.saveOrUpdate(linker, false);
        return BeanMapper.map(linker, LinkerVO.class);
    }

    @Override
    public LinkerVO getBySupUserId(Long linkerSupUserId, Long supplierId) {
        LinkerVO resp = null;

        QueryWrapper<LinkerEntity> query = new QueryWrapper<>();
        query.eq("sup_user_id", linkerSupUserId);
        query.eq("supplier_id", supplierId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", BaseVO.DR_UNDELETE);
        LinkerEntity e = super.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, LinkerVO.class);
        }

        return resp;
    }

    @Override
    public LinkerVO getSupUserIdAndTenant(Long supUserId, Long tenantId) {
        LinkerVO resp = null;

        QueryWrapper<LinkerEntity> query = new QueryWrapper<>();
        query.eq("sup_user_id", supUserId);
        query.eq("tenant", tenantId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", BaseVO.DR_UNDELETE);
        LinkerEntity e = super.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, LinkerVO.class);
        }

        return resp;
    }

    @Override
    public boolean linkerChangeStatus(Long linkerId, Long changeId) {
        LinkerEntity linker =  super.selectById(linkerId);
        if (null!=linker.getChangeStatus()&&linker.getChangeStatus().equals(SupLinkerEnum.变更中.getCode())){
            return true;
        }
        linker.setChangeId(changeId);
        linker.setChangeStatus(Integer.valueOf(SupLinkerEnum.变更中.getCode()));
        super.saveOrUpdate(linker,false);
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void upLinkerChangeStatus(Long linkerId, Integer changeStatus, LinkerChangeEntity entity) {
        LinkerEntity linkerEntity = super.selectById(linkerId);
        Integer userType = linkerEntity.getUserType();
        linkerEntity.setChangeStatus(changeStatus);
        LinkerEntity oldEntity = null;
        if (null!=entity){
            oldEntity = BeanMapper.map(linkerEntity, LinkerEntity.class);
            oldEntity.setId(null);
            oldEntity.setDateType(1);
            oldEntity.setMainLinkerId(linkerId);
            oldEntity.setVersion(null);
            oldEntity.setCreateTime(null);
            oldEntity.setChangeVersion(entity.getChangeVersion());
            oldEntity.setAccessId(null);
            oldEntity.setSupplierId(null);
            oldEntity.setDateType(1); //纪录项

            //查询当前供应商下是否存在 法人的单据
            if ("1".equals(entity.getUserType())){
                QueryWrapper<LinkerEntity> query = new QueryWrapper<>();
                query.eq("user_type",1);
                query.ne("id",linkerId);
                query.eq("supplier_id",linkerEntity.getSupplierId());
                query.eq("date_type", BaseVO.DR_UNDELETE);
                int count = super.count(query);
                if (count>0){
                    throw new BusinessException("该供应商下已存在法定代表人，无法变更！");
                }
            }
            if (!entity.getMobileLinkPhone().equals(linkerEntity.getMobileLinkPhone())){
                QueryWrapper<LinkerEntity> queryWrapper =  new QueryWrapper<>();
                queryWrapper.eq("mobile_link_phone",entity.getMobileLinkPhone());
                queryWrapper.eq("enable_status", 1);
                queryWrapper.ne("id",linkerId);
                List<LinkerEntity> list = super.list(queryWrapper);
                if(CollectionUtils.isNotEmpty(list)){
                    LinkerEntity matLinkerEntity = list.get(0);
                    if (!entity.getIdCardId().equals(matLinkerEntity.getIdCardId())){
                        throw new BusinessException("该手机号已被使用，无法变更！");
                    }
                }
            }
            linkerEntity.setMobileLinkPhone(entity.getMobileLinkPhone());
            linkerEntity.setElectronicMail(entity.getElectronicMail());
            linkerEntity.setAddress(entity.getAddress());
            boolean fileChange = true;
            if (String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                if (userType==1){
                    if (null != entity.getLegalPersonFileId()){
                        fileChange = true;
                    }
                }else {
                    if (null != entity.getAgencyFileId()){
                        fileChange = true;
                    }
                    if (null != entity.getCertifyFileId()) {
                        fileChange = true;
                    }
                }
            } else {
                fileChange = true;
            }

            if (fileChange){
                List<Long> delFileIds = new ArrayList<>();
                if(Integer.valueOf(1).equals(entity.getUserType())) {
                    //删除掉变更的资质源文件
                    if(StringUtils.isNotBlank(linkerEntity.getLegalPersonFileId())) {
                        delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                        if(StringUtils.isNotBlank(linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        if(StringUtils.isNotBlank(linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }
                    }
                    if(StringUtils.isNotBlank(entity.getLegalPersonFileId())) {
                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.分包联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(entity.getLegalPersonFileId()), baseHost);
                        linkerEntity.setLegalPersonFileId(fileId.toString());
                    }
                    linkerEntity.setLegalPersonFileName(linkerEntity.getLegalPersonFileName());
                } else {
                    if(StringUtils.isNotBlank(entity.getAgencyFileId())) {
                        if(StringUtils.isNotBlank(linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.分包联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.AGENT_SOURCE_TYPE, Long.valueOf(entity.getAgencyFileId()), baseHost);
                        linkerEntity.setAgencyFileId(fileId.toString());
                        linkerEntity.setAgencyFileName(linkerEntity.getAgencyFileName());
                    }
                    if(StringUtils.isNotBlank(entity.getCertifyFileId())) {
                        if(StringUtils.isNotBlank(linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }

                        Long fileId = pushSupUtil.uploadFileFormNet(BillTypeEnum.分包联系人档案.getCode(), linkerEntity.getId(),
                                PlanConstant.CERTIFY_SOURCE_TYPE, Long.valueOf(entity.getCertifyFileId()), baseHost);
                        linkerEntity.setCertifyFileId(fileId.toString());
                        linkerEntity.setCertifyFileName(linkerEntity.getAgencyFileName());
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))){
                        if(StringUtils.isNotBlank(linkerEntity.getLegalPersonFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                        }
                    }
                }

                if(CollectionUtils.isNotEmpty(delFileIds)) {
                    //联系人文件改为记录的文件
                    oldEntity.setAttachIds(delFileIds);
                }
            }
            linkerEntity.setUserType(entity.getUserType());

            if(StringUtils.isNotBlank(entity.getUserName())) {
                linkerEntity.setName(entity.getUserName());
                linkerEntity.setUserName(entity.getUserName());
            }
            if(null != entity.getLinkerStatus()) {
                linkerEntity.setLinkerStatus(entity.getLinkerStatus());
            }
        }

        if(null != oldEntity) {
            logger.info("联系人记录:{}", JSONObject.toJSONString(oldEntity, SerializerFeature.PrettyFormat));
            super.saveOrUpdate(oldEntity);
        }
        logger.info("变更后联系人档案：{}", JSONObject.toJSONString(linkerEntity, SerializerFeature.PrettyFormat));
        super.saveOrUpdate(linkerEntity,false);
    }

    @Override
    public void deleteChange(List<Long> linkerId) {
        UpdateWrapper<LinkerEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("id",linkerId);
        updateWrapper.set("change_status",SupLinkerEnum.未变更.getCode());
        updateWrapper.set("change_id",null);
        super.update(updateWrapper);
    }

    @Override
    public Boolean validateUnique(LinkerEntity linker, Long id) {
        // 同一供应商下联系人不能重复
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, linker.getMobileLinkPhone()));
//        if(null != linker.getSupplierId()) {
//            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, linker.getSupplierId()));
//        } else if(null != linker.getAccessId()) {
//            param.getParams().put("accessId", new Parameter(QueryParam.EQ, linker.getAccessId()));
//        }
        param.getParams().put("enableStatus", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_NO));
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<LinkerEntity> linkerList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(linkerList)){
            logger.error("该联系人的手机号{}已生成档案【{}】，不允许重复生成！", linker.getMobileLinkPhone(), linkerList.get(0).getId());
            throw new BusinessException("联系人[名称："+linker.getName()+"，手机号："+linker.getMobileLinkPhone()+"]已生成档案，不允许重复生成！");
        }
        return true;
    }

    @Override
    public Boolean validateUnique(List<LinkerEntity> linkerList) {
        linkerList = linkerList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        Integer legalNum = (int) linkerList.stream().filter(x->PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
        if(legalNum > 1){
            throw new BusinessException("联系人类型为法定代表人最多只能有一条！");
        }
        for(LinkerEntity linker : linkerList){
            // 校验手机号唯一性
            this.validateUnique(linker, linker.getId());
        }
        return true;
    }

    @Override
    public List<LinkerEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<LinkerEntity> query  = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("date_type", 0);
        query.in("supplier_id", supplierIds);

        return super.list(query);
    }

    @Override
    public List<Map<String, Object>> getLinkerCreatorInf(List<Long> linkerIds) {
        return linkerMapper.getLinkerCreatorInf(linkerIds);
    }

    @Override
    public void validateUnique(String name, String mobileLinkPhone) {
        // 同一供应商下联系人不能重复
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter(QueryParam.EQ, mobileLinkPhone));
        param.getParams().put("enableStatus", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_NO));
        List<LinkerEntity> linkerList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(linkerList)){
            logger.error("该联系人的手机号{}已生成档案【{}】，不允许重复生成！", mobileLinkPhone, linkerList.get(0).getId());
            throw new BusinessException("联系人[名称："+name+"，手机号："+mobileLinkPhone+"]已生成档案，不允许重复生成！");
        }
    }
}
