package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.consumer.TransferVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierAccessMapper;
import com.ejianc.business.zdssupplier.sub.service.*;
import com.ejianc.business.zdssupplier.sub.vo.SupplierAccessVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包供应商准入
 * 
 * @author generator
 * 
 */
@Service("supplierAccessService")
public class SupplierAccessServiceImpl extends BaseServiceImpl<SupplierAccessMapper, SupplierAccessEntity> implements ISupplierAccessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = BillTypeEnum.分包供应商准入.getCode();
    private static final String BILL_NAME = BillTypeEnum.分包供应商准入.getName();
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_ACCESS";//此处需要根据实际修改
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierAccess/syncDetailBill";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISupplierInviteService inviteService;

    @Autowired
    private ISupplierAccessCertificateService certService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private ILinkerAccessService linkerService;

    @Override
    public SupplierAccessVO saveOrUpdate(SupplierAccessVO saveOrUpdateVO) {
        SupplierAccessEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierAccessEntity.class);

//        // 校验统一社会信用代码唯一性
//        this.validateUnique(entity.getSocialCreditCode(), entity.getLinkerList(), entity.getId());
//
//        if(CollectionUtils.isEmpty(entity.getLinkerList())){
//            throw new BusinessException("请添加至少一条联系人！");
//        }
//        if(CollectionUtils.isEmpty(entity.getBankList())){
//            throw new BusinessException("请添加至少一条银行信息！");
//        }
//
//        // 校验附件必输性
//        for(SupplierAccessAttachesEntity attach : entity.getAttachesList()){
//            if(PlanConstant.subAttachNameMap.containsKey(attach.getFileType()) &&
//                    PlanConstant.subAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//                throw new BusinessException(attach.getFileType() + "未上传附件，请上传后保存！");
//            }
//        }
        // 联系人校验
        linkerService.validateUnique(entity.getLinkerList());

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            // 待注册，默认邀请人为当前登录人
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(sessionManager.getUserContext().getUserName());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, SupplierAccessVO.class);
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        SupplierAccessEntity saveEntity = JSONObject.parseObject(transData, SupplierAccessEntity.class);
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter(QueryParam.EQ, saveEntity.getInviteId()));
        List<SupplierAccessEntity> list = super.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该邀请链接已生成准入，不允许重复生成！");
        }

//        // 校验统一社会信用代码唯一性
//        List<LinkerAccessEntity> linkerList = BeanMapper.mapList(saveEntity.getJSONArray("linkerList"), LinkerAccessEntity.class);
//        this.validateUnique(saveEntity.getString("socialCreditCode"), linkerList, null);
//
//        if(CollectionUtils.isEmpty(saveEntity.getJSONArray("linkerList"))){
//            throw new BusinessException("请添加至少一条联系人！");
//        }
//        if(CollectionUtils.isEmpty(saveEntity.getJSONArray("bankList"))){
//            throw new BusinessException("请添加至少一条银行信息！");
//        }
//
//        // 校验附件必输性
//        for(Object obj : saveEntity.getJSONArray("attachesList")){
//            JSONObject attach = (JSONObject) obj;
//            String fileType = attach.getString("fileType");
//            if(PlanConstant.subAttachNameMap.containsKey(fileType) &&
//                    PlanConstant.subAttachNameMap.get(fileType) && null == attach.getString("fileId")){
//                throw new BusinessException(fileType + "未上传附件，请上传后保存！");
//            }
//        }

        // 联系人校验
        linkerService.validateUnique(saveEntity.getLinkerList());

        Long id = pushSupUtil.saveSyncBill(request, SupplierAccessEntity.class, BILL_TYPE, BILL_NAME);
        if(null == id) {
            throw new BusinessException("同步数据异常！");
        }
        SupplierAccessEntity entity = super.selectById(id);
        // 生成单据编码
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        // MQ同步文件
        List<LinkerAccessEntity> likerList = entity.getLinkerList();
        List<SupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        List<SupplierAccessCertificateEntity> certList = entity.getCertificateList();
        for(LinkerAccessEntity liker : likerList){
            Long fileId = null;
            List<Long> attachIds = new ArrayList<>();
            if(liker.getUserType() == 2){
                fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.AGENT_SOURCE_TYPE, Long.valueOf(liker.getAgencyFileId()));
                liker.setAgencyFileId(fileId.toString());
                attachIds.add(fileId);
                Long certifyFileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.CERTIFY_SOURCE_TYPE, Long.valueOf(liker.getCertifyFileId()));
                liker.setCertifyFileId(certifyFileId.toString());
                attachIds.add(certifyFileId);
            } else {
                fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, liker.getId(), PlanConstant.LEGAL_PERSON_SOURCE_TYPE, Long.valueOf(liker.getLegalPersonFileId()));
                liker.setLegalPersonFileId(fileId.toString());
                attachIds.add(fileId);
            }
            liker.setAttachIds(attachIds);
        }
        for(SupplierAccessAttachesEntity attach : attachList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), PlanConstant.FILE_SOURCE_TYPE, attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        for(SupplierAccessCertificateEntity cert : certList){
            Long fileId = pushSupUtil.uploadFileFormNet(BILL_TYPE, cert.getId(), PlanConstant.CERT_SOURCE_TYPE, cert.getCertificateFileId());
            cert.setCertificateFileId(fileId);
            cert.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate(entity, false);
        // 修改邀请状态并生成流水
        SupplierInviteVO inviteVO = new SupplierInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus(PlanConstant.INVITE_STATUS_AFFIRM);
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public SupplierAccessVO TYCDetail(String supplierName, Long id) {
        if(StringUtils.isEmpty(supplierName)){
            throw new BusinessException("企业名称不能为空！");
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, supplierName));
//        queryParam.getOrderMap().put("invokeDate", QueryParam.DESC);
//        List<SupplierAccessEntity> dataList = super.queryList(queryParam);
//        if(CollectionUtils.isNotEmpty(dataList)){
//            Date invokeDate = dataList.get(0).getInvokeDate();
//            if(invokeDate != null && DateUtil.compareDate(DateUtil.addDays(DateUtil.beginOfDate(invokeDate), 1), new Date()) > 0){
//                throw new BusinessException("一个企业名称当天只能调用一次天眼查，请明天再试！");
//            }
//        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company){
            return new SupplierAccessVO();
        }
        SupplierAccessEntity entity = null;
        if(id != null){
            entity = super.selectById(id);
        }
        if(entity == null){
            entity = new SupplierAccessEntity();
            // 生成单据编码
            entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
            // 待注册，默认邀请人为当前登录人
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(sessionManager.getUserContext().getUserName());
            entity.setCompanyGrade("临时");
            entity.setCompanyState("正常");
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(StringUtils.isNotEmpty(company.getPaidCapitalStr())?company.getPaidCapitalStr():"-");
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List<BaseCertificateVO> certList = company.getCertiList();
        // 资质列表处理
        List<SupplierAccessCertificateEntity> addList = this.transferCertList(certList, entity.getId());
        if (CollectionUtils.isNotEmpty(addList)){
            entity.setCertificateList(addList);
        }
        // 默认附件
        List<SupplierAccessAttachesEntity> attachList = entity.getAttachesList();
        if(attachList.stream().noneMatch(x->PlanConstant.subAttachNameMap.keySet().contains(x.getFileType()))){
            for(String name : PlanConstant.subAttachNameMap.keySet()){
                SupplierAccessAttachesEntity vo = new SupplierAccessAttachesEntity();
                vo.setFileType(name);
                vo.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
                attachList.add(vo);
            }
        }
        super.saveOrUpdate(entity, false);
        SupplierAccessVO vo = BeanMapper.map(entity, SupplierAccessVO.class);
        return vo;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id) {
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SupplierAccessEntity> accessList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(accessList)){
            throw new BusinessException("该供应商的统一社会信用代码已生成准入【" + accessList.get(0).getCode() + "】，不允许重复准入！");
        }
        // 校验统一社会信用代码唯一性
        supplierService.validateUnique(name, socialCreditCode, null, "准入");
        return true;
    }

    @Override
    public SupplierAccessVO syncDetailBill(Long inviteId) {
        SupplierAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if(null == entity.getId()){
            // 不存在准入，从分供方重新拉取
            Map<String, String> params = new HashMap<>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()){
                CommonResponse<String> resp = JSONObject.parseObject(response.getData(), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf(resp.getData()));
            }else {
                throw new BusinessException(response.getMsg());
            }
        }
        return BeanMapper.map(entity, SupplierAccessVO.class);
    }

    /**
     * 根据邀请链接id查询准入
     * @param inviteId
     * @return
     */
    private SupplierAccessEntity getEntityByInviteId(Long inviteId, Long sourceId){
        QueryParam queryParam = new QueryParam();
        if(sourceId != null){
            queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter(QueryParam.EQ, inviteId));
        }
        List<SupplierAccessEntity> list = super.queryList(queryParam);
        SupplierAccessEntity entity = new SupplierAccessEntity();
        if(CollectionUtils.isNotEmpty(list)){
            entity = super.selectById(list.get(0).getId());
        }
        return entity;
    }

    /**
     * 资质列表处理
     * @param certList
     * @param accessId
     * @return
     */
    private List<SupplierAccessCertificateEntity> transferCertList(List<BaseCertificateVO> certList, Long accessId) {
        if (CollectionUtils.isEmpty(certList)) {
            return new ArrayList<>();
        }
        // 资质信息 先查询 根据证书校验
        Map<String, SupplierAccessCertificateEntity> certMap = new HashMap<>();
        if(accessId != null){
            QueryParam param = new QueryParam();
            param.getParams().put("accessId", new Parameter(QueryParam.EQ, accessId));
            List<SupplierAccessCertificateEntity> list = certService.queryList(param);
            certMap = list.stream().collect(Collectors.toMap(e -> e.getCertificateTypeName() + "|" + e.getCertificateNumber(), x -> x, (v1, v2)->v2));
        }
        // 资质等级参照翻译
        Map<String, DefdocDetailVO> defMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(824965747632509009L);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            defMap = resp.getData().stream().collect(Collectors.toMap(x->x.getName(), x->x, (v1, v2)->v2));
        }
        List<SupplierAccessCertificateEntity> addList = new ArrayList<>();
        for (BaseCertificateVO cert : certList) {
            List<String> names = Arrays.asList(cert.getName().split(","));
            for(String name : names){
                SupplierAccessCertificateEntity vo = new SupplierAccessCertificateEntity();
                if (certMap.containsKey(name + "|" + cert.getCode())){
                    vo = certMap.get(name + "|" + cert.getCode());
                }
                vo.setCertificateTypeName(name);
                if(defMap.containsKey(name)){
                    vo.setCertificateTypeId(defMap.get(name).getId());
                    vo.setCertificateTypeCode(defMap.get(name).getCode());
                } else {
                    continue;
                }
                vo.setCertificateNumber(cert.getCode());
                vo.setPeriodOfValidity(cert.getEndDate());
                vo.setSourceType(2);
                addList.add(vo);
            }
        }
        return addList;
    }
}
