package com.ejianc.business.zdssupplier.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAttachesEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierAttachesMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAttachesService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分包供应商档案-附件信息
 * 
 * @author generator
 * 
 */
@Service("supplierAttachesService")
public class SupplierAttachesServiceImpl extends BaseServiceImpl<SupplierAttachesMapper, SupplierAttachesEntity> implements ISupplierAttachesService {

    @Override
    public List<SupplierAttachesEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<SupplierAttachesEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
