package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierCertificateMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierCertificateService;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包供应商档案-资质信息
 * 
 * @author generator
 * 
 */
@Service("supplierCertificateService")
public class SupplierCertificateServiceImpl extends BaseServiceImpl<SupplierCertificateMapper, SupplierCertificateEntity> implements ISupplierCertificateService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String CERT_TYPE_DEF_CODE = "zds-certi-category";

    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public List<SupplierCertificateEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<SupplierCertificateEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public Map<String, DefdocDetailVO> getAllCertTypeByCertTypeSid(List<String> certTypeSid) {
        Map<String, DefdocDetailVO> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(certTypeSid)) {
            //根据资质证书类别SId查询
            CommonResponse<List<DefdocDetailVO>> certTypeResp = defdocApi.queryDetailListByDefdocCodeList(new ArrayList<>(certTypeSid));
            if(!certTypeResp.isSuccess() || CollectionUtils.isEmpty(certTypeResp.getData())) {
                logger.error("根据资质类别SId-{}查询失败",
                        JSONObject.toJSONString(certTypeSid), JSONObject.toJSONString(certTypeResp, SerializerFeature.PrettyFormat));
            } else {
                resp.putAll(certTypeResp.getData().stream().collect(Collectors.toMap(item -> item.getCode(), item -> item)));
            }
        }
        return resp;
    }

    @Override
    public Map<String, DefdocDetailVO> getAllCertTypeByCertTypeName(List<String> certTypeName) {
        Map<String, DefdocDetailVO> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(certTypeName)) {
            CommonResponse<List<DefdocDetailVO>> certTypeResp = defdocApi.noAuthDetailListByDetailNamesAndDocCode(new ArrayList<>(certTypeName), CERT_TYPE_DEF_CODE);
            if(!certTypeResp.isSuccess() || CollectionUtils.isEmpty(certTypeResp.getData())) {
                logger.error("根据资质类别名称-{}查询失败",
                        JSONObject.toJSONString(certTypeName), JSONObject.toJSONString(certTypeResp, SerializerFeature.PrettyFormat));
            } else {
                resp.putAll(certTypeResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item)));
            }
        }
        return resp;
    }
}
