package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service("supplierChange") 
public class SupplierChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String sourceBillType = BillTypeEnum.分包供应商变更.getCode();
	private static final String targetBillType = BillTypeEnum.分包供应商档案.getCode();

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private ISupplierChangeService service;

	@Autowired
	private ISupplierService supplierService;

	@Autowired
	private ISubTypeManagerService subTypeManagerService;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IZDSSubTypeApi subTypeApi;

	@Autowired
	private IBankService bankService;

	@Autowired
	private IBankCategoryService bankCategoryService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		SupplierChangeEntity entity = service.selectById(billId);

		boolean saveFlag = false;
		//更新发展专业和主导专业的SID
		if(StringUtils.isNotBlank(entity.getDepProfessionId())) {
			//发展专业id不为空
			CommonResponse<List<SubTypeVO>> subTypeResp = subTypeApi.getAllByIds(Arrays.stream(entity.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
			if(!subTypeResp.isSuccess() || CollectionUtils.isEmpty(subTypeResp.getData())) {
				logger.error("分包商变更信息推送ERP失败，查询主键为：{}的分包类型失败: {}", entity.getDepProfessionId(), JSONObject.toJSONString(subTypeResp, SerializerFeature.PrettyFormat));
			} else {
				saveFlag = true;
				entity.setDepProfessionSid(subTypeResp.getData().stream().map(SubTypeVO::getSourceId).collect(Collectors.joining(",")));
			}
		}

		Date invokeDate = entity.getInvokeDate();
		if(null == invokeDate || DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0){
			return CommonResponse.error("距离上一次调用天眼查时间已超过15天，请更新后操作！");
		}

		if (CollectionUtil.isEmpty(entity.getManagerList())){
			return CommonResponse.error("项目经理至少添加一项!");
		}

		JSONArray resp = service.getSupplierApprList(entity);
		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，该分包商的发展专业或主导专业未设置审核人！");
		}

		// 校验
		this.validate(entity);
		if(saveFlag) {
			service.saveOrUpdate(entity, false);
		}
		return CommonResponse.success();
	};

	/**
	 * 校验
	 * @param entity
	 */
	private void validate(SupplierChangeEntity entity) {
		// 校验统一社会信用代码唯一性
		supplierService.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getSupplierId(), "变更");

		// 校验是否有在途单据
		service.validateRunning(entity.getSupplierId(), entity.getId());

		if(CollectionUtils.isEmpty(entity.getBankList())){
			throw new BusinessException("请添加至少一条银行信息！");
		}

		// 校验附件必输性
//		for(SupplierChangeAttachesEntity attach : entity.getAttachesList()){
//			if(PlanConstant.subAttachNameMap.containsKey(attach.getFileType()) &&
//					PlanConstant.subAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//				throw new BusinessException(attach.getFileType() + "未上传附件，请上传并保存后提交！");
//			}
//		}
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		SupplierChangeEntity entity = service.selectById(billId);
		// 修改变更状态并生成流水
		SupplierChangeVO vo = new SupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_COMMIT);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		SupplierChangeEntity entity = service.selectById(billId);
		// 修改变更状态并生成流水
		SupplierChangeVO vo = new SupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_AFFIRM);
		vo.setFlowType(PlanConstant.FLOW_TYPE_APPROVE_BACK);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplierChangeEntity entity = service.selectById(billId);
		// 校验
		this.validate(entity);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SupplierChangeEntity entity = service.selectById(billId);
//		// 生成历史
//		service.pushToHistory(entity.getSupplierId(), entity.getId());
		// 同步档案
		this.pushToArchive(entity);

		UserContext user = sessionManager.getUserContext();

		//推送ERP
		String msg = supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), null,
				PlanConstant.供应商变更同步ERP, billId, true, user.getUserId(), user.getUserName()));
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException(msg);
		}

		// 修改变更状态并生成流水
		SupplierChangeVO vo = new SupplierChangeVO();
		vo.setId(entity.getId());
		vo.setSourceType(entity.getSourceType());
		vo.setStatus(PlanConstant.CHANGE_STATUS_APPROVE);
		service.updateBillStatus(vo);
		return CommonResponse.success();
	}

	/**
	 * 同步档案
	 * @param entity
	 */
	@Transactional(rollbackFor = Exception.class)
	public Boolean pushToArchive(SupplierChangeEntity entity) {
		SupplierEntity supplier = supplierService.selectById(entity.getSupplierId());
		// 将变更数据同步到档案
		SupplierEntity saveEntity = EntityUtil.transformFileds(supplier, entity);
		saveEntity.setSourceType("3");// 来源变更
		// 保留数据
		saveEntity.setCode(supplier.getCode());
		saveEntity.setBillState(supplier.getBillState());
		saveEntity.setThirdSourceId(supplier.getThirdSourceId());
		saveEntity.setTenant(supplier.getTenant());
		saveEntity.setTenantName(supplier.getTenantName());
		saveEntity.setCoordination(supplier.getCoordination());
		saveEntity.setCorpSid(supplier.getCorpSid());
		saveEntity.setCorpErpName(supplier.getCorpErpName());
		saveEntity.setAffiliatedCompanySid(supplier.getAffiliatedCompanySid());
		saveEntity.setMajorSid(supplier.getMajorSid());
		if(StringUtils.isNotBlank(entity.getDepProfessionSid())) {
			saveEntity.setDepProfessionSid(entity.getDepProfessionSid());
		} else {
			saveEntity.setDepProfessionSid(supplier.getDepProfessionSid());
		}
		saveEntity.setDepProfessionName(supplier.getDepProfessionName());
		saveEntity.setDepProfessionId(saveEntity.getDepProfessionId());
		saveEntity.setLinkerList(supplier.getLinkerList());
		if(StringUtils.isNotBlank(supplier.getErpType())) {
			saveEntity.setErpType(supplier.getErpType());
		}
		if(StringUtils.isNotBlank(supplier.getCorpErpName())) {
			saveEntity.setCorpErpName(supplier.getCorpErpName());
		}
		if(StringUtils.isNotBlank(supplier.getErpCreatorSid())) {
			saveEntity.setErpCreatorSid(supplier.getErpCreatorSid());
		}
		if(StringUtils.isNotBlank(supplier.getSysLastUpd())) {
			saveEntity.setSysLastUpd(supplier.getSysLastUpd());
		}
		if(StringUtils.isNotBlank(supplier.getErpRegisterName())) {
			saveEntity.setErpRegisterName(supplier.getErpRegisterName());
		}

		if(StringUtils.isNotBlank(entity.getAffiliatedCompany())) {
			//关联公司不为空
			String[] supplierIdsStrArr = entity.getAffiliatedCompany().split(",");
			List<Long> supplierIds = Arrays.stream(entity.getAffiliatedCompany().split(","))
					.map(item -> Long.valueOf(item)).collect(Collectors.toList());
			List<SupplierEntity> supplierList = supplierService.getAllByIds(supplierIds);
			Map<String, SupplierEntity> supplierIdMap = supplierList.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
			List<String> nameList = new ArrayList<>();
			List<String> sidList = new ArrayList<>();
			for(String supplierIdStr : supplierIdsStrArr) {
				if(supplierIdMap.containsKey(supplierIdStr)) {
					nameList.add(supplierIdMap.get(supplierIdStr).getName());
					sidList.add(supplierIdMap.get(supplierIdStr).getThirdSourceId());
				}
			}
			if(CollectionUtils.isNotEmpty(sidList)) {
				saveEntity.setAffiliatedCompanyName(StringUtils.join(nameList, ","));
			}
			if(CollectionUtils.isNotEmpty(sidList)) {
				saveEntity.setAffiliatedCompanySid(StringUtils.join(sidList, ","));
			}
		}

		//银行sid处理
		if(CollectionUtils.isNotEmpty(supplier.getBankList())) {
			Map<Long, SupplierBankEntity> bankMap =
					supplier.getBankList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getBankList())) {
				Map<String, BankEntity> bankNameMap =
						bankService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getOpenBank()).collect(Collectors.toList()));
				Map<String, BankCategoryEntity> bankCategoryNameMap =
						bankCategoryService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getBankName()).collect(Collectors.toList()));
				saveEntity.getBankList().forEach(bank -> {
					if(bankMap.containsKey(bank.getSourceDetailId())) {
						bank.setBankThirdSourceId(bankMap.get(bank.getSourceDetailId()).getBankThirdSourceId());
						bank.setBankSid(bankMap.get(bank.getSourceDetailId()).getBankSid());
						bank.setBankCategorySid(bankMap.get(bank.getSourceDetailId()).getBankCategorySid());
					}
					if(StringUtils.isNotBlank(bank.getOpenBank()) && bankNameMap.containsKey(bank.getOpenBank())) {
						bank.setBankSid(bankNameMap.get(bank.getOpenBank()).getSourceId());
					}
					if(StringUtils.isNotBlank(bank.getBankName()) && bankCategoryNameMap.containsKey(bank.getBankName())) {
						bank.setBankCategorySid(bankCategoryNameMap.get(bank.getBankName()).getSourceId());
					}
				});
			}
		}
		//附件
		if(CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
			Map<Long, SupplierAttachesEntity> attachMap =
					supplier.getAttachesList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
				saveEntity.getAttachesList().forEach(attach -> {
					if(attachMap.containsKey(attach.getSourceDetailId())) {
						attach.setThirdSourceId(attachMap.get(attach.getSourceDetailId()).getThirdSourceId());
					}
				});
			}
		}
		//资质
		if(CollectionUtils.isNotEmpty(supplier.getCertificateList())) {
			Map<Long, SupplierCertificateEntity> certMap =
					supplier.getCertificateList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
			if(CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
				saveEntity.getCertificateList().forEach(cert -> {
					if(certMap.containsKey(cert.getSourceDetailId())) {
						cert.setThirdSourceId(certMap.get(cert.getSourceDetailId()).getThirdSourceId());
					}
				});
			}
		}
		//项目经理
        if(CollectionUtils.isNotEmpty(saveEntity.getManagerList())) {
            if(CollectionUtils.isNotEmpty(supplier.getManagerList())) {
                Map<Long, SupplierManagerEntity> managerMap =
                        supplier.getManagerList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
                if(CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
                    saveEntity.getManagerList().forEach(manager -> {
                        if(managerMap.containsKey(manager.getSourceDetailId())) {
                            manager.setThirdSourceId(managerMap.get(manager.getSourceDetailId()).getThirdSourceId());
                        }
                    });
                }
            }
        } else {
            saveEntity.setManagerList(supplier.getManagerList());
        }


		supplierService.saveOrUpdate(saveEntity, false);

		// 附件处理
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
				String.valueOf(supplier.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

		Map<Long, SupplierAttachesEntity> attachMap = new HashMap<>();
		for(SupplierAttachesEntity x : supplier.getAttachesList()) {
			attachMap.put(x.getSourceDetailId(), x);
		}
		Map<Long, SupplierCertificateEntity> certMap = new HashMap<>();
		for(SupplierCertificateEntity x : supplier.getCertificateList()) {
			certMap.put(x.getSourceDetailId(), x);
		}
		for(SupplierChangeAttachesEntity source : entity.getAttachesList()){
			if(attachMap.containsKey(source.getId())){
				SupplierAttachesEntity target = attachMap.get(source.getId());
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
						String.valueOf(target.getId()), targetBillType, PlanConstant.FILE_SOURCE_TYPE);
			}
		}
		for(SupplierChangeCertificateEntity source : entity.getCertificateList()){
			if(certMap.containsKey(source.getId())){
				SupplierCertificateEntity target = certMap.get(source.getId());
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, PlanConstant.CERT_SOURCE_TYPE,
						String.valueOf(target.getId()), targetBillType, PlanConstant.CERT_SOURCE_TYPE);
			}
		}

		return true;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}


	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray resp = service.getSupplierApprList(billId);
		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，该分包商的发展专业或主导专业未设置审核人！");
		}
		return CommonResponse.success(resp);
	}

}
