package com.ejianc.business.zdssupplier.sub.service.impl;

import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeFlowEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierChangeFlowMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeFlowService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 分包分包商变更-流水
 * 
 * @author generator
 * 
 */
@Service("supplierChangeFlowService")
public class SupplierChangeFlowServiceImpl extends BaseServiceImpl<SupplierChangeFlowMapper, SupplierChangeFlowEntity> implements ISupplierChangeFlowService{

    @Autowired
    private SessionManager sessionManager;

    @Override
    public SupplierChangeFlowVO saveOrUpdate(SupplierChangeFlowVO saveOrUpdateVO) {
        SupplierChangeFlowEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierChangeFlowEntity.class);
        UserContext user = sessionManager.getUserContext();
        entity.setOperatorId(user.getUserId());
        entity.setOperatorCode(user.getUserCode());
        entity.setOperatorName(user.getUserName());
        entity.setOperatorPhone(user.getUserMobile());
        entity.setOperateTime(new Date());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, SupplierChangeFlowVO.class);
    }
}
