package com.ejianc.business.zdssupplier.sub.service.impl;

import com.ejianc.business.zdssupplier.sub.bean.SupplierHistoryEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierHistoryMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierHistoryService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 分包供应商历史
 * 
 * @author generator
 * 
 */
@Service("supplierHistoryService")
public class SupplierHistoryServiceImpl extends BaseServiceImpl<SupplierHistoryMapper, SupplierHistoryEntity> implements ISupplierHistoryService {

    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_HISTORY";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public SupplierHistoryVO saveOrUpdate(SupplierHistoryVO saveOrUpdateVO) {
        SupplierHistoryEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierHistoryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        SupplierHistoryVO vo = BeanMapper.map(entity, SupplierHistoryVO.class);
        return vo;
    }
}
