package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierInviteEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierInviteFlowEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierInviteMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteFlowService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteFlowVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包供应商邀请链接
 * 
 * @author generator
 * 
 */
@Service("supplierInviteService")
public class SupplierInviteServiceImpl extends BaseServiceImpl<SupplierInviteMapper, SupplierInviteEntity> implements ISupplierInviteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_INVITE";//此处需要根据实际修改
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.分包供应商邀请.getCode();
    private static final String BILL_NAME = BillTypeEnum.分包供应商邀请.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierInvite/syncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierInvite/syncBill";

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISupplierInviteFlowService flowService;

    @Autowired
    private ISupplierAccessService accessService;

    @Autowired
    private ISupplierService supplierService;

    @Override
    public SupplierInviteVO saveOrUpdate(SupplierInviteVO saveOrUpdateVO) {
        SupplierInviteEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierInviteEntity.class);

        // 已经在分包供应商档案或已存在邀请中的链接时不允许邀请
        this.validateName(entity.getSupplierName(), entity.getId());

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setInviterPhone(sessionManager.getUserContext().getUserMobile());
        }
        super.saveOrUpdate(entity, false);

        // 单据协同推送
        this.pushBillToSupCenter(entity);

        return BeanMapper.map(entity, SupplierInviteVO.class);
    }

    /**
     * 已经在分包供应商档案或已存在邀请中的链接时不允许邀请
     * @param supplierName
     * @param id
     * @return
     */
    private Boolean validateName(String supplierName, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierName", new Parameter(QueryParam.EQ, supplierName));
        // 排除已作废
        param.getParams().put("status", new Parameter(QueryParam.NE, PlanConstant.INVITE_STATUS_INVALID));
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SupplierInviteEntity> inviteList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(inviteList)){
            throw new BusinessException("该供应商名称已生成邀请中链接【" + inviteList.get(0).getBillCode() + "】，不允许重复邀请！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, supplierName));
        List<SupplierEntity> supplierList = supplierService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(supplierList)){
            throw new BusinessException("该供应商已经入库，请勿重复添加！");
        }
        return true;
    }

    @Override
    public boolean pushBillToSupCenter(SupplierInviteEntity entity) {
        Long sourceId = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), SYSTEM_ID,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        if(sourceId != null){
            entity.setSourceId(sourceId);
            entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());

            // 向邀请邮箱发送邮件
            this.sendEmail(entity);
            // 向邀请电话发送短信
            this.sendSms(entity);

            // 生成流水
            SupplierInviteFlowVO flow = new SupplierInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType(PlanConstant.FLOW_TYPE_INVITE.toString());
            flowService.saveOrUpdate(flow);
        } else {
            logger.error("单据-{}id-{}推送供方服务失败", BILL_NAME, entity.getId());
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        super.saveOrUpdate(entity, false);
        return true;
    }

    @Override
    public String updateBillStatus(SupplierInviteVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(SupplierInviteVO vo, Boolean saveFlag) {
        // 代注册无需更新状态及生成流水
        if(vo.getId() == null){
            return null;
        }
        // 查询当前用户信息
        SupplierInviteEntity entity = super.selectById(vo.getId());
        // 校验业务状态
        pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        // 驳回原因
        if(StringUtils.isNotEmpty(vo.getBackReason())){
            entity.setBackReason(vo.getBackReason());
        }
        // 供方推送无需推送供方
        if(!saveFlag){
            pushSupUtil.updateBillStatus((JSONObject) JSONObject.toJSON(entity),
                    "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        // 已准入
        if(PlanConstant.INVITE_STATUS_APPROVE.equals(vo.getStatus())){
            // 向邀请邮箱发送注册成功邮件
            this.sendApproveEmail(entity);
            // 向邀请电话发送注册成功短信
            this.sendApproveSms(entity);
        }
        // 已驳回
        if(PlanConstant.INVITE_STATUS_BACK.equals(vo.getStatus())){
            // 向邀请邮箱发送注册驳回邮件
            this.sendBackEmail(entity);
        }
        super.saveOrUpdate(entity);
        if(saveFlag){
            // 供方推送过来的数据操作人为供方登录人，生成流水
            SupplierInviteFlowEntity flow = new SupplierInviteFlowEntity();
            flow.setInviteId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getInviterId());
            flow.setOperatorName(vo.getInviterName());
            flow.setOperateTime(new Date());
            flowService.saveOrUpdate(flow, false);
        } else {
            // 生成流水
            SupplierInviteFlowVO flow = new SupplierInviteFlowVO();
            flow.setInviteId(entity.getId());
            // 更新状态flowType必传，否则流转状态有可能不对应
            flow.setFlowType(StringUtils.isNotEmpty(vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            flowService.saveOrUpdate(flow);
        }
        // 驳回删除准入
        if(PlanConstant.INVITE_STATUS_BACK.equals(vo.getStatus())){
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter(QueryParam.EQ, entity.getId()));
            List<SupplierAccessEntity> list = accessService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
                accessService.removeByIds(ids, true);
            }
        }
        return null;
    }

    /**
     * 向邀请电话发送短信
     * @param entity
     */
    private void sendSms(SupplierInviteEntity entity) {
        Map<String, String> params = new HashMap<>();
        params.put("path", entity.getInviteCode());
        params.put("name", entity.getInviterName());
        params.put("phone", entity.getInviterPhone());
        pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), PlanConstant.供应商邀请短信模板编码, PlanConstant.SIGN_NAME, params);
    }

    /**
     * 向邀请邮箱发送邮件
     * @param entity
     */
    private void sendEmail(SupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("中电四公司邀请您办理企业入库，请点击下方链接完成注册");
        content.append(entity.getInviteUrl());
        content.append("，该链接请勿外传，如有疑问，请联系:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getSupplierName());
        pushSupUtil.sendEmail(null, "notice","供应商邀请邮件", content.toString(), params, entity.getInviteUrl(), null);
    }

    /**
     * 向邀请电话发送注册成功短信
     * @param entity
     */
    private void sendApproveSms(SupplierInviteEntity entity) {
        Map<String, String> params = new HashMap<>();
        params.put("path", pushSupUtil.SSO);
        params.put("name", entity.getSupplierName());
        params.put("phone", entity.getLinkPhone());
        pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), PlanConstant.供应商注册成功短信模板编码, PlanConstant.SIGN_NAME, params);
    }

    /**
     * 向邀请邮箱发送注册成功邮件
     * @param entity
     */
    private void sendApproveEmail(SupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("【");
        content.append(entity.getSupplierName());
        content.append("】公司，恭喜贵司通过中电四分供方入库审核，已为您开通分供方协同账号，请点击下方链接");
        String url = pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("，进行登录，登录账号:");
        content.append(entity.getLinkPhone());
        content.append("，首次登录采用短信验证码进行验证");
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getSupplierName());
        pushSupUtil.sendEmail(null, "notice","供应商注册成功邮件", content.toString(), params, url, null);
    }

    /**
     * 向邀请邮箱发送注册驳回邮件
     * @param entity
     */
    private void sendBackEmail(SupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("中电四公司已驳回了您办理的企业入库，请点击下方链接重新注册");
        content.append(entity.getInviteUrl());
        content.append("，该链接请勿外传，如有疑问，请联系:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", entity.getLinkEmail());
        params.put("userNames", entity.getSupplierName());
        pushSupUtil.sendEmail(null, "notice","供应商注册驳回邮件", content.toString(), params, entity.getInviteUrl(), null);
    }
}
