package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierManagerMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包供应商档案-项目经理
 *
 * @author generator
 */
@Service("supplierManagerService")
public class SupplierManagerServiceImpl extends BaseServiceImpl<SupplierManagerMapper, SupplierManagerEntity> implements ISupplierManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CoordinationUtil coordinationUtil;

    @Override
    public SupplierManagerVO createSupAccount(SupplierManagerEntity entity, Long supTenantId) {
        logger.info("项目经理id-{}生成供方supTenant-{}协同账户-------start", entity.getId(), supTenantId);
        if (StringUtils.isBlank(entity.getMobileLinkPhone())) {
            throw new BusinessException("项目经理电话为空");
        }
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("linkMobile", entity.getMobileLinkPhone());
        reqParam.put("linkName", entity.getProjectManagerName());
        reqParam.put("linkSupType", PlanConstant.SUB_SUPPLIER);
        reqParam.put("supplierAccRole", PlanConstant.分包项目经理);
        reqParam.put("supplierTenantId", supTenantId.toString());
        reqParam.put("accRoleCheck", Boolean.TRUE.toString());
        reqParam.put("supplierId", entity.getSupplierId().toString());
        reqParam.put("billId", entity.getId().toString());

        // 联系人生成协同账号
        JSONObject resp = coordinationUtil.createSupAccount(reqParam);

        entity.setCoordination(PlanConstant.STRING_YES);
        entity.setSynergyAccountStatus(PlanConstant.INTEGER_YES);
        entity.setTenant(resp.getLong("tenantId"));
        entity.setSupUserId(resp.getLong("userId"));
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, SupplierManagerVO.class);
    }

    @Override
    public List<SupplierManagerEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper<SupplierManagerEntity> query = new QueryWrapper<>();
        query.in("supplier_id", supplierIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }
}
