package com.ejianc.business.zdssupplier.utils;

import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/27 15:40
 */
@Component
public class ZDSReqUtil {

    private static String ERP_APPID;
    private static String ERP_SECRET;
    private static String ERP_REQ_HOST;
    private static String ERP_DATA_BATCH_SIZE;
    public static final int CONN_TIME_OUT = 120000;
    public static final int READ_TIME_OUT = 120000;

    public static String getErpAppid() {
        return ERP_APPID;
    }

    @Value("${erp.appId}")
    public void setErpAppid(String appId) {
        ERP_APPID = appId;
    }

    public static String getErpSecret() {
        return ERP_SECRET;
    }

    @Value("${erp.secret}")
    public void setErpSecret(String secret) {
        ERP_SECRET = secret;
    }

    public static String getErpReqHost() {
        return ERP_REQ_HOST;
    }

    @Value("${erp.reqHost}")
    public void setErpReqHost(String reqHost) {
        ERP_REQ_HOST = reqHost;
    }

    public static String getErpDataBatchSize() {
        return ERP_DATA_BATCH_SIZE;
    }

    @Value("${erp.batchSize:100}")
    public void setErpDataBatchSize(String batchSize) {
        ERP_DATA_BATCH_SIZE = batchSize;
    }

    public static Map<String, String> getErpHeaders() throws Exception {
        Map<String, String> headers = new HashMap<>();
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        headers.put("appid", toMD5(ERP_APPID));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(ERP_SECRET + toMD5(ERP_APPID) + toMD5(nowStr)));

        return headers;
    }

    public static Map<String, String> getErpHeader(String appId, String secret) throws Exception {
        Map<String, String> headers = new HashMap<>();
        String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
        headers.put("appid", toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));

        return headers;
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString().toLowerCase();
    }

    public static String changeLongToGUID(Long longNum) {
        return new UUID(longNum, longNum >> 64).toString();
    }
}
