/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.constants.ERPInquiryStatus;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.InquiryVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.base.Stopwatch;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inquiry"})
public class InquiryController {
    private Logger logger = LoggerFactory.getLogger(InquiryController.class);
    @Autowired
    private IMatSupplierService matSupplierService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IMatLinkerService matLinkerService;
    @Autowired
    private ILinkerService linkerService;
    @Value(value="${erp.sso.host}")
    private String ERP_SSO_HOST;
    private final String INQUIRY_URL = "/cefoc/yql/TenderingListNew";
    private final String ERP_INQUIRY_SSO_URL = "/SignLogin/SignLogin";

    @GetMapping(value={"/refInquiryData"})
    public CommonResponse<JSONObject> refInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam Long supplierTenant, @RequestParam Long linkerSupUserId, String condition, String searchObject, String searchText) throws Exception {
        MatLinkerVO linker;
        MatSupplierVO supplier;
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageNumber);
        resp.put("pageSize", (Object)pageSize);
        if (StringUtils.isEmpty((CharSequence)condition) || !JSONObject.parseObject((String)condition).containsKey((Object)"supplierType")) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u7c7b\u578b\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25\uff01");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String supplierType = _con.getString("supplierType");
        String supplierSID = null;
        String linkerSid = null;
        String supplierName = null;
        String linkerName = null;
        if ("material".equals(supplierType)) {
            supplier = this.matSupplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName = supplier.getName();
            linkerName = linker.getName();
        } else {
            supplier = this.supplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName = supplier.getName();
            linkerName = linker.getName();
        }
        Map<String, String> headers = null;
        Integer queryPageNum = 1;
        Integer queryPageSize = 1000;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/TenderingListNew" + "?CompanyOID=" + supplierSID;
        if (StringUtils.isNotBlank((CharSequence)linkerSid)) {
            reqUrl = reqUrl + "&ContactsSid=" + linkerSid + "&ContactsOID=" + linkerSid;
        }
        if (StringUtils.isNotBlank((CharSequence)linkerName)) {
            reqUrl = reqUrl + "&Contacts=" + linkerName;
        }
        headers = ZdsReqUtil.getErpHeaders();
        param.put("PageSize", (Object)queryPageSize);
        param.put("PageNum", (Object)queryPageNum);
        try {
            Stopwatch start = Stopwatch.createStarted();
            this.logger.info("\u4f9b\u5e94\u5546name-{},CompanyOID-{},\u8054\u7cfb\u4ebaname-{},ContactSid-{}\uff0c\u8be2\u4ef7\u5217\u8868\u67e5\u8be2\u5730\u5740\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{supplierName, supplierSID, linkerName, linkerSid, reqUrl, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            JSONObject reqJson = null;
            JSONArray pageData = null;
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("Tendering");
                if (pageData.size() == 0) {
                    resp.put("total", (Object)0);
                    resp.put("records", new ArrayList());
                    return CommonResponse.success((Object)resp);
                }
                JSONObject tmp = null;
                JSONObject inquiry = null;
                InquiryVO tmpInquiry = null;
                ArrayList<InquiryVO> records = new ArrayList<InquiryVO>();
                for (Object obj : pageData) {
                    inquiry = tmp = (JSONObject)obj;
                    tmpInquiry = new InquiryVO();
                    if (StringUtils.isNotBlank((CharSequence)searchText) && !inquiry.getString("Package_Name").contains(searchText) && !inquiry.getString("TenderContent").contains(searchText) && !inquiry.getString("Project_Name").contains(searchText)) continue;
                    tmpInquiry.setTitle(inquiry.getString("Package_Name"));
                    tmpInquiry.setId(inquiry.getString("C_SCM_TenderingOID"));
                    tmpInquiry.setContent(inquiry.getString("TenderContent"));
                    tmpInquiry.setInquiryRounds(inquiry.getInteger("ProcurePlanNum"));
                    tmpInquiry.setProjectName(inquiry.getString("Project_Name"));
                    tmpInquiry.setExecUnitName(inquiry.getString("DeptName"));
                    records.add(tmpInquiry);
                }
                int startRn = pageNumber < 1 ? 0 : (pageNumber - 1) * pageSize;
                int endRn = pageNumber < 1 ? pageSize : pageNumber * pageSize;
                resp.put("total", (Object)records.size());
                resp.put("records", records.size() > startRn ? records.subList(startRn, records.size() > endRn ? endRn : records.size()) : new ArrayList());
                return CommonResponse.success((Object)resp);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546SID-{}\uff0c\u8054\u7cfb\u4ebaSID-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u8be2\u4ef7\u5217\u8868\u5f02\u5e38\uff0c", new Object[]{supplierTenant.toString(), linkerSupUserId.toString(), e});
            return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u8be2\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u8be2\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
    }

    @GetMapping(value={"getInquiryList"})
    public CommonResponse<JSONObject> getInquiryList(@RequestParam Long supplierTenant, @RequestParam Long linkerSupUserId, @RequestParam String supplierType) {
        MatLinkerVO linker;
        MatSupplierVO supplier;
        JSONObject resp = new JSONObject();
        String supplierSID = null;
        String linkerSid = null;
        String supplierName = null;
        String linkerName = null;
        if ("material".equals(supplierType)) {
            supplier = this.matSupplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName = supplier.getName();
            linkerName = linker.getName();
        } else {
            supplier = this.supplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            linkerSid = linker.getThirdSourceId();
            supplierName = supplier.getName();
            linkerName = linker.getName();
        }
        Map<String, String> headers = null;
        Integer pageNum = 1;
        Integer pageSize = 1000;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/TenderingListNew" + "?CompanyOID=" + supplierSID;
        if (StringUtils.isNotBlank((CharSequence)linkerSid)) {
            reqUrl = reqUrl + "&ContactsSid=" + linkerSid + "&ContactsOID=" + linkerSid;
        }
        if (StringUtils.isNotBlank((CharSequence)linkerName)) {
            reqUrl = reqUrl + "&Contacts=" + linkerName;
        }
        HashMap<String, InquiryVO> waitMap = new HashMap<String, InquiryVO>();
        HashMap<String, InquiryVO> inquiryIngMap = new HashMap<String, InquiryVO>();
        HashMap<String, InquiryVO> failedMap = new HashMap<String, InquiryVO>();
        HashMap<String, InquiryVO> stopMap = new HashMap<String, InquiryVO>();
        HashMap<String, InquiryVO> winMap = new HashMap<String, InquiryVO>();
        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", (Object)pageSize);
            param.put("PageNum", (Object)pageNum);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            Stopwatch start = Stopwatch.createStarted();
            this.logger.info("\u4f9b\u5e94\u5546name-{},CompanyOID-{},\u8054\u7cfb\u4ebaname-{},ContactSid-{}\uff0c\u8be2\u4ef7\u5217\u8868\u67e5\u8be2\u5730\u5740\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{supplierName, supplierSID, linkerName, linkerSid, reqUrl, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            this.logger.info("\u8bf7\u6c42ERP\u8be2\u4ef7\u5217\u8868\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("Tendering");
                this.logger.info("\u8bf7\u6c42ERP\u8be2\u4ef7\u5217\u8868\u8fd4\u56de\u6570\u636e\uff1a{} \u6761", (Object)(null != pageData ? pageData.size() : 0));
                this.handlePageData(pageData, reqJson.getJSONArray("SupplierPriceAud_SubCList"), waitMap, inquiryIngMap, failedMap, stopMap, winMap, reqJson.getJSONArray("SupplierPriceAudList"), supplierSID, reqJson.getJSONArray("SupplierSignupList"), linkerSid);
                resp.put("waitList", waitMap.values());
                resp.put("inquiryingList", inquiryIngMap.values());
                resp.put("failedList", failedMap.values());
                resp.put("stopList", stopMap.values());
                resp.put("winList", waitMap.values());
                this.logger.info("\u4f9b\u5e94\u5546\uff1asid-{}\uff0cname-{}\u8be2\u4ef7\u7edf\u8ba1*************", (Object)supplierSID, (Object)supplierName);
                this.logger.info("\u603b\u6570\u91cf\uff1a{}", (Object)(waitMap.size() + inquiryIngMap.size() + failedMap.size() + stopMap.size() + winMap.size()));
                this.logger.info("\u5f85\u62a5\u4ef7\u6570\u91cf\uff1a{}", (Object)waitMap.size());
                this.logger.info("\u62a5\u4ef7\u4e2d\uff1a{}", (Object)inquiryIngMap.size());
                this.logger.info("\u672a\u4e2d\u6807\u6570\u91cf\uff1a{}", (Object)failedMap.size());
                this.logger.info("\u4e2d\u6b62\u4ef7\u6570\u91cf\uff1a{}", (Object)stopMap.size());
                this.logger.info("\u4e2d\u6807\u6570\u91cf\uff1a{}", (Object)winMap.size());
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
            }
            this.logger.error("\u8bf7\u6c42ERP\u8be2\u4ef7\u5217\u8868\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)param), (Object)reqResp);
            return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u8be2\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546SID-{}\uff0c\u8054\u7cfb\u4ebaSID-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u8be2\u4ef7\u5217\u8868\u5f02\u5e38\uff0c", new Object[]{supplierTenant.toString(), linkerSupUserId.toString(), e});
            return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u8be2\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private JSONObject handlePageData(JSONArray pageData, JSONArray supplierPriceAudSubCList, Map<String, InquiryVO> waitMap, Map<String, InquiryVO> inquiryIngMap, Map<String, InquiryVO> failedMap, Map<String, InquiryVO> stopMap, Map<String, InquiryVO> winMap, JSONArray priceAudList, String supplierSId, JSONArray supplierSignList, String linkerSid) {
        JSONObject resp = new JSONObject();
        JSONObject tmp = null;
        HashMap<String, JSONObject> loginMap = new HashMap<String, JSONObject>();
        if (null != supplierSignList) {
            for (Object obj : supplierSignList) {
                tmp = (JSONObject)obj;
                if (!StringUtils.equals((CharSequence)tmp.getString("SupplierSID"), (CharSequence)supplierSId.toLowerCase()) || !StringUtils.equals((CharSequence)tmp.getString("ContactsSid"), (CharSequence)linkerSid.toLowerCase())) continue;
                loginMap.put(tmp.getString("Tendering_FK"), tmp);
            }
        }
        HashMap<String, BigDecimal> offerMap = new HashMap<String, BigDecimal>();
        if (null != supplierPriceAudSubCList) {
            for (Object obj : supplierPriceAudSubCList) {
                tmp = (JSONObject)obj;
                if (!supplierSId.toLowerCase().equals(tmp.getString("SupplierSID"))) continue;
                offerMap.put(tmp.getString("Tendering_FK"), tmp.getBigDecimal("Offer"));
            }
        }
        HashMap<String, String> bidMap = new HashMap<String, String>();
        if (null != priceAudList) {
            for (Object obj : priceAudList) {
                tmp = (JSONObject)obj;
                if ("true".equals(bidMap.get(tmp.getString("Tendering_FK"))) || !supplierSId.toLowerCase().equals(tmp.getString("SupplierSID"))) continue;
                bidMap.put(tmp.getString("Tendering_FK"), tmp.getString("IsZhongBiao"));
            }
        }
        Long curMilSec = System.currentTimeMillis();
        if (null != pageData && pageData.size() > 0) {
            JSONObject inquiry = null;
            InquiryVO tmpInquiry = null;
            block19: for (Object obj : pageData) {
                inquiry = tmp = (JSONObject)obj;
                tmpInquiry = new InquiryVO();
                tmpInquiry.setTitle(inquiry.getString("Package_Name"));
                tmpInquiry.setId(inquiry.getString("C_SCM_TenderingOID"));
                tmpInquiry.setContent(inquiry.getString("TenderContent"));
                tmpInquiry.setInquiryRounds(inquiry.getInteger("ProcurePlanNum"));
                tmpInquiry.setProjectName(inquiry.getString("Project_Name"));
                tmpInquiry.setExecUnitName(inquiry.getString("DeptName"));
                tmpInquiry.setEndTime(DateUtil.parseDate(inquiry.getString("PriceLastDate").replace("T", " "), "yyyy-MM-dd HH:mm:ss"));
                tmpInquiry.setRemainingMilSec(Long.valueOf(tmpInquiry.getEndTime().getTime() < curMilSec ? 0L : tmpInquiry.getEndTime().getTime() - curMilSec));
                tmpInquiry.setLoginName(inquiry.getString("LoginName"));
                tmpInquiry.setLoginPwd(inquiry.getString("LoginPwd"));
                if (StringUtils.isBlank((CharSequence)tmpInquiry.getLoginName()) && loginMap.containsKey(tmpInquiry.getId())) {
                    tmpInquiry.setLoginName(((JSONObject)loginMap.get(tmpInquiry.getId())).getString("LoginName"));
                    tmpInquiry.setLoginPwd(((JSONObject)loginMap.get(tmpInquiry.getId())).getString("LoginPwd"));
                }
                ERPInquiryStatus status = null;
                if (waitMap.containsKey(tmpInquiry.getId())) {
                    waitMap.remove(tmpInquiry.getId());
                }
                if (inquiryIngMap.containsKey(tmpInquiry.getId())) {
                    inquiryIngMap.remove(tmpInquiry.getId());
                }
                if (failedMap.containsKey(tmpInquiry.getId())) {
                    failedMap.remove(tmpInquiry.getId());
                }
                if (stopMap.containsKey(tmpInquiry.getId())) {
                    stopMap.remove(tmpInquiry.getId());
                }
                if (winMap.containsKey(tmpInquiry.getId())) {
                    winMap.remove(tmpInquiry.getId());
                }
                switch (inquiry.getString("PackageState")) {
                    case "1": 
                    case "2": 
                    case "3": {
                        if (tmpInquiry.getRemainingMilSec() <= 0L) {
                            this.logger.info("\u62a5\u4ef7\u4fe1\u606f\uff1a{}\u62a5\u540d\u5df2\u7ed3\u675f,\u8df3\u8fc7~\uff01", (Object)JSONObject.toJSONString((Object)tmpInquiry));
                            continue block19;
                        }
                        status = ERPInquiryStatus.UN_QUOTATION;
                        waitMap.put(tmpInquiry.getId(), tmpInquiry);
                        break;
                    }
                    case "4": 
                    case "5": {
                        status = ERPInquiryStatus.QUOTING;
                        inquiryIngMap.put(tmpInquiry.getId(), tmpInquiry);
                        break;
                    }
                    case "6": 
                    case "7": {
                        if ("false".equals(bidMap.get(tmpInquiry.getId()))) {
                            status = ERPInquiryStatus.UN_BID;
                            failedMap.put(tmpInquiry.getId(), tmpInquiry);
                            break;
                        }
                        status = ERPInquiryStatus.BIDED;
                        this.logger.info("\u5f53\u524d\u5df2\u4e2d\u6807:{}\uff0c\u4e0d\u505a\u5c55\u793a\uff0c\u8df3\u8fc7~\uff01", (Object)JSONObject.toJSONString((Object)tmpInquiry));
                        winMap.put(tmpInquiry.getId(), tmpInquiry);
                        break;
                    }
                    case "8": {
                        status = ERPInquiryStatus.STOP_QUOTATION;
                        stopMap.put(tmpInquiry.getId(), tmpInquiry);
                        break;
                    }
                    default: {
                        status = ERPInquiryStatus.UN_KNOWN;
                    }
                }
                tmpInquiry.setInsuredAmt(offerMap.containsKey(tmpInquiry.getId()) ? (BigDecimal)offerMap.get(tmpInquiry.getId()) : BigDecimal.ZERO);
                tmpInquiry.setStatus(status.getCode());
                tmpInquiry.setStatusName(status.getName());
            }
        }
        return resp;
    }

    @GetMapping(value={"getErpInquirySsoUrl"})
    public CommonResponse<JSONObject> getErpInquiryUrl(@RequestParam String loginName, @RequestParam Long linkerSupUserId, @RequestParam Long supplierTenant, @RequestParam String supplierType) {
        MatLinkerVO linker;
        MatSupplierVO supplier;
        JSONObject resp = new JSONObject();
        Map<String, String> params = null;
        String linkerPhone = null;
        StringBuilder ssoUrl = new StringBuilder();
        String reqUrl = this.ERP_SSO_HOST + "/SignLogin/SignLogin";
        if ("material".equals(supplierType)) {
            supplier = this.matSupplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            linkerPhone = linker.getMobileLinkPhone();
        } else {
            supplier = this.supplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            linkerPhone = linker.getMobileLinkPhone();
        }
        try {
            params = ZdsReqUtil.getErpHeaders();
            params.put("phone", linkerPhone);
            params.put("LoginName", loginName);
            JSONObject reqJson = null;
            Stopwatch start = Stopwatch.createStarted();
            String reqResp = HttpTookit.get((String)reqUrl, params, new HashMap(), (int)ZdsReqUtil.DEFAULT_TIME_OUT, (int)ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            this.logger.info("\u8bf7\u6c42ERP\u4f9b\u65b9\u62a5\u4ef7\u8fde\u63a5\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
            this.logger.info("\u8bf7\u6c42ERP\u4f9b\u65b9\u62a5\u4ef7\u8fde\u63a5\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)reqResp);
            reqJson = JSONObject.parseObject((String)reqResp.replaceAll(" ", ""));
            if ("true".equals(reqJson.getString("status"))) {
                ssoUrl.append(reqJson.getString("data")).append("?LoginName=").append(loginName).append("&phone=").append(linkerPhone).append("&Ticket=").append(params.get("ticket")).append("&appid=").append(params.get("appid")).append("&sign=").append(params.get("sign")).append("&loginsid=").append(reqJson.getString("loginsid"));
                resp.put("ssoUrl", (Object)ssoUrl.toString());
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
            }
            this.logger.error("\u8bf7\u6c42ERP\u8be2\u4ef7\u5217\u8868\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(params), (Object)reqResp);
            return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u65b9\u62a5\u4ef7\u5355\u70b9\u8fde\u63a5\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4f9b\u65b9\u62a5\u4ef7\u5355\u70b9\u8fde\u63a5\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(params), (Object)e);
            return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u65b9\u62a5\u4ef7\u5355\u70b9\u8fde\u63a5\u5931\u8d25\uff01");
        }
    }
}

