/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.service.impl.MatSupplierChangeBpmServiceImpl;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matSupplierChange"})
public class MatSupplierChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_CHANGE";
    @Autowired
    private IMatSupplierChangeService service;
    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;
    @Autowired
    private IMatSupplierChangeMaterialInfoService changeMaterialInfoService;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private MatSupplierChangeBpmServiceImpl bpmService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> saveOrUpdate(@RequestBody MatSupplierChangeVO saveOrUpdateVO) {
        MatSupplierChangeVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(vo.getSupplierId()));
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> queryDetail(Long id) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(id));
        MatSupplierChangeVO vo = (MatSupplierChangeVO)BeanMapper.map((Object)((Object)entity), MatSupplierChangeVO.class);
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatSupplierChangeVO matSupplierChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_EL));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListBySupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> queryListBySupplier(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_SUPPLIER));
        CommonResponse categoryIdsResp = this.izdsMatSupManagerApi.getCategoryIdsByUseId(InvocationInfoProxy.getUserid());
        if (!categoryIdsResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4eba\u5458-{}\u5ba1\u6838\u7269\u8d44\u5206\u7c7b\u5217\u8868\u5931\u8d25, {}", (Object)InvocationInfoProxy.getUserid(), (Object)JSONObject.toJSONString((Object)categoryIdsResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u83b7\u53d6\u7269\u8d44\u5206\u7c7b\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List categoryIds = (List)categoryIdsResp.getData();
        if (CollectionUtils.isEmpty((Collection)categoryIds)) {
            Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List<Long> changeIds = this.changeMaterialInfoService.getAllSupIdsByCategoryIds(categoryIds);
        if (CollectionUtils.isEmpty(changeIds)) {
            Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        param.getParams().put("id", new Parameter("in", changeIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatSupplierChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatSupplierChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierChangeVO>> refMatSupplierChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveChangeBySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatSupplierChangeVO> saveChangeBySupplierId(@RequestParam Long id) {
        MatSupplierChangeVO vo = this.service.saveChangeBySupplierId(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/TYCDetail"}, method={RequestMethod.GET})
    @ResponseBody
    @Ignore
    public CommonResponse<MatSupplierChangeVO> TYCDetail(@RequestParam(value="supplierName") String supplierName, @RequestParam(value="supplierId") Long supplierId, @RequestParam(value="id", required=false) Long id) {
        MatSupplierChangeVO vo = this.service.TYCDetail(supplierName, supplierId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveSyncBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveSyncBill(request));
    }

    @PostMapping(value={"/updateBillStatus"})
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody MatSupplierChangeVO vo) {
        String msg = this.service.updateBillStatus(vo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/contrast"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long changeId) {
        JSONObject contrast = this.service.contrast(changeId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)contrast);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
        CommonResponse<String> response = this.bpmService.afterApprovalProcessor(id, null, null);
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(id));
        entity.setBillState(1);
        this.service.updateById((Object)entity);
        return response;
    }
}

